/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclaredMembers
implements Iterable<Member> {
    private final Class<?> clazz;
    private final View[] views;

    public DeclaredMembers(Class<?> clazz, View ... views) {
        this.clazz = clazz;
        this.views = views.length == 0 ? View.values() : views;
    }

    @Override
    public Iterator<Member> iterator() {
        return new MemberIterator(this.clazz, this.views);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MemberIterator
    implements Iterator<Member> {
        private static final Member[] NO_MEMBERS = new Member[0];
        private Class<?> clazz;
        private final View[] views;
        private int viewIndex;
        private Member[] members = NO_MEMBERS;
        private int memberIndex;

        MemberIterator(Class<?> clazz, View[] views) {
            this.clazz = MemberIterator.filterClass(clazz);
            this.views = views;
        }

        @Override
        public boolean hasNext() {
            while (this.memberIndex <= 0) {
                if (this.viewIndex >= this.views.length) {
                    this.clazz = MemberIterator.filterClass(this.clazz.getSuperclass());
                    this.viewIndex = 0;
                }
                if (null == this.clazz) {
                    return false;
                }
                try {
                    this.members = this.views[this.viewIndex++].members(this.clazz);
                    this.memberIndex = this.members.length;
                }
                catch (Throwable e) {
                    this.clazz = null;
                    this.viewIndex = 0;
                    return false;
                }
            }
            return true;
        }

        @Override
        public Member next() {
            if (this.hasNext()) {
                return this.members[--this.memberIndex];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static Class<?> filterClass(Class<?> clazz) {
            return null == clazz || clazz.getName().startsWith("java.") ? null : clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        CONSTRUCTORS{

            @Override
            final Member[] members(Class<?> clazz) {
                return clazz.getDeclaredConstructors();
            }
        }
        ,
        METHODS{

            @Override
            final Member[] members(Class<?> clazz) {
                return clazz.getDeclaredMethods();
            }
        }
        ,
        FIELDS{

            @Override
            final Member[] members(Class<?> clazz) {
                return clazz.getDeclaredFields();
            }
        };


        abstract Member[] members(Class<?> var1);
    }
}

