/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.sonatype.guice.bean.locators.HiddenBinding;
import org.sonatype.guice.bean.locators.RankingFunction;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InjectorPublisher
implements BindingPublisher {
    private final Injector injector;
    private final RankingFunction function;

    InjectorPublisher(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
    }

    @Override
    public <T> void subscribe(TypeLiteral<T> type, BindingSubscriber importer) {
        List bindings = this.injector.findBindingsByType(type);
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (binding.getSource() instanceof HiddenBinding) continue;
            importer.add(binding, this.function.rank(binding));
        }
    }

    @Override
    public <T> boolean contains(Binding<T> binding) {
        return binding == this.injector.getBindings().get(binding.getKey());
    }

    @Override
    public <T> void unsubscribe(TypeLiteral<T> type, BindingSubscriber importer) {
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorPublisher) {
            return this.injector.equals(((InjectorPublisher)rhs).injector);
        }
        return false;
    }
}

