/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.PrintStreamLogger;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    public static final int MS_PER_SEC = 1000;
    public static final int SEC_PER_MIN = 60;

    public static void showVersion(PrintStream stdout) {
        Properties properties = CLIReportingUtils.getBuildProperties();
        String timestamp = CLIReportingUtils.reduce(properties.getProperty("timestamp"));
        String version = CLIReportingUtils.reduce(properties.getProperty("version"));
        String rev = CLIReportingUtils.reduce(properties.getProperty("buildNumber"));
        String msg = "Apache Maven ";
        msg = msg + (version != null ? version : "<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? "r" + rev : "");
            if (timestamp != null) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                String ts = fmt.format(new Date(Long.valueOf(timestamp)));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        stdout.println(msg);
        stdout.println("Java version: " + System.getProperty("java.version", "<unknown java version>") + ", vendor: " + System.getProperty("java.vendor", "<unknown vendor>"));
        stdout.println("Java home: " + System.getProperty("java.home", "<unknown java home>"));
        stdout.println("Default locale: " + Locale.getDefault() + ", platform encoding: " + System.getProperty("file.encoding", "<unknown encoding>"));
        stdout.println("OS name: \"" + Os.OS_NAME + "\", version: \"" + Os.OS_VERSION + "\", arch: \"" + Os.OS_ARCH + "\", family: \"" + Os.OS_FAMILY + "\"");
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    private static void stats(Date start, Logger logger) {
        Date finish = new Date();
        long time = finish.getTime() - start.getTime();
        logger.info("Total time: " + CLIReportingUtils.formatTime(time));
        logger.info("Finished at: " + finish);
        System.gc();
        Runtime r = Runtime.getRuntime();
        logger.info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M");
    }

    private static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        String msg = "";
        if (min > 1L) {
            msg = min + " minutes ";
        } else if (min == 1L) {
            msg = "1 minute ";
        }
        if (secs > 1L) {
            msg = msg + secs + " seconds";
        } else if (secs == 1L) {
            msg = msg + "1 second";
        } else if (min == 0L) {
            msg = msg + "< 1 second";
        }
        return msg;
    }

    private static String getFormattedTime(long time) {
        String pattern = "s.SSS's'";
        if (time / 60000L > 0L) {
            pattern = "m:s" + pattern;
            if (time / 3600000L > 0L) {
                pattern = "H:m" + pattern;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getBuildProperties() {
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        finally {
            IOUtil.close((InputStream)resourceAsStream);
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (logger == null) {
            logger = new PrintStreamLogger(System.out);
        }
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    logger.error("Caused by: " + cause.getMessage());
                }
            }
        }
    }
}

