/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.FormUtils;
import org.eclipse.m2e.editor.pom.IPomFileChangedListener;
import org.eclipse.m2e.editor.pom.Matcher;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.m2e.editor.pom.SearchControl;
import org.eclipse.m2e.editor.pom.SearchMatcher;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class DependencyTreePage
extends FormPage
implements IMavenProjectChangedListener,
IPomFileChangedListener {
    private static final Logger log = LoggerFactory.getLogger(DependencyTreePage.class);
    protected static final Object[] EMPTY = new Object[0];
    final MavenPomEditor pomEditor;
    TreeViewer treeViewer;
    TableViewer listViewer;
    SearchControl searchControl;
    SearchMatcher searchMatcher;
    DependencyFilter searchFilter;
    ListSelectionFilter listSelectionFilter;
    ViewerFilter currentFilter;
    ArrayList<DependencyNode> dependencyNodes = new ArrayList();
    Color searchHighlightColor;
    MavenProject mavenProject;
    boolean isSettingSelection = false;
    Action hierarchyFilterAction;
    private Job dataLoadingJob;
    String currentClasspath = "test";

    public DependencyTreePage(MavenPomEditor pomEditor) {
        super((FormEditor)pomEditor, "org.eclipse.m2e.core.pom.dependencyTree", Messages.DependencyTreePage_title);
        this.pomEditor = pomEditor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        MavenPluginActivator.getDefault().getMavenProjectManager().addMavenProjectChangedListener((IMavenProjectChangedListener)this);
        FormToolkit formToolkit = managedForm.getToolkit();
        this.searchHighlightColor = new Color((Device)Display.getDefault(), 242, 218, 170);
        ScrolledForm form = managedForm.getForm();
        form.setText(this.formatFormTitle());
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        Composite body = form.getBody();
        body.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(body, 0);
        formToolkit.adapt((Composite)sashForm);
        formToolkit.adapt((Control)sashForm, true, true);
        this.createHierarchySection((Composite)sashForm, formToolkit);
        this.createListSection(sashForm, formToolkit);
        sashForm.setWeights(new int[]{1, 1});
        this.createSearchBar(managedForm);
        FormUtils.decorateHeader(managedForm.getToolkit(), form.getForm());
        this.initPopupMenu((Viewer)this.treeViewer, ".tree");
        this.initPopupMenu((Viewer)this.listViewer, ".list");
        this.loadData(false);
    }

    private void initPopupMenu(Viewer viewer, String id) {
        MenuManager menuMgr = new MenuManager("#PopupMenu-" + id);
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getEditorSite().registerContextMenu("org.eclipse.m2e.editor.MavenPomEditor" + id, menuMgr, (ISelectionProvider)viewer, false);
    }

    String formatFormTitle() {
        return NLS.bind((String)Messages.DependencyTreePage_form_title, (Object)this.currentClasspath);
    }

    void loadData(final boolean force) {
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.treeViewer.setInput(null);
        if (this.listViewer.getTable().isDisposed()) {
            return;
        }
        this.listViewer.setInput(null);
        FormUtils.setMessage(this.getManagedForm().getForm(), Messages.DependencyTreePage_message_resolving, 2);
        this.dataLoadingJob = new Job(Messages.DependencyTreePage_job_loading){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DependencyTreePage.this.mavenProject = DependencyTreePage.this.pomEditor.readMavenProject(force, monitor);
                    if (DependencyTreePage.this.mavenProject == null) {
                        log.error("Unable to read maven project. Dependencies not updated.");
                        return Status.CANCEL_STATUS;
                    }
                    final DependencyNode dependencyNode = DependencyTreePage.this.pomEditor.readDependencyTree(force, DependencyTreePage.this.currentClasspath, monitor);
                    if (dependencyNode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    dependencyNode.accept(new DependencyVisitor(){

                        public boolean visitEnter(DependencyNode node) {
                            if (node.getDependency() != null) {
                                (this).DependencyTreePage.this.dependencyNodes.add(node);
                            }
                            return true;
                        }

                        public boolean visitLeave(DependencyNode dependencynode) {
                            return true;
                        }
                    });
                    DependencyTreePage.this.getPartControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            FormUtils.setMessage(DependencyTreePage.this.getManagedForm().getForm(), null, 0);
                            if ((this).DependencyTreePage.this.treeViewer.getTree().isDisposed()) {
                                return;
                            }
                            (this).DependencyTreePage.this.treeViewer.setInput((Object)dependencyNode);
                            (this).DependencyTreePage.this.treeViewer.expandAll();
                            if ((this).DependencyTreePage.this.listViewer.getTable().isDisposed()) {
                                return;
                            }
                            (this).DependencyTreePage.this.listViewer.setInput((Object)(this).DependencyTreePage.this.mavenProject);
                        }
                    });
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    DependencyTreePage.this.getPartControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            FormUtils.setMessage(DependencyTreePage.this.getManagedForm().getForm(), ex.getMessage(), 3);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.dataLoadingJob.schedule();
    }

    private void createHierarchySection(Composite sashForm, FormToolkit formToolkit) {
        Composite hierarchyComposite = formToolkit.createComposite(sashForm, 0);
        hierarchyComposite.setLayout((Layout)new GridLayout());
        Section hierarchySection = formToolkit.createSection(hierarchyComposite, 256);
        hierarchySection.marginHeight = 1;
        GridData gd_hierarchySection = new GridData(4, 4, true, true);
        gd_hierarchySection.widthHint = 100;
        gd_hierarchySection.minimumWidth = 100;
        hierarchySection.setLayoutData((Object)gd_hierarchySection);
        hierarchySection.setText(Messages.DependencyTreePage_section_hierarchy);
        formToolkit.paintBordersFor((Composite)hierarchySection);
        Tree tree = formToolkit.createTree((Composite)hierarchySection, 770);
        hierarchySection.setClient((Control)tree);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setData("FormWidgetFactory.drawBorder", (Object)Boolean.TRUE);
        DependencyTreeLabelProvider treeLabelProvider = new DependencyTreeLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)new DependencyTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!DependencyTreePage.this.isSettingSelection) {
                    DependencyTreePage.this.isSettingSelection = true;
                    IStructuredSelection selection = (IStructuredSelection)DependencyTreePage.this.treeViewer.getSelection();
                    DependencyTreePage.this.selectListElements(new DependencyNodeMatcher(selection));
                    DependencyTreePage.this.isSettingSelection = false;
                }
            }
        });
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DependencyTreePage.this.treeViewer.getSelection();
                for (Object o : selection) {
                    if (!(o instanceof DependencyNode)) continue;
                    Artifact a = ((DependencyNode)o).getDependency().getArtifact();
                    OpenPomAction.openEditor((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion(), null);
                }
            }
        });
        this.createHierarchyToolbar(hierarchySection, treeLabelProvider, formToolkit);
    }

    private void createHierarchyToolbar(Section hierarchySection, final DependencyTreeLabelProvider treeLabelProvider, FormToolkit formToolkit) {
        ToolBarManager hiearchyToolBarManager = new ToolBarManager(0x800000);
        hiearchyToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_collapseAll, MavenEditorImages.COLLAPSE_ALL){

            public void run() {
                DependencyTreePage.this.treeViewer.collapseAll();
            }
        });
        hiearchyToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_expandAll, MavenEditorImages.EXPAND_ALL){

            public void run() {
                DependencyTreePage.this.treeViewer.expandAll();
            }
        });
        hiearchyToolBarManager.add((IContributionItem)new Separator());
        hiearchyToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_sort, MavenEditorImages.SORT){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (DependencyTreePage.this.treeViewer.getComparator() == null) {
                    DependencyTreePage.this.treeViewer.setComparator(new ViewerComparator());
                } else {
                    DependencyTreePage.this.treeViewer.setComparator(null);
                }
            }
        });
        hiearchyToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_showGroupId, MavenEditorImages.SHOW_GROUP){

            public int getStyle() {
                return 2;
            }

            public void run() {
                treeLabelProvider.setShowGroupId(this.isChecked());
                DependencyTreePage.this.treeViewer.refresh();
            }
        });
        this.hierarchyFilterAction = new Action(Messages.DependencyTreePage_action_filterSearch, MavenEditorImages.FILTER){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (this.isChecked()) {
                    DependencyTreePage.this.setTreeFilter(DependencyTreePage.this.currentFilter, true);
                } else {
                    DependencyTreePage.this.treeViewer.removeFilter((ViewerFilter)DependencyTreePage.this.searchFilter);
                }
                DependencyTreePage.this.treeViewer.refresh();
                DependencyTreePage.this.treeViewer.expandAll();
            }
        };
        this.hierarchyFilterAction.setChecked(true);
        hiearchyToolBarManager.add((IAction)this.hierarchyFilterAction);
        Composite toolbarComposite = formToolkit.createComposite((Composite)hierarchySection);
        toolbarComposite.setBackground(null);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        hiearchyToolBarManager.createControl(toolbarComposite);
        hierarchySection.setTextClient((Control)toolbarComposite);
    }

    private void createListSection(SashForm sashForm, FormToolkit formToolkit) {
        Composite listComposite = formToolkit.createComposite((Composite)sashForm, 0);
        listComposite.setLayout((Layout)new GridLayout());
        Section listSection = formToolkit.createSection(listComposite, 256);
        listSection.marginHeight = 1;
        GridData gd_listSection = new GridData(4, 4, true, true);
        gd_listSection.widthHint = 100;
        gd_listSection.minimumWidth = 100;
        listSection.setLayoutData((Object)gd_listSection);
        listSection.setText(Messages.DependencyTreePage_section_resolvedDeps);
        formToolkit.paintBordersFor((Composite)listSection);
        DependencyListLabelProvider listLabelProvider = new DependencyListLabelProvider();
        Table table = formToolkit.createTable((Composite)listSection, 0x800002);
        listSection.setClient((Control)table);
        this.listViewer = new TableViewer(table);
        this.listViewer.setData("FormWidgetFactory.drawBorder", (Object)Boolean.TRUE);
        this.listViewer.setContentProvider((IContentProvider)new DependencyListContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)listLabelProvider);
        this.listViewer.setComparator(new ViewerComparator());
        this.listSelectionFilter = new ListSelectionFilter();
        this.listViewer.addSelectionChangedListener((ISelectionChangedListener)this.listSelectionFilter);
        this.listViewer.getTable().addFocusListener((FocusListener)this.listSelectionFilter);
        this.listViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DependencyTreePage.this.listViewer.getSelection();
                for (Object o : selection) {
                    if (!(o instanceof org.apache.maven.artifact.Artifact)) continue;
                    org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)o;
                    OpenPomAction.openEditor((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion(), null);
                }
            }
        });
        this.createListToolbar(listSection, listLabelProvider, formToolkit);
    }

    private void createListToolbar(Section listSection, final DependencyListLabelProvider listLabelProvider, FormToolkit formToolkit) {
        ToolBarManager listToolBarManager = new ToolBarManager(0x800000);
        listToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_sort, MavenEditorImages.SORT){
            {
                this.setChecked(true);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (DependencyTreePage.this.listViewer.getComparator() == null) {
                    DependencyTreePage.this.listViewer.setComparator(new ViewerComparator());
                } else {
                    DependencyTreePage.this.listViewer.setComparator(null);
                }
            }
        });
        listToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_showGroupId, MavenEditorImages.SHOW_GROUP){

            public int getStyle() {
                return 2;
            }

            public void run() {
                listLabelProvider.setShowGroupId(this.isChecked());
                DependencyTreePage.this.listViewer.refresh();
            }
        });
        listToolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_filter, MavenEditorImages.FILTER){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (DependencyTreePage.this.listViewer.getFilters() == null || DependencyTreePage.this.listViewer.getFilters().length == 0) {
                    DependencyTreePage.this.listViewer.addFilter((ViewerFilter)DependencyTreePage.this.searchFilter);
                } else {
                    DependencyTreePage.this.listViewer.removeFilter((ViewerFilter)DependencyTreePage.this.searchFilter);
                }
            }
        });
        Composite toolbarComposite = formToolkit.createComposite((Composite)listSection);
        toolbarComposite.setBackground(null);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        listToolBarManager.createControl(toolbarComposite);
        listSection.setTextClient((Control)toolbarComposite);
    }

    private void createSearchBar(IManagedForm managedForm) {
        this.searchControl = new SearchControl(Messages.DependencyTreePage_find, managedForm);
        this.searchMatcher = new SearchMatcher(this.searchControl);
        this.searchFilter = new DependencyFilter(new SearchMatcher(this.searchControl));
        this.treeViewer.addFilter((ViewerFilter)this.searchFilter);
        ScrolledForm form = managedForm.getForm();
        IToolBarManager toolBarManager = form.getForm().getToolBarManager();
        toolBarManager.add((IContributionItem)this.searchControl);
        class ClasspathDropdown
        extends Action
        implements IMenuCreator {
            private Menu menu;

            public ClasspathDropdown() {
                this.setText(Messages.DependencyTreePage_classpath);
                this.setImageDescriptor(MavenEditorImages.SCOPE);
                this.setMenuCreator(this);
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                if (this.menu != null) {
                    this.menu.dispose();
                }
                this.menu = new Menu(parent);
                this.addToMenu(this.menu, Messages.DependencyTreePage_scope_all, "test", DependencyTreePage.this.currentClasspath);
                this.addToMenu(this.menu, Messages.DependencyTreePage_scope_comp_runtime, "compile+runtime", DependencyTreePage.this.currentClasspath);
                this.addToMenu(this.menu, Messages.DependencyTreePage_scope_compile, "compile", DependencyTreePage.this.currentClasspath);
                this.addToMenu(this.menu, Messages.DependencyTreePage_scope_runtime, "runtime", DependencyTreePage.this.currentClasspath);
                return this.menu;
            }

            protected void addToMenu(Menu parent, String text, String scope, String currentScope) {
                ClasspathAction action = new ClasspathAction(text, scope);
                action.setChecked(scope.equals(currentScope));
                new ActionContributionItem((IAction)action).fill(parent, -1);
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        }
        toolBarManager.add((IAction)new ClasspathDropdown());
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new Action(Messages.DependencyTreePage_action_refresh, MavenEditorImages.REFRESH){

            public void run() {
                DependencyTreePage.this.loadData(true);
            }
        });
        form.updateToolBar();
        this.searchControl.getSearchText().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DependencyTreePage.this.isSettingSelection = true;
                DependencyTreePage.this.selectListElements(DependencyTreePage.this.searchMatcher);
                DependencyTreePage.this.selectTreeElements(DependencyTreePage.this.searchMatcher);
                DependencyTreePage.this.setTreeFilter(DependencyTreePage.this.searchFilter, false);
                DependencyTreePage.this.isSettingSelection = false;
            }
        });
        this.searchControl.getSearchText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DependencyTreePage.this.isSettingSelection = true;
                DependencyTreePage.this.selectListElements(DependencyTreePage.this.searchMatcher);
                DependencyTreePage.this.selectTreeElements(DependencyTreePage.this.searchMatcher);
                DependencyTreePage.this.setTreeFilter(DependencyTreePage.this.searchFilter, false);
                DependencyTreePage.this.isSettingSelection = false;
            }
        });
    }

    protected void setTreeFilter(ViewerFilter filter, boolean force) {
        this.currentFilter = filter;
        if (filter != null && (force || this.treeViewer.getFilters().length > 0 && this.treeViewer.getFilters()[0] != filter)) {
            this.treeViewer.addFilter(filter);
        }
    }

    protected void selectListElements(Matcher matcher) {
        DependencyListLabelProvider listLabelProvider = (DependencyListLabelProvider)this.listViewer.getLabelProvider();
        listLabelProvider.setMatcher(matcher);
        this.listViewer.refresh();
        if (!matcher.isEmpty() && this.mavenProject != null) {
            Set projectArtifacts = this.mavenProject.getArtifacts();
            for (org.apache.maven.artifact.Artifact a : projectArtifacts) {
                if (!matcher.isMatchingArtifact(a.getGroupId(), a.getArtifactId())) continue;
                this.listViewer.reveal((Object)a);
                break;
            }
        }
    }

    void selectTreeElements(Matcher matcher) {
        DependencyTreeLabelProvider treeLabelProvider = (DependencyTreeLabelProvider)this.treeViewer.getLabelProvider();
        treeLabelProvider.setMatcher(matcher);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        if (!matcher.isEmpty()) {
            for (DependencyNode node : this.dependencyNodes) {
                Artifact a = node.getDependency().getArtifact();
                if (!matcher.isMatchingArtifact(a.getGroupId(), a.getGroupId())) continue;
                this.treeViewer.reveal((Object)node);
                break;
            }
        }
    }

    public void dispose() {
        MavenPluginActivator.getDefault().getMavenProjectManager().removeMavenProjectChangedListener((IMavenProjectChangedListener)this);
        if (this.searchHighlightColor != null) {
            this.searchHighlightColor.dispose();
        }
        super.dispose();
    }

    public void selectDepedency(ArtifactKey artifactKey) {
        org.apache.maven.artifact.Artifact artifact;
        if (this.dataLoadingJob != null && this.dataLoadingJob.getState() == 4) {
            try {
                this.dataLoadingJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mavenProject != null && (artifact = this.getArtifact(artifactKey)) != null) {
            this.listViewer.getTable().setFocus();
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)artifact), true);
        }
    }

    private org.apache.maven.artifact.Artifact getArtifact(ArtifactKey artifactKey) {
        Set artifacts = this.mavenProject.getArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (!artifactKey.equals((Object)new ArtifactKey(artifact))) continue;
            return artifact;
        }
        return null;
    }

    public void loadData() {
        this.loadData(true);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        if (this.getManagedForm() == null || this.getManagedForm().getForm() == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            if (events[i].getSource().equals((Object)((MavenPomEditor)this.getEditor()).getPomFile())) {
                new UIJob(Messages.DependencyTreePage_job_reloading){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DependencyTreePage.this.loadData();
                        FormUtils.setMessage(DependencyTreePage.this.getManagedForm().getForm(), null, 2);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            ++i;
        }
    }

    public void fileChanged() {
        if (this.getManagedForm() == null || this.getManagedForm().getForm() == null) {
            return;
        }
        new UIJob(Messages.DependencyTreePage_job_reloading){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                FormUtils.setMessage(DependencyTreePage.this.getManagedForm().getForm(), Messages.DependencyTreePage_message_updating, 2);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static class ArtifactMatcher
    extends Matcher {
        protected final HashSet<String> artifactKeys = new HashSet();

        public ArtifactMatcher(IStructuredSelection selection) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.addArtifactKey(it.next());
            }
        }

        public boolean isEmpty() {
            return this.artifactKeys.isEmpty();
        }

        public boolean isMatchingArtifact(String groupId, String artifactId) {
            return this.artifactKeys.contains(this.getKey(groupId, artifactId));
        }

        protected void addArtifactKey(Object o) {
            if (o instanceof org.apache.maven.artifact.Artifact) {
                org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)o;
                this.artifactKeys.add(this.getKey(a.getGroupId(), a.getArtifactId()));
            }
        }

        protected String getKey(String groupId, String artifactId) {
            return String.valueOf(groupId) + ":" + artifactId;
        }
    }

    public class ClasspathAction
    extends Action {
        private final String classpath;

        public ClasspathAction(String text, String classpath) {
            super(text, 8);
            this.classpath = classpath;
        }

        public void run() {
            if (this.isChecked()) {
                DependencyTreePage.this.currentClasspath = this.classpath;
                IManagedForm managedForm = DependencyTreePage.this.getManagedForm();
                managedForm.getForm().setText(DependencyTreePage.this.formatFormTitle());
                DependencyTreePage.this.loadData(false);
            }
        }
    }

    static class DependencyFilter
    extends ViewerFilter {
        protected Matcher matcher;

        public DependencyFilter(Matcher matcher) {
            this.matcher = matcher;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher != null && !this.matcher.isEmpty()) {
                if (element instanceof org.apache.maven.artifact.Artifact) {
                    org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)element;
                    return this.matcher.isMatchingArtifact(a.getGroupId(), a.getArtifactId());
                }
                if (element instanceof DependencyNode) {
                    DependencyNode node = (DependencyNode)element;
                    Artifact a = node.getDependency().getArtifact();
                    if (this.matcher.isMatchingArtifact(a.getGroupId(), a.getArtifactId())) {
                        return true;
                    }
                    class ChildMatcher
                    implements DependencyVisitor {
                        protected boolean foundMatch = false;

                        ChildMatcher() {
                        }

                        public boolean visitEnter(DependencyNode node) {
                            Artifact a = node.getDependency().getArtifact();
                            if (DependencyFilter.this.matcher.isMatchingArtifact(a.getGroupId(), a.getArtifactId())) {
                                this.foundMatch = true;
                                return false;
                            }
                            return true;
                        }

                        public boolean visitLeave(DependencyNode node) {
                            return true;
                        }
                    }
                    ChildMatcher childMatcher = new ChildMatcher();
                    node.accept((DependencyVisitor)childMatcher);
                    return childMatcher.foundMatch;
                }
            }
            return true;
        }
    }

    public class DependencyListContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object input) {
            if (input instanceof MavenProject) {
                MavenProject project = (MavenProject)input;
                ArrayList<org.apache.maven.artifact.Artifact> artifacts = new ArrayList<org.apache.maven.artifact.Artifact>();
                ScopeArtifactFilter filter = new ScopeArtifactFilter(DependencyTreePage.this.currentClasspath);
                for (org.apache.maven.artifact.Artifact artifact : project.getArtifacts()) {
                    if (!filter.include(artifact)) continue;
                    artifacts.add(artifact);
                }
                return artifacts.toArray(new org.apache.maven.artifact.Artifact[artifacts.size()]);
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class DependencyListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private boolean showGroupId = false;
        private Matcher matcher = null;

        public void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        public void setShowGroupId(boolean showGroupId) {
            this.showGroupId = showGroupId;
        }

        public Color getForeground(Object element) {
            org.apache.maven.artifact.Artifact a;
            String scope;
            if (element instanceof org.apache.maven.artifact.Artifact && (scope = (a = (org.apache.maven.artifact.Artifact)element).getScope()) != null && !"compile".equals(scope)) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            org.apache.maven.artifact.Artifact a;
            if (this.matcher != null && !this.matcher.isEmpty() && element instanceof org.apache.maven.artifact.Artifact && this.matcher.isMatchingArtifact((a = (org.apache.maven.artifact.Artifact)element).getGroupId(), a.getArtifactId())) {
                return DependencyTreePage.this.searchHighlightColor;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof org.apache.maven.artifact.Artifact) {
                org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)element;
                StringBuilder label = new StringBuilder(64);
                if (this.showGroupId) {
                    label.append(a.getGroupId()).append(" : ");
                }
                label.append(a.getArtifactId()).append(" : ").append(a.getVersion());
                if (a.hasClassifier()) {
                    label.append(" - ").append(a.getClassifier());
                }
                if (a.getScope() != null) {
                    label.append(" [").append(a.getScope()).append("]");
                }
                return label.toString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof org.apache.maven.artifact.Artifact) {
                org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)element;
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade projectFacade = projectManager.getMavenProject(a.getGroupId(), a.getArtifactId(), a.getBaseVersion() == null ? a.getVersion() : a.getBaseVersion());
                return projectFacade == null ? MavenEditorImages.IMG_JAR : MavenEditorImages.IMG_PROJECT;
            }
            return null;
        }
    }

    public static class DependencyNodeMatcher
    extends ArtifactMatcher {
        public DependencyNodeMatcher(IStructuredSelection selection) {
            super(selection);
        }

        protected void addArtifactKey(Object o) {
            if (o instanceof DependencyNode) {
                Artifact a = ((DependencyNode)o).getDependency().getArtifact();
                this.artifactKeys.add(this.getKey(a.getGroupId(), a.getArtifactId()));
            }
        }
    }

    final class DependencyTreeContentProvider
    implements ITreeContentProvider {
        DependencyTreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.getChildren(input);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)element;
                List children = node.getChildren();
                return children.toArray(new DependencyNode[children.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)element;
                return !node.getChildren().isEmpty();
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    final class DependencyTreeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private boolean showGroupId = false;
        private Matcher matcher = null;

        DependencyTreeLabelProvider() {
        }

        public void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        public void setShowGroupId(boolean showGroupId) {
            this.showGroupId = showGroupId;
        }

        public Color getForeground(Object element) {
            DependencyNode node;
            String scope;
            if (element instanceof DependencyNode && (scope = (node = (DependencyNode)element).getDependency().getScope()) != null && !"compile".equals(scope)) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            Artifact a;
            if (this.matcher != null && !this.matcher.isEmpty() && element instanceof DependencyNode && this.matcher.isMatchingArtifact((a = ((DependencyNode)element).getDependency().getArtifact()).getGroupId(), a.getArtifactId())) {
                return DependencyTreePage.this.searchHighlightColor;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)element;
                Artifact a = node.getDependency().getArtifact();
                Artifact c = null;
                if (!node.getAliases().isEmpty()) {
                    c = (Artifact)node.getAliases().iterator().next();
                }
                StringBuilder label = new StringBuilder(128);
                if (this.showGroupId) {
                    label.append(a.getGroupId()).append(" : ");
                }
                label.append(a.getArtifactId()).append(" : ");
                label.append(a.getBaseVersion());
                if (node.getPremanagedVersion() != null && !node.getPremanagedVersion().equals(a.getBaseVersion())) {
                    label.append(" (managed from ").append(node.getPremanagedVersion()).append(")");
                }
                if (c != null) {
                    String version = c.getBaseVersion();
                    if (!a.getBaseVersion().equals(version)) {
                        label.append(" (omitted for conflict with ").append(version).append(")");
                    }
                }
                if (a.getClassifier().length() > 0) {
                    label.append(Messages.DependencyTreePage_0).append(a.getClassifier());
                }
                label.append(" [").append(node.getDependency().getScope()).append("]");
                if (node.getPremanagedScope() != null) {
                    label.append(" (from ").append(node.getPremanagedScope()).append(")");
                }
                return label.toString();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)element;
                Artifact a = node.getDependency().getArtifact();
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade projectFacade = projectManager.getMavenProject(a.getGroupId(), a.getArtifactId(), a.getBaseVersion() == null ? a.getVersion() : a.getBaseVersion());
                return projectFacade == null ? MavenEditorImages.IMG_JAR : MavenEditorImages.IMG_PROJECT;
            }
            return null;
        }
    }

    class ListSelectionFilter
    extends DependencyFilter
    implements ISelectionChangedListener,
    FocusListener {
        public ListSelectionFilter() {
            super(null);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!DependencyTreePage.this.isSettingSelection) {
                DependencyTreePage.this.isSettingSelection = true;
                IStructuredSelection selection = (IStructuredSelection)DependencyTreePage.this.listViewer.getSelection();
                this.matcher = new ArtifactMatcher(selection);
                DependencyTreePage.this.selectTreeElements(this.matcher);
                DependencyTreePage.this.setTreeFilter(this, false);
                DependencyTreePage.this.isSettingSelection = false;
            }
        }

        public void focusGained(FocusEvent e) {
            if (DependencyTreePage.this.hierarchyFilterAction.isChecked()) {
                DependencyTreePage.this.setTreeFilter(this, false);
            }
        }

        public void focusLost(FocusEvent e) {
            this.matcher = null;
        }
    }
}

