/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.composites;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.dialogs.EditDependencyDialog;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.util.ParentGatherer;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.MavenEditorPlugin;
import org.eclipse.m2e.editor.composites.DependenciesComparator;
import org.eclipse.m2e.editor.composites.DependencyLabelProvider;
import org.eclipse.m2e.editor.composites.ListEditorComposite;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.dialogs.ManageDependenciesDialog;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.m2e.editor.pom.MavenPomEditorPage;
import org.eclipse.m2e.editor.pom.SearchControl;
import org.eclipse.m2e.editor.pom.SearchMatcher;
import org.eclipse.m2e.editor.pom.ValueProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesComposite
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(DependenciesComposite.class);
    protected MavenPomEditorPage editorPage;
    MavenPomEditor pomEditor;
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    PropertiesListComposite<Dependency> dependencyManagementEditor;
    DependenciesListComposite<Object> dependenciesEditor;
    private final List<String> temporaryRemovedDependencies = new ArrayList<String>();
    Button dependencySelectButton;
    Action dependencySelectAction;
    SearchControl searchControl;
    SearchMatcher searchMatcher;
    DependencyFilter searchFilter;
    Action openWebPageAction;
    final DependencyLabelProvider dependencyLabelProvider = new DependencyLabelProvider(true);
    final DependencyLabelProvider dependencyManagementLabelProvider = new DependencyLabelProvider();
    protected boolean showInheritedDependencies = false;
    final ListEditorContentProvider<Object> dependenciesContentProvider = new ListEditorContentProvider();
    DependenciesComparator<Object> dependenciesComparator;
    final ListEditorContentProvider<Dependency> dependencyManagementContentProvider = new ListEditorContentProvider();
    DependenciesComparator<Dependency> dependencyManagementComparator;
    private List<Dependency> dependencies;
    private List<Dependency> manageddependencies;
    private final Object MAN_DEP_LOCK = new Object();
    private final Object DEP_LOCK = new Object();

    public DependenciesComposite(Composite composite, MavenPomEditorPage editorPage, int flags, MavenPomEditor pomEditor) {
        super(composite, flags);
        this.editorPage = editorPage;
        this.pomEditor = pomEditor;
        this.createComposite();
        editorPage.initPopupMenu((Viewer)this.dependenciesEditor.getViewer(), ".dependencies");
        editorPage.initPopupMenu((Viewer)this.dependencyManagementEditor.getViewer(), ".dependencyManagement");
    }

    private void createComposite() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.toolkit.adapt((Composite)this);
        SashForm horizontalSash = new SashForm((Composite)this, 0);
        GridData horizontalCompositeGridData = new GridData(4, 4, true, true);
        horizontalCompositeGridData.heightHint = 200;
        horizontalSash.setLayoutData((Object)horizontalCompositeGridData);
        this.toolkit.adapt((Control)horizontalSash, true, true);
        this.createDependenciesSection(horizontalSash);
        this.createDependencyManagementSection(horizontalSash);
        horizontalSash.setWeights(new int[]{1, 1});
    }

    private void createDependenciesSection(SashForm verticalSash) {
        Section dependenciesSection = this.toolkit.createSection((Composite)verticalSash, 256);
        dependenciesSection.marginWidth = 3;
        dependenciesSection.setText(Messages.DependenciesComposite_sectionDependencies);
        this.dependenciesComparator = new DependenciesComparator();
        this.dependenciesContentProvider.setComparator(this.dependenciesComparator);
        this.dependenciesEditor = new DependenciesListComposite((Composite)dependenciesSection, 0, true);
        this.dependenciesEditor.setCellLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.dependencyLabelProvider));
        this.dependenciesEditor.setContentProvider(this.dependenciesContentProvider);
        this.dependenciesEditor.setRemoveButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final List dependencyList = DependenciesComposite.this.dependenciesEditor.getSelection();
                try {
                    DependenciesComposite.this.editorPage.performEditOperation(new PomEdits.Operation(){

                        public void process(Document document) {
                            Element deps = PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies");
                            if (deps == null) {
                                return;
                            }
                            for (Object dependency : dependencyList) {
                                if (!(dependency instanceof Dependency)) continue;
                                Element dep = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)((Dependency)dependency).groupId), PomEdits.childEquals((String)"artifactId", (String)((Dependency)dependency).artifactId)});
                                PomEdits.removeChild((Element)deps, (Element)dep);
                            }
                            PomEdits.removeIfNoChildElement((Element)deps);
                        }
                    }, log, "error removing dependencies");
                }
                finally {
                    DependenciesComposite.this.setDependenciesInput();
                }
            }
        });
        this.dependenciesEditor.setPropertiesListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = DependenciesComposite.this.dependenciesEditor.getSelection().get(0);
                if (selection instanceof Dependency) {
                    Dependency dependency = (Dependency)selection;
                    EditDependencyDialog d = new EditDependencyDialog(DependenciesComposite.this.getShell(), false, DependenciesComposite.this.editorPage.getProject(), DependenciesComposite.this.editorPage.getPomEditor().getMavenProject());
                    d.setDependency(DependenciesComposite.this.toApacheDependency(dependency));
                    if (d.open() == 0) {
                        try {
                            DependenciesComposite.this.editorPage.performEditOperation(d.getEditOperation(), log, "Error updating dependency");
                        }
                        finally {
                            DependenciesComposite.this.setDependenciesInput();
                            DependenciesComposite.this.dependenciesEditor.setSelection(Collections.singletonList(dependency));
                        }
                    }
                } else {
                    boolean cfr_ignored_0 = selection instanceof org.apache.maven.model.Dependency;
                }
            }
        });
        dependenciesSection.setClient(this.dependenciesEditor);
        this.toolkit.adapt(this.dependenciesEditor);
        this.toolkit.paintBordersFor(this.dependenciesEditor);
        this.dependenciesEditor.setManageButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DependenciesComposite.this.openManageDependenciesDialog();
                }
                catch (InvocationTargetException e1) {
                    MavenEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2e.editor", "Error: ", (Throwable)e1));
                }
                catch (InterruptedException e1) {
                    MavenEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2e.editor", "Error: ", (Throwable)e1));
                }
            }
        });
        this.dependenciesEditor.setAddButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRepositorySearchDialog addDepDialog = MavenRepositorySearchDialog.createSearchDependencyDialog((Shell)DependenciesComposite.this.getShell(), (String)Messages.DependenciesComposite_action_selectDependency, (MavenProject)DependenciesComposite.this.editorPage.getPomEditor().getMavenProject(), (IProject)DependenciesComposite.this.editorPage.getProject(), (boolean)false);
                if (addDepDialog.open() == 0) {
                    final IndexedArtifactFile dep = (IndexedArtifactFile)addDepDialog.getFirstResult();
                    final String selectedScope = addDepDialog.getSelectedScope();
                    try {
                        DependenciesComposite.this.editorPage.performEditOperation(new PomEdits.Operation(){

                            public void process(Document document) {
                                Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                                PomHelper.addOrUpdateDependency((Element)depsEl, (String)dep.group, (String)dep.artifact, (String)(DependenciesComposite.this.isManaged(dep.group, dep.artifact, dep.version) ? null : dep.version), (String)dep.type, (String)selectedScope, (String)dep.classifier);
                            }
                        }, log, "errror adding dependency");
                    }
                    finally {
                        DependenciesComposite.this.setDependenciesInput();
                        List deps = DependenciesComposite.this.getDependencies();
                        if (deps.size() > 0) {
                            DependenciesComposite.this.dependenciesEditor.setSelection(Collections.singletonList(deps.get(deps.size() - 1)));
                        }
                    }
                }
            }
        });
        ToolBarManager modulesToolBarManager = new ToolBarManager(0x800000);
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_sortAlphabetically, MavenEditorImages.SORT){
            {
                this.setChecked(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependenciesContentProvider.setShouldSort(this.isChecked());
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showInheritedDependencies, MavenEditorImages.SHOW_INHERITED_DEPENDENCIES){
            {
                this.setChecked(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.showInheritedDependencies = this.isChecked();
                ISelection selection = DependenciesComposite.this.dependenciesEditor.getViewer().getSelection();
                DependenciesComposite.this.setDependenciesInput();
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
                DependenciesComposite.this.dependenciesEditor.getViewer().setSelection(selection, true);
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showgroupid, MavenEditorImages.SHOW_GROUP){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependenciesComparator.setSortByGroups(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyLabelProvider.setShowGroupId(this.isChecked());
                DependenciesComposite.this.dependenciesComparator.setSortByGroups(this.isChecked());
                DependenciesComposite.this.dependenciesEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_filter, MavenEditorImages.FILTER){
            {
                this.setChecked(true);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                TableViewer viewer = DependenciesComposite.this.dependenciesEditor.getViewer();
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                } else {
                    viewer.removeFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                }
                viewer.refresh();
                if (this.isChecked()) {
                    DependenciesComposite.this.searchControl.getSearchText().setFocus();
                }
            }
        });
        Composite toolbarComposite = this.toolkit.createComposite((Composite)dependenciesSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        modulesToolBarManager.createControl(toolbarComposite);
        dependenciesSection.setTextClient((Control)toolbarComposite);
    }

    private void createDependencyManagementSection(SashForm verticalSash) {
        Section dependencyManagementSection = this.toolkit.createSection((Composite)verticalSash, 256);
        dependencyManagementSection.marginWidth = 3;
        dependencyManagementSection.setText(Messages.DependenciesComposite_sectionDependencyManagement);
        this.dependencyManagementComparator = new DependenciesComparator();
        this.dependencyManagementContentProvider.setComparator(this.dependencyManagementComparator);
        this.dependencyManagementEditor = new PropertiesListComposite((Composite)dependencyManagementSection, 0, true);
        this.dependencyManagementEditor.setContentProvider(this.dependencyManagementContentProvider);
        this.dependencyManagementEditor.setLabelProvider((ILabelProvider)this.dependencyManagementLabelProvider);
        dependencyManagementSection.setClient(this.dependencyManagementEditor);
        this.dependencyManagementEditor.setRemoveButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final List dependencyList = DependenciesComposite.this.dependencyManagementEditor.getSelection();
                try {
                    DependenciesComposite.this.editorPage.performEditOperation(new PomEdits.Operation(){

                        public void process(Document document) {
                            Element deps = PomEdits.findChild((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencyManagement"), (String)"dependencies");
                            if (deps == null) {
                                return;
                            }
                            for (Dependency dependency : dependencyList) {
                                Element dep = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)dependency.groupId), PomEdits.childEquals((String)"artifactId", (String)dependency.artifactId)});
                                PomEdits.removeChild((Element)deps, (Element)dep);
                            }
                            PomEdits.removeIfNoChildElement((Element)deps);
                        }
                    }, log, "error removing managed dependencies");
                }
                finally {
                    DependenciesComposite.this.setDependencyManagementInput();
                    DependenciesComposite.this.dependenciesEditor.refresh();
                }
            }
        });
        this.dependencyManagementEditor.setPropertiesListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dependency dependency = (Dependency)DependenciesComposite.this.dependencyManagementEditor.getSelection().get(0);
                EditDependencyDialog d = new EditDependencyDialog(DependenciesComposite.this.getShell(), true, DependenciesComposite.this.editorPage.getProject(), DependenciesComposite.this.editorPage.getPomEditor().getMavenProject());
                d.setDependency(DependenciesComposite.this.toApacheDependency(dependency));
                if (d.open() == 0) {
                    try {
                        DependenciesComposite.this.editorPage.performEditOperation(d.getEditOperation(), log, "Error updating dependency");
                    }
                    finally {
                        DependenciesComposite.this.setDependencyManagementInput();
                        DependenciesComposite.this.dependencyManagementEditor.setSelection(Collections.singletonList(dependency));
                        DependenciesComposite.this.dependenciesEditor.refresh();
                    }
                }
            }
        });
        this.dependencyManagementEditor.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = DependenciesComposite.this.dependencyManagementEditor.getSelection();
                if (!selection.isEmpty()) {
                    DependenciesComposite.this.dependenciesEditor.setSelection(Collections.emptyList());
                }
            }
        });
        this.toolkit.adapt(this.dependencyManagementEditor);
        this.toolkit.paintBordersFor(this.dependencyManagementEditor);
        this.dependencyManagementEditor.setAddButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRepositorySearchDialog addDepDialog = MavenRepositorySearchDialog.createSearchDependencyDialog((Shell)DependenciesComposite.this.getShell(), (String)Messages.DependenciesComposite_action_selectDependency, (MavenProject)DependenciesComposite.this.editorPage.getPomEditor().getMavenProject(), (IProject)DependenciesComposite.this.editorPage.getProject(), (boolean)true);
                if (addDepDialog.open() == 0) {
                    final IndexedArtifactFile dep = (IndexedArtifactFile)addDepDialog.getFirstResult();
                    final String selectedScope = addDepDialog.getSelectedScope();
                    try {
                        DependenciesComposite.this.editorPage.performEditOperation(new PomEdits.Operation(){

                            public void process(Document document) {
                                Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencyManagement", "dependencies"});
                                PomHelper.addOrUpdateDependency((Element)depsEl, (String)dep.group, (String)dep.artifact, (String)dep.version, (String)dep.type, (String)selectedScope, (String)dep.classifier);
                            }
                        }, log, "errror adding dependency");
                    }
                    finally {
                        DependenciesComposite.this.setDependencyManagementInput();
                        List dlist = DependenciesComposite.this.getManagedDependencies();
                        if (dlist.size() > 0) {
                            DependenciesComposite.this.dependencyManagementEditor.setSelection(Collections.singletonList((Dependency)dlist.get(dlist.size() - 1)));
                        }
                        DependenciesComposite.this.dependenciesEditor.refresh();
                    }
                }
            }
        });
        ToolBarManager modulesToolBarManager = new ToolBarManager(0x800000);
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_sortAlphabetically, MavenEditorImages.SORT){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependencyManagementContentProvider.setShouldSort(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyManagementContentProvider.setShouldSort(this.isChecked());
                DependenciesComposite.this.dependencyManagementEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_showgroupid, MavenEditorImages.SHOW_GROUP){
            {
                this.setChecked(false);
                DependenciesComposite.this.dependencyManagementComparator.setSortByGroups(false);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                DependenciesComposite.this.dependencyManagementLabelProvider.setShowGroupId(this.isChecked());
                DependenciesComposite.this.dependencyManagementComparator.setSortByGroups(this.isChecked());
                DependenciesComposite.this.dependencyManagementEditor.getViewer().refresh();
            }
        });
        modulesToolBarManager.add((IAction)new Action(Messages.DependenciesComposite_action_filter, MavenEditorImages.FILTER){
            {
                this.setChecked(true);
            }

            public int getStyle() {
                return 2;
            }

            public void run() {
                TableViewer viewer = DependenciesComposite.this.dependencyManagementEditor.getViewer();
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                } else {
                    viewer.removeFilter((ViewerFilter)DependenciesComposite.this.searchFilter);
                }
                viewer.refresh();
                if (this.isChecked()) {
                    DependenciesComposite.this.searchControl.getSearchText().setFocus();
                }
            }
        });
        Composite toolbarComposite = this.toolkit.createComposite((Composite)dependencyManagementSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        modulesToolBarManager.createControl(toolbarComposite);
        dependencyManagementSection.setTextClient((Control)toolbarComposite);
    }

    public void loadData() {
        this.resetDependencies();
        this.resetManagedDependencies();
        ValueProvider<List<org.apache.maven.model.Dependency>> dmValueProvider = new ValueProvider<List<org.apache.maven.model.Dependency>>(){

            @Override
            public List<org.apache.maven.model.Dependency> getValue() {
                ArrayList<org.apache.maven.model.Dependency> toRet = new ArrayList<org.apache.maven.model.Dependency>();
                for (Dependency d : DependenciesComposite.this.getManagedDependencies()) {
                    toRet.add(DependenciesComposite.this.toApacheDependency(d));
                }
                return toRet;
            }
        };
        this.dependencyLabelProvider.setPomEditor(this.editorPage.getPomEditor(), dmValueProvider);
        this.dependencyManagementLabelProvider.setPomEditor(this.editorPage.getPomEditor(), dmValueProvider);
        this.setDependenciesInput();
        this.setDependencyManagementInput();
        this.dependenciesEditor.setReadOnly(this.editorPage.isReadOnly());
        this.dependencyManagementEditor.setReadOnly(this.editorPage.isReadOnly());
        if (this.searchControl != null) {
            this.searchControl.getSearchText().setEditable(true);
        }
    }

    public void setSearchControl(SearchControl searchControl) {
        if (this.searchControl != null) {
            return;
        }
        this.searchMatcher = new SearchMatcher(searchControl);
        this.searchFilter = new DependencyFilter(this.searchMatcher);
        this.searchControl = searchControl;
        TableViewer viewer = this.dependenciesEditor.getViewer();
        viewer.addFilter((ViewerFilter)this.searchFilter);
        viewer = this.dependencyManagementEditor.getViewer();
        viewer.addFilter((ViewerFilter)this.searchFilter);
    }

    String getVersion(String groupId, String artifactId, IProgressMonitor monitor) {
        try {
            MavenProject mavenProject = this.editorPage.getPomEditor().readMavenProject(false, monitor);
            Artifact a = (Artifact)mavenProject.getArtifactMap().get(String.valueOf(groupId) + ":" + artifactId);
            if (a != null) {
                return a.getBaseVersion();
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    void openManageDependenciesDialog() throws InvocationTargetException, InterruptedException {
        final LinkedList<MavenProject> hierarchy = new LinkedList<MavenProject>();
        IRunnableWithProgress projectLoader = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                    IMavenProjectFacade projectFacade = projectManager.create(DependenciesComposite.this.pomEditor.getPomFile(), true, monitor);
                    if (projectFacade != null) {
                        hierarchy.addAll(new ParentGatherer(projectFacade.getMavenProject(), projectFacade).getParentHierarchy(monitor));
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(false, true, projectLoader);
        if (hierarchy.isEmpty()) {
            return;
        }
        ManageDependenciesDialog manageDepDialog = new ManageDependenciesDialog(this.getShell(), new ValueProvider<List<org.apache.maven.model.Dependency>>(){

            @Override
            public List<org.apache.maven.model.Dependency> getValue() {
                ArrayList<org.apache.maven.model.Dependency> toRet = new ArrayList<org.apache.maven.model.Dependency>();
                for (Dependency d : DependenciesComposite.this.getDependencies()) {
                    toRet.add(DependenciesComposite.this.toApacheDependency(d));
                }
                return toRet;
            }
        }, hierarchy, this.dependenciesEditor.getSelection());
        manageDepDialog.open();
    }

    protected void setDependencyManagementInput() {
        this.resetManagedDependencies();
        List<Dependency> managed = this.getManagedDependencies();
        this.dependencyManagementEditor.setInput(managed);
    }

    private Dependency toDependency(Element depEl) {
        Dependency dep = new Dependency();
        dep.groupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"groupId"));
        dep.artifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"artifactId"));
        dep.version = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"version"));
        dep.type = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"type"));
        dep.scope = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"scope"));
        dep.classifier = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"classifier"));
        dep.systemPath = PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"systemPath"));
        dep.optional = Boolean.parseBoolean(PomEdits.getTextValue((Node)PomEdits.findChild((Element)depEl, (String)"optional")));
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getManagedDependencies() {
        Object object = this.MAN_DEP_LOCK;
        synchronized (object) {
            if (this.manageddependencies == null) {
                this.manageddependencies = new ArrayList<Dependency>();
                try {
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.pomEditor.getDocument(), new PomEdits.Operation(){

                        public void process(Document document) {
                            Element dms = PomEdits.findChild((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencyManagement"), (String)"dependencies");
                            for (Element depEl : PomEdits.findChilds((Element)dms, (String)"dependency")) {
                                Dependency dep = DependenciesComposite.this.toDependency(depEl);
                                if (dep == null) continue;
                                DependenciesComposite.this.manageddependencies.add(dep);
                            }
                        }
                    }, true)});
                }
                catch (Exception ex) {
                    log.error("Error loading managed dependencies", (Throwable)ex);
                }
            }
            return this.manageddependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetManagedDependencies() {
        Object object = this.MAN_DEP_LOCK;
        synchronized (object) {
            this.manageddependencies = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependencies() {
        Object object = this.DEP_LOCK;
        synchronized (object) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Dependency>();
                try {
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.pomEditor.getDocument(), new PomEdits.Operation(){

                        public void process(Document document) {
                            Element dms = PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies");
                            for (Element depEl : PomEdits.findChilds((Element)dms, (String)"dependency")) {
                                Dependency dep = DependenciesComposite.this.toDependency(depEl);
                                if (dep == null) continue;
                                DependenciesComposite.this.dependencies.add(dep);
                            }
                        }
                    }, true)});
                }
                catch (Exception ex) {
                    log.error("Error loading dependencies", (Throwable)ex);
                }
            }
            return this.dependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDependencies() {
        Object object = this.DEP_LOCK;
        synchronized (object) {
            this.dependencies = null;
        }
    }

    protected void setDependenciesInput() {
        this.resetDependencies();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        deps.addAll(this.getDependencies());
        if (this.showInheritedDependencies) {
            LinkedList allDeps = new LinkedList();
            MavenProject mp = this.pomEditor.getMavenProject();
            if (mp != null) {
                allDeps.addAll(mp.getDependencies());
            }
            for (org.apache.maven.model.Dependency mavenDep : allDeps) {
                boolean found = false;
                Iterator<Dependency> iter = this.getDependencies().iterator();
                while (!found && iter.hasNext()) {
                    Dependency m2eDep = iter.next();
                    if (!mavenDep.getGroupId().equals(m2eDep.groupId) || !mavenDep.getArtifactId().equals(m2eDep.artifactId)) continue;
                    found = true;
                }
                if (found || this.temporaryRemovedDependencies.contains(String.valueOf(mavenDep.getGroupId()) + ":" + mavenDep.getArtifactId())) continue;
                deps.add((Dependency)mavenDep);
            }
        }
        this.dependenciesEditor.setInput(deps);
    }

    public void mavenProjectHasChanged() {
        this.temporaryRemovedDependencies.clear();
        if (this.showInheritedDependencies) {
            this.setDependenciesInput();
        }
        this.dependenciesEditor.refresh();
    }

    private org.apache.maven.model.Dependency toApacheDependency(Dependency dependency) {
        org.apache.maven.model.Dependency toRet = new org.apache.maven.model.Dependency();
        toRet.setArtifactId(dependency.artifactId);
        toRet.setGroupId(dependency.groupId);
        toRet.setClassifier(dependency.classifier);
        toRet.setScope(dependency.scope);
        toRet.setOptional(dependency.optional);
        toRet.setSystemPath(dependency.systemPath);
        toRet.setType(dependency.type);
        toRet.setVersion(dependency.version);
        return toRet;
    }

    private boolean isManaged(String groupId, String artifactId, String version) {
        List managedDep;
        if (version == null) {
            return true;
        }
        DependencyManagement depManagement = this.editorPage.getPomEditor().getMavenProject().getDependencyManagement();
        if (depManagement != null && groupId != null && artifactId != null && (managedDep = depManagement.getDependencies()) != null) {
            for (org.apache.maven.model.Dependency dependency : managedDep) {
                if (!version.equals(dependency.getVersion()) || !artifactId.equals(dependency.getArtifactId()) || !groupId.equals(dependency.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DependenciesListComposite<T>
    extends PropertiesListComposite<T> {
        private static final String MANAGE = "MANAGE";
        protected Button manage;

        public DependenciesListComposite(Composite parent, int style, boolean includeSearch) {
            super(parent, style, includeSearch);
        }

        @Override
        protected void createButtons(boolean includeSearch) {
            super.createButtons(includeSearch);
            this.manage = this.createButton(Messages.DependenciesComposite_manageButton);
            this.addButton(MANAGE, this.manage);
        }

        @Override
        protected void viewerSelectionChanged() {
            super.viewerSelectionChanged();
            this.updateManageButton();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            this.updateManageButton();
        }

        @Override
        public void refresh() {
            super.refresh();
            this.updateManageButton();
        }

        protected void updateManageButton() {
            boolean hasNonManaged = false;
            for (Dependency d : DependenciesComposite.this.getDependencies()) {
                if (d.version == null) continue;
                hasNonManaged = true;
                break;
            }
            this.manage.setEnabled(!this.readOnly && hasNonManaged);
        }

        public void setManageButtonListener(SelectionListener listener) {
            this.manage.addSelectionListener(listener);
        }
    }

    class Dependency
    implements IAdaptable {
        String artifactId;
        String groupId;
        String version;
        String type;
        String classifier;
        String scope;
        String systemPath;
        boolean optional;

        public Object getAdapter(Class adapter) {
            if (ArtifactKey.class.equals((Object)adapter)) {
                return new ArtifactKey(this.groupId, this.artifactId, this.version, this.classifier);
            }
            return null;
        }
    }

    public static class DependencyFilter
    extends ViewerFilter {
        private SearchMatcher searchMatcher;

        public DependencyFilter(SearchMatcher searchMatcher) {
            this.searchMatcher = searchMatcher;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Dependency) {
                Dependency d = (Dependency)element;
                return this.searchMatcher.isMatchingArtifact(d.groupId, d.artifactId);
            }
            if (element instanceof org.apache.maven.model.Dependency) {
                org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)element;
                return this.searchMatcher.isMatchingArtifact(dependency.getGroupId(), dependency.getArtifactId());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropertiesListComposite<T>
    extends ListEditorComposite<T> {
        private static final String PROPERTIES_BUTTON_KEY = "PROPERTIES";
        protected Button properties;

        public PropertiesListComposite(Composite parent, int style, boolean includeSearch) {
            super(parent, style, includeSearch);
        }

        @Override
        protected void createButtons(boolean includeSearch) {
            if (includeSearch) {
                this.createAddButton();
            }
            this.createRemoveButton();
            this.properties = this.createButton(Messages.ListEditorComposite_btnProperties);
            this.addButton(PROPERTIES_BUTTON_KEY, this.properties);
        }

        public void setPropertiesListener(SelectionListener listener) {
            this.properties.addSelectionListener(listener);
        }

        @Override
        protected void viewerSelectionChanged() {
            super.viewerSelectionChanged();
            this.updatePropertiesButton();
        }

        protected void updatePropertiesButton() {
            boolean enable = !this.viewer.getSelection().isEmpty() && !this.isBadSelection();
            this.properties.setEnabled(!this.readOnly && enable);
        }

        @Override
        protected void updateRemoveButton() {
            boolean enable = !this.viewer.getSelection().isEmpty() && !this.isBadSelection();
            this.getRemoveButton().setEnabled(!this.readOnly && enable);
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            this.updatePropertiesButton();
        }

        protected boolean isBadSelection() {
            List deps = (List)this.viewer.getInput();
            if (deps == null || deps.isEmpty()) {
                return true;
            }
            boolean bad = false;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            for (Object obj : selection) {
                if (!(obj instanceof org.apache.maven.model.Dependency)) continue;
                bad = true;
                break;
            }
            return bad;
        }
    }
}

