/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DefaultSplittingStrategy;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.NoSplittingStrategy;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplitOutlineItem;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingHtmlDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingOutlineParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingStrategy;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToHtmlTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    protected String htmlFilenameFormat = "$1.html";
    protected boolean overwrite = true;
    private final List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();
    protected File file;
    protected String title;
    protected String linkRel;
    protected boolean multipleOutputFiles = false;
    protected boolean formatOutput = false;
    protected boolean navigationImages = false;
    protected String prependImagePrefix = null;
    private boolean useInlineCssStyles = true;
    private boolean suppressBuiltInCssStyles = false;
    private String defaultAbsoluteLinkTarget;
    private boolean xhtmlStrict = false;
    private boolean emitDoctype = true;
    private String htmlDoctype = null;

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.1"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.2"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.3"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.4"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.5"), this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (Stylesheet stylesheet : this.stylesheets) {
            if (stylesheet.url == null && stylesheet.file == null) {
                throw new BuildException(Messages.getString("MarkupToHtmlTask.6"));
            }
            if (stylesheet.url != null && stylesheet.file != null) {
                throw new BuildException(Messages.getString("MarkupToHtmlTask.7"));
            }
            if (stylesheet.file == null) continue;
            if (!stylesheet.file.exists()) {
                throw new BuildException(String.valueOf(Messages.getString("MarkupToHtmlTask.8")) + stylesheet.file);
            }
            if (!stylesheet.file.isFile()) {
                throw new BuildException(String.valueOf(Messages.getString("MarkupToHtmlTask.9")) + stylesheet.file);
            }
            if (stylesheet.file.canRead()) continue;
            throw new BuildException(String.valueOf(Messages.getString("MarkupToHtmlTask.10")) + stylesheet.file);
        }
        HashSet<File> outputFolders = new HashSet<File>();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                this.testForOutputFolderConflict(outputFolders, inputFile);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.11"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            this.testForOutputFolderConflict(outputFolders, this.file);
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.12"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void testForOutputFolderConflict(Set<File> outputFolders, File inputFile) {
        File outputFolder;
        if (this.multipleOutputFiles && !outputFolders.add(outputFolder = inputFile.getAbsoluteFile().getParentFile())) {
            this.log(MessageFormat.format(Messages.getString("MarkupToHtmlTask.13"), outputFolder), 1);
        }
    }

    protected String processFile(MarkupLanguage markupLanguage, File baseDir, File source) throws BuildException {
        File htmlOutputFile;
        this.log(MessageFormat.format(Messages.getString("MarkupToHtmlTask.14"), source), 3);
        String markupContent = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(htmlOutputFile = this.computeHtmlFile(source, name)).exists() || this.overwrite || htmlOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            markupContent = this.readFully(source);
            this.performValidation(source, markupContent);
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(htmlOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.16"), htmlOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer, this.formatOutput);
                for (Stylesheet stylesheet : this.stylesheets) {
                    HtmlDocumentBuilder.Stylesheet builderStylesheet = stylesheet.url != null ? new HtmlDocumentBuilder.Stylesheet(stylesheet.url) : new HtmlDocumentBuilder.Stylesheet(stylesheet.file);
                    builder.addCssStylesheet(builderStylesheet);
                    if (stylesheet.attributes.isEmpty()) continue;
                    for (Map.Entry attr : stylesheet.attributes.entrySet()) {
                        builderStylesheet.getAttributes().put((String)attr.getKey(), (String)attr.getValue());
                    }
                }
                builder.setTitle(this.title == null ? name : this.title);
                builder.setEmitDtd(this.emitDoctype);
                if (this.emitDoctype && this.htmlDoctype != null) {
                    builder.setHtmlDtd(this.htmlDoctype);
                }
                builder.setUseInlineStyles(this.useInlineCssStyles);
                builder.setSuppressBuiltInStyles(this.suppressBuiltInCssStyles);
                builder.setLinkRel(this.linkRel);
                builder.setDefaultAbsoluteLinkTarget(this.defaultAbsoluteLinkTarget);
                builder.setPrependImagePrefix(this.prependImagePrefix);
                builder.setXhtmlStrict(this.xhtmlStrict);
                SplittingStrategy splittingStrategy = this.multipleOutputFiles ? new DefaultSplittingStrategy() : new NoSplittingStrategy();
                SplittingOutlineParser outlineParser = new SplittingOutlineParser();
                outlineParser.setMarkupLanguage(markupLanguage.clone());
                outlineParser.setSplittingStrategy(splittingStrategy);
                SplitOutlineItem item = outlineParser.parse(markupContent);
                item.setSplitTarget(htmlOutputFile.getName());
                SplittingHtmlDocumentBuilder splittingBuilder = new SplittingHtmlDocumentBuilder();
                splittingBuilder.setRootBuilder(builder);
                splittingBuilder.setOutline(item);
                splittingBuilder.setRootFile(htmlOutputFile);
                splittingBuilder.setNavigationImages(this.navigationImages);
                splittingBuilder.setFormatting(this.formatOutput);
                MarkupParser parser = new MarkupParser();
                parser.setMarkupLanguage(markupLanguage);
                parser.setBuilder(splittingBuilder);
                parser.parse(markupContent);
                this.processed(markupContent, item, baseDir, source);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.17"), htmlOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.17"), htmlOutputFile, e.getMessage()), (Throwable)e);
            }
        }
        return markupContent;
    }

    void processed(String markupContent, SplitOutlineItem item, File baseDir, File source) {
    }

    protected File computeHtmlFile(File source, String name) {
        return new File(source.getParentFile(), this.htmlFilenameFormat.replace("$1", name));
    }

    public String getHtmlFilenameFormat() {
        return this.htmlFilenameFormat;
    }

    public void setHtmlFilenameFormat(String htmlFilenameFormat) {
        this.htmlFilenameFormat = htmlFilenameFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException();
        }
        this.stylesheets.add(stylesheet);
    }

    public boolean isMultipleOutputFiles() {
        return this.multipleOutputFiles;
    }

    public void setMultipleOutputFiles(boolean multipleOutputFiles) {
        this.multipleOutputFiles = multipleOutputFiles;
    }

    public boolean isFormatOutput() {
        return this.formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    public boolean isNavigationImages() {
        return this.navigationImages;
    }

    public void setNavigationImages(boolean navigationImages) {
        this.navigationImages = navigationImages;
    }

    public boolean isUseInlineCssStyles() {
        return this.useInlineCssStyles;
    }

    public void setUseInlineCssStyles(boolean useInlineCssStyles) {
        this.useInlineCssStyles = useInlineCssStyles;
    }

    public boolean isSuppressBuiltInCssStyles() {
        return this.suppressBuiltInCssStyles;
    }

    public void setSuppressBuiltInCssStyles(boolean suppressBuiltInCssStyles) {
        this.suppressBuiltInCssStyles = suppressBuiltInCssStyles;
    }

    public String getLinkRel() {
        return this.linkRel;
    }

    public void setLinkRel(String linkRel) {
        this.linkRel = linkRel;
    }

    public String getPrependImagePrefix() {
        return this.prependImagePrefix;
    }

    public void setPrependImagePrefix(String prependImagePrefix) {
        this.prependImagePrefix = prependImagePrefix;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getDefaultAbsoluteLinkTarget() {
        return this.defaultAbsoluteLinkTarget;
    }

    public void setDefaultAbsoluteLinkTarget(String defaultAbsoluteLinkTarget) {
        this.defaultAbsoluteLinkTarget = defaultAbsoluteLinkTarget;
    }

    public boolean isXhtmlStrict() {
        return this.xhtmlStrict;
    }

    public void setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
    }

    public boolean getEmitDoctype() {
        return this.emitDoctype;
    }

    public void setEmitDoctype(boolean emitDtd) {
        this.emitDoctype = emitDtd;
    }

    public String getHtmlDoctype() {
        return this.htmlDoctype;
    }

    public void setHtmlDoctype(String htmlDoctype) {
        this.htmlDoctype = htmlDoctype;
    }

    public static class Attribute {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Stylesheet {
        private File file;
        private String url;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void addConfiguredAttribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute.getValue());
        }
    }
}

