/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import org.apache.maven.model.Build;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public abstract class AbstractLifecycleMapping
implements ILifecycleMapping {
    private String name;
    protected String id;

    public void configure(ProjectConfigurationRequest request, IProgressMonitor mon) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)5);
        try {
            IFolder container;
            String directory;
            MavenPlugin.getProjectConfigurationManager().addMavenBuilder(request.getProject(), null, (IProgressMonitor)monitor.newChild(1));
            IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
            Build build = projectFacade.getMavenProject((IProgressMonitor)monitor.newChild(1)).getBuild();
            if (build != null && (directory = build.getDirectory()) != null && (container = projectFacade.getProject().getFolder(projectFacade.getProjectRelativePath(directory))) != null) {
                if (!container.exists() && container instanceof IFolder) {
                    M2EUtils.createFolder(container, true, (IProgressMonitor)monitor.newChild(1));
                } else {
                    container.setDerived(true, (IProgressMonitor)monitor.newChild(1));
                }
            }
            SubMonitor confMon = null;
            for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, (IProgressMonitor)monitor.newChild(1))) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (confMon == null) {
                    confMon = monitor.newChild(1);
                }
                configurator.configure(request, (IProgressMonitor)confMon.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
        for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, monitor)) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            configurator.unconfigure(request, monitor);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract boolean hasLifecycleMappingChanged(IMavenProjectFacade var1, ILifecycleMappingConfiguration var2, IProgressMonitor var3);
}

