/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCustomizableLifecycleMapping
extends AbstractLifecycleMapping {
    private static Logger log = LoggerFactory.getLogger(AbstractCustomizableLifecycleMapping.class);

    @Override
    public Map<MojoExecutionKey, List<AbstractBuildParticipant>> getBuildParticipants(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        log.debug("Build participants for {}", (Object)projectFacade.getMavenProject());
        LinkedHashMap<MojoExecutionKey, List<AbstractBuildParticipant>> result = new LinkedHashMap<MojoExecutionKey, List<AbstractBuildParticipant>>();
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mapping = projectFacade.getMojoExecutionMapping();
        Map<String, AbstractProjectConfigurator> configurators = this.getProjectConfigurators(projectFacade);
        List<MojoExecution> mojoExecutions = ((MavenProjectFacade)projectFacade).getExecutionPlan("deploy", monitor);
        if (mojoExecutions != null) {
            for (MojoExecution mojoExecution : mojoExecutions) {
                MojoExecutionKey mojoExecutionKey = new MojoExecutionKey(mojoExecution);
                log.debug("Mojo execution key: {}", (Object)mojoExecutionKey);
                List<IPluginExecutionMetadata> executionMetadatas = mapping.get(mojoExecutionKey);
                ArrayList<AbstractBuildParticipant> executionMappings = new ArrayList<AbstractBuildParticipant>();
                if (executionMetadatas != null) {
                    block6: for (IPluginExecutionMetadata executionMetadata : executionMetadatas) {
                        log.debug("\tAction: {}", (Object)executionMetadata.getAction());
                        switch (executionMetadata.getAction()) {
                            case execute: {
                                executionMappings.add(LifecycleMappingFactory.createMojoExecutionBuildParicipant(projectFacade, projectFacade.getMojoExecution(mojoExecutionKey, monitor), executionMetadata));
                                break;
                            }
                            case configurator: {
                                String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(executionMetadata);
                                log.debug("\t\tProject configurator id: {}", (Object)configuratorId);
                                AbstractProjectConfigurator configurator = configurators.get(configuratorId);
                                log.debug("\t\tProject configurator: {}", (Object)configurator.getClass().getName());
                                AbstractBuildParticipant buildParticipant = configurator.getBuildParticipant(projectFacade, projectFacade.getMojoExecution(mojoExecutionKey, monitor), executionMetadata);
                                if (buildParticipant == null) continue block6;
                                log.debug("\t\tBuild participant: {}", (Object)buildParticipant.getClass().getName());
                                executionMappings.add(buildParticipant);
                                break;
                            }
                            case ignore: 
                            case error: {
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Missing handling for action=" + (Object)((Object)executionMetadata.getAction()));
                            }
                        }
                    }
                }
                result.put(mojoExecutionKey, executionMappings);
            }
        }
        return result;
    }

    @Override
    public List<AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade projectFacade, IProgressMonitor monitor) {
        return new ArrayList<AbstractProjectConfigurator>(this.getProjectConfigurators(projectFacade).values());
    }

    private Map<String, AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade projectFacade) {
        return LifecycleMappingFactory.getProjectConfigurators(projectFacade);
    }

    @Override
    public boolean hasLifecycleMappingChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldConfiguration, IProgressMonitor monitor) {
        if (!this.getId().equals(newFacade.getLifecycleMappingId())) {
            throw new IllegalArgumentException();
        }
        if (oldConfiguration == null || !this.getId().equals(oldConfiguration.getLifecycleMappingId())) {
            return true;
        }
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> oldMappings = oldConfiguration.getMojoExecutionMapping();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : newFacade.getMojoExecutionMapping().entrySet()) {
            List<IPluginExecutionMetadata> metadatas = entry.getValue();
            List<IPluginExecutionMetadata> oldMetadatas = oldMappings.get(entry.getKey());
            if (metadatas == null || metadatas.isEmpty()) {
                if (oldMetadatas == null || oldMetadatas.isEmpty()) continue;
                return true;
            }
            if (oldMetadatas == null || oldMetadatas.isEmpty()) {
                return true;
            }
            if (metadatas.size() != oldMetadatas.size()) {
                return true;
            }
            int i = 0;
            while (i < metadatas.size()) {
                IPluginExecutionMetadata metadata = metadatas.get(i);
                IPluginExecutionMetadata oldMetadata = oldMetadatas.get(i);
                if (metadata == null) {
                    if (oldMetadata != null) {
                        return true;
                    }
                } else {
                    if (oldMetadata == null) {
                        return true;
                    }
                    if (metadata.getAction() != oldMetadata.getAction()) {
                        return true;
                    }
                    switch (metadata.getAction()) {
                        case ignore: 
                        case execute: {
                            break;
                        }
                        case error: {
                            break;
                        }
                        case configurator: {
                            String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
                            String oldConfiguratorId = LifecycleMappingFactory.getProjectConfiguratorId(oldMetadata);
                            if (!AbstractCustomizableLifecycleMapping.eq(configuratorId, oldConfiguratorId)) {
                                return true;
                            }
                            try {
                                AbstractProjectConfigurator configurator = LifecycleMappingFactory.createProjectConfigurator(metadata);
                                if (!configurator.hasConfigurationChanged(newFacade, oldConfiguration, entry.getKey(), monitor)) break;
                                return true;
                            }
                            catch (LifecycleMappingConfigurationException lifecycleMappingConfigurationException) {}
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

