/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.repository;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactRepositoryRef;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.ISettingsChangeListener;
import org.eclipse.m2e.core.internal.repository.IRepositoryDiscoverer;
import org.eclipse.m2e.core.internal.repository.IRepositoryIndexer;
import org.eclipse.m2e.core.internal.repository.RepositoryInfo;
import org.eclipse.m2e.core.internal.repository.RepositoryRegistryUpdateJob;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryRegistry
implements IRepositoryRegistry,
IMavenProjectChangedListener,
ISettingsChangeListener {
    private static final Logger log = LoggerFactory.getLogger(RepositoryRegistry.class);
    private final IMaven maven;
    private final IMavenProjectRegistry projectManager;
    private final Map<String, RepositoryInfo> repositories = new ConcurrentHashMap<String, RepositoryInfo>();
    private RepositoryInfo localRepository;
    private final Object localRepositoryLock = new Object();
    private final RepositoryInfo workspaceRepository;
    private ArrayList<IRepositoryIndexer> indexers = new ArrayList();
    private ArrayList<IRepositoryDiscoverer> discoverers = new ArrayList();
    private final RepositoryRegistryUpdateJob job = new RepositoryRegistryUpdateJob(this);

    public RepositoryRegistry(IMaven maven, IMavenProjectRegistry projectManager) {
        this.maven = maven;
        this.projectManager = projectManager;
        this.workspaceRepository = new RepositoryInfo(null, "workspace://", null, 4, null);
    }

    private RepositoryInfo newLocalRepositoryInfo() {
        String localUrl;
        File localBasedir = new File(this.maven.getLocalRepositoryPath());
        try {
            localBasedir = localBasedir.getCanonicalFile();
        }
        catch (IOException iOException) {
            localBasedir = localBasedir.getAbsoluteFile();
        }
        try {
            localUrl = localBasedir.toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            log.error("Could not parse local repository path", (Throwable)ex);
            localUrl = "file://" + localBasedir.getAbsolutePath();
        }
        RepositoryInfo localRepository = new RepositoryInfo(null, localUrl, localBasedir, 2, null);
        return localRepository;
    }

    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        Settings settings = null;
        try {
            settings = this.maven.getSettings();
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade facade;
            MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
            IMavenProjectFacade oldFacade = event.getOldMavenProject();
            if (oldFacade != null) {
                this.removeProjectRepositories(oldFacade, monitor);
            }
            if ((facade = event.getMavenProject()) != null) {
                try {
                    this.addProjectRepositories(settings, facade, null);
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private void addProjectRepositories(Settings settings, IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        ArrayList<ArtifactRepositoryRef> repositories = this.getProjectRepositories(facade);
        for (ArtifactRepositoryRef repo : repositories) {
            RepositoryInfo repository = this.getRepository(repo);
            if (repository != null) {
                repository.addProject(facade.getPom().getFullPath());
                continue;
            }
            AuthenticationInfo auth = this.getAuthenticationInfo(settings, repo.getId());
            repository = new RepositoryInfo(repo.getId(), repo.getUrl(), 16, auth);
            repository.addProject(facade.getPom().getFullPath());
            this.addRepository(repository, monitor);
        }
    }

    public void addRepository(RepositoryInfo repository, IProgressMonitor monitor) {
        if (!this.repositories.containsKey(repository.getUid())) {
            this.repositories.put(repository.getUid(), repository);
            for (IRepositoryIndexer indexer : this.indexers) {
                try {
                    indexer.repositoryAdded(repository, monitor);
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void removeProjectRepositories(IMavenProjectFacade facade, IProgressMonitor monitor) {
        ArrayList<ArtifactRepositoryRef> repositories = this.getProjectRepositories(facade);
        for (ArtifactRepositoryRef repo : repositories) {
            RepositoryInfo repository = this.getRepository(repo);
            if (repository == null || !repository.isScope(16)) continue;
            repository.removeProject(facade.getPom().getFullPath());
            if (!repository.getProjects().isEmpty()) continue;
            this.removeRepository(repository, monitor);
        }
    }

    private void removeRepository(RepositoryInfo repository, IProgressMonitor monitor) {
        this.repositories.remove(repository.getUid());
        for (IRepositoryIndexer indexer : this.indexers) {
            try {
                indexer.repositoryRemoved(repository, monitor);
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ArrayList<ArtifactRepositoryRef> getProjectRepositories(IMavenProjectFacade facade) {
        ArrayList<ArtifactRepositoryRef> repositories = new ArrayList<ArtifactRepositoryRef>();
        repositories.addAll(facade.getArtifactRepositoryRefs());
        repositories.addAll(facade.getPluginArtifactRepositoryRefs());
        return repositories;
    }

    public AuthenticationInfo getAuthenticationInfo(Settings settings, String id) throws CoreException {
        if (settings == null) {
            return null;
        }
        Server server = settings.getServer(id);
        if (server == null || server.getUsername() == null) {
            return null;
        }
        server = this.maven.decryptPassword(server);
        AuthenticationInfo info = new AuthenticationInfo();
        info.setUserName(server.getUsername());
        info.setPassword(server.getPassword());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegistry(IProgressMonitor monitor) throws CoreException {
        Settings settings = this.maven.getSettings();
        List<Mirror> mirrors = this.maven.getMirrors();
        for (IRepositoryIndexer indexer : this.indexers) {
            indexer.initialize(monitor);
        }
        HashMap<String, RepositoryInfo> oldRepositories = new HashMap<String, RepositoryInfo>(this.repositories);
        this.repositories.clear();
        this.addRepository(this.workspaceRepository, monitor);
        Object object = this.localRepositoryLock;
        synchronized (object) {
            this.localRepository = this.newLocalRepositoryInfo();
        }
        this.addRepository(this.localRepository, monitor);
        for (Mirror mirror : mirrors) {
            AuthenticationInfo auth = this.getAuthenticationInfo(settings, mirror.getId());
            RepositoryInfo repository = new RepositoryInfo(mirror.getId(), mirror.getUrl(), 8, auth);
            repository.setMirrorOf(mirror.getMirrorOf());
            this.addRepository(repository, monitor);
        }
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        repos.addAll(this.maven.getArtifactRepositories(false));
        repos.addAll(this.maven.getPluginArtifactRepositories(false));
        for (ArtifactRepository repo : repos) {
            Mirror mirror = this.maven.getMirror(repo);
            AuthenticationInfo auth = this.getAuthenticationInfo(settings, repo.getId());
            RepositoryInfo repository = new RepositoryInfo(repo.getId(), repo.getUrl(), 8, auth);
            if (mirror != null) {
                repository.setMirrorId(mirror.getId());
            }
            this.addRepository(repository, monitor);
        }
        IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
        int n = iMavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
            this.addProjectRepositories(settings, facade, monitor);
            ++n2;
        }
        for (IRepositoryDiscoverer discoverer : this.discoverers) {
            discoverer.addRepositories(this, monitor);
        }
        oldRepositories.keySet().removeAll(this.repositories.keySet());
        for (RepositoryInfo repository : oldRepositories.values()) {
            this.removeRepository(repository, monitor);
        }
    }

    @Override
    public List<IRepository> getRepositories(int scope) {
        ArrayList<IRepository> result = new ArrayList<IRepository>();
        for (RepositoryInfo repository : this.repositories.values()) {
            if (!repository.isScope(scope)) continue;
            result.add(repository);
        }
        return result;
    }

    public void updateRegistry() {
        this.job.updateRegistry();
    }

    public void addRepositoryIndexer(IRepositoryIndexer indexer) {
        this.indexers.add(indexer);
    }

    public void addRepositoryDiscoverer(IRepositoryDiscoverer discoverer) {
        this.discoverers.add(discoverer);
    }

    @Override
    public RepositoryInfo getRepository(ArtifactRepositoryRef ref) {
        String uid = RepositoryInfo.getUid(ref.getId(), ref.getUrl(), ref.getUsername());
        return this.repositories.get(uid);
    }

    @Override
    public IRepository getWorkspaceRepository() {
        return this.workspaceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepository getLocalRepository() {
        Object object = this.localRepositoryLock;
        synchronized (object) {
            if (this.localRepository == null) {
                this.localRepository = this.newLocalRepositoryInfo();
            }
        }
        return this.localRepository;
    }

    @Override
    public void settingsChanged(Settings settings) {
        this.updateRegistry();
    }
}

