/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceStateWriter
implements IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceStateWriter.class);
    private MavenProjectManager projectManager;

    public WorkspaceStateWriter(MavenProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        try {
            Properties state = new Properties();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade projectFacade = iMavenProjectFacadeArray[n2];
                try {
                    File pom;
                    Artifact artifact = projectFacade.getMavenProject(monitor).getArtifact();
                    IFile pomFile = projectFacade.getPom();
                    IPath location = pomFile.getLocation();
                    if (location != null && (pom = location.toFile()).canRead()) {
                        String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":pom:" + artifact.getBaseVersion();
                        state.put(key, pom.getCanonicalPath());
                    }
                    IResource outputLocation = root.findMember(projectFacade.getOutputLocation());
                    if (!"pom".equals(artifact.getType()) && outputLocation != null && outputLocation.exists()) {
                        String extension = artifact.getArtifactHandler().getExtension();
                        String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":" + extension + ":" + artifact.getBaseVersion();
                        state.put(key, outputLocation.getLocation().toFile().getCanonicalPath());
                    }
                }
                catch (CoreException ex) {
                    log.error("Error writing workspace state file", (Throwable)ex);
                }
                ++n2;
            }
            BufferedOutputStream buf = new BufferedOutputStream(new FileOutputStream(this.projectManager.getWorkspaceStateFile()));
            try {
                state.store(buf, null);
            }
            finally {
                ((OutputStream)buf).close();
            }
        }
        catch (IOException ex) {
            log.error("Error writing workspace state file", (Throwable)ex);
        }
    }
}

