/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.artifact.DefaultMavenMetadataCache;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.IManagedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseMavenMetadataCache
extends DefaultMavenMetadataCache
implements MavenMetadataCache,
IManagedCache {
    public void put(Artifact artifact, boolean resolveManagedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ResolutionGroup result) {
        ArtifactKey gav = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null);
        if ("pom".equals(artifact.getType())) {
            this.removeProject(gav);
        }
        super.put(artifact, resolveManagedVersions, localRepository, remoteRepositories, result);
    }

    @Override
    public void removeProject(IFile pom, ArtifactKey key) {
        this.removeProject(key);
    }

    private void removeProject(ArtifactKey key) {
        if (key == null) {
            return;
        }
        Iterator iter = this.cache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DefaultMavenMetadataCache.CacheRecord record = (DefaultMavenMetadataCache.CacheRecord)entry.getValue();
            if (!this.equals(record.getArtifact(), key) && !this.contains(record.getArtifacts(), key)) continue;
            iter.remove();
        }
    }

    private boolean contains(List<Artifact> artifacts, ArtifactKey key) {
        for (Artifact artifact : artifacts) {
            if (!this.equals(artifact, key)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Artifact artifact, ArtifactKey key) {
        return EclipseMavenMetadataCache.eq(key.getGroupId(), artifact.getGroupId()) && EclipseMavenMetadataCache.eq(key.getArtifactId(), artifact.getArtifactId()) && EclipseMavenMetadataCache.eq(key.getVersion(), artifact.getBaseVersion());
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

