/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.internal.repository.IRepositoryDiscoverer;
import org.eclipse.m2e.core.internal.repository.RepositoryInfo;
import org.eclipse.m2e.core.internal.repository.RepositoryRegistry;

public class IndexesExtensionReader
implements IRepositoryDiscoverer {
    private static final String EXTENSION_INDEXES = "org.eclipse.m2e.core.indexes";
    private static final String ELEMENT_INDEX = "index";
    private static final String ATTR_INDEX_ID = "indexId";
    private static final String ATTR_REPOSITORY_URL = "repositoryUrl";
    private static final String ATTR_IS_SHORT = "isShort";
    private final NexusIndexManager indexManager;

    public IndexesExtensionReader(NexusIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void addRepositories(RepositoryRegistry registry, IProgressMonitor monitor) throws CoreException {
        IExtensionPoint indexesExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_INDEXES);
        if (indexesExtensionPoint != null) {
            IExtension[] indexesExtensions;
            IExtension[] iExtensionArray = indexesExtensions = indexesExtensionPoint.getExtensions();
            int n = indexesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_INDEX)) {
                        this.processIndexElement(registry, element, monitor);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void processIndexElement(RepositoryRegistry registry, IConfigurationElement element, IProgressMonitor monitor) throws CoreException {
        String indexId = element.getAttribute(ATTR_INDEX_ID);
        String repositoryUrl = element.getAttribute(ATTR_REPOSITORY_URL);
        boolean isShort = Boolean.valueOf(element.getAttribute(ATTR_IS_SHORT));
        RepositoryInfo repository = new RepositoryInfo(indexId, repositoryUrl, 1, null);
        registry.addRepository(repository, monitor);
        this.indexManager.setIndexDetails(repository, isShort ? "min" : "full", null);
    }
}

