/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import com.ning.http.client.BodyConsumer;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.SimpleAsyncHttpClient;
import com.ning.http.client.ThrowableHandler;
import com.ning.http.client.consumers.OutputStreamBodyConsumer;
import com.ning.http.client.simple.HeaderMap;
import com.ning.http.client.simple.SimpleAHCTransferListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.maven.index.updater.AbstractResourceFetcher;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFetcher
extends AbstractResourceFetcher {
    private static Logger log = LoggerFactory.getLogger(AsyncFetcher.class);
    private final AuthenticationInfo authInfo;
    private final ProxyInfo proxyInfo;
    private final String userAgent;
    private final IProgressMonitor monitor;
    private SimpleAsyncHttpClient httpClient;
    private String baseUrl;
    private final Map<String, Future<Response>> futures = new ConcurrentHashMap<String, Future<Response>>();
    private final Map<String, Streams> streams = new ConcurrentHashMap<String, Streams>();

    public AsyncFetcher(AuthenticationInfo authInfo, ProxyInfo proxyInfo, IProgressMonitor monitor) {
        this.authInfo = authInfo;
        this.proxyInfo = proxyInfo;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.userAgent = this.computeUserAgent();
    }

    void cancel(String url) {
        Future<Response> future = this.futures.remove(url);
        if (future != null) {
            future.cancel(true);
        }
    }

    void closeStream(String url, Throwable exception) {
        log.debug("Closing streams for {} due to {}", new Object[]{url, exception.getMessage(), exception});
        Streams s = this.streams.remove(url);
        if (s == null) {
            return;
        }
        PipedErrorInputStream pis = s.in;
        pis.setError(exception);
        try {
            s.out.close();
        }
        catch (IOException iOException) {}
    }

    public void connect(String id, String url) {
        this.httpClient = this.createClient(url);
        this.baseUrl = url.endsWith("/") ? url : String.valueOf(url) + '/';
    }

    private SimpleAsyncHttpClient createClient(String url) {
        SimpleAsyncHttpClient.Builder sahcBuilder = new SimpleAsyncHttpClient.Builder();
        sahcBuilder.setUserAgent(this.userAgent);
        sahcBuilder.setConnectionTimeoutInMs(15000);
        sahcBuilder.setRequestTimeoutInMs(60000);
        sahcBuilder.setCompressionEnabled(true);
        sahcBuilder.setFollowRedirects(true);
        sahcBuilder.setErrorDocumentBehaviour(SimpleAsyncHttpClient.ErrorDocumentBehaviour.OMIT);
        sahcBuilder.setListener((SimpleAHCTransferListener)new MonitorListener(this.monitor));
        this.addAuthInfo(sahcBuilder);
        this.addProxyInfo(url, sahcBuilder);
        return sahcBuilder.build();
    }

    private String computeUserAgent() {
        String osgiVersion = (String)Platform.getBundle((String)"org.eclipse.osgi").getHeaders().get("Bundle-Version");
        String m2eVersion = MavenPluginActivator.getQualifiedVersion();
        return "m2e/" + osgiVersion + "/" + m2eVersion;
    }

    private void addAuthInfo(SimpleAsyncHttpClient.Builder configBuilder) {
        if (this.authInfo != null && this.authInfo.getUserName() != null && this.authInfo.getUserName().length() > 0) {
            configBuilder.setRealmScheme(Realm.AuthScheme.BASIC);
            configBuilder.setRealmPrincipal(this.authInfo.getUserName());
            configBuilder.setRealmPassword(this.authInfo.getPassword());
            configBuilder.setRealmUsePreemptiveAuth(true);
        }
    }

    private void addProxyInfo(String url, SimpleAsyncHttpClient.Builder configBuilder) {
        Repository repo;
        if (this.proxyInfo != null && !ProxyUtils.validateNonProxyHosts((ProxyInfo)this.proxyInfo, (String)(repo = new Repository("id", url)).getHost()) && this.proxyInfo != null) {
            ProxyServer.Protocol protocol = "https".equalsIgnoreCase(this.proxyInfo.getType()) ? ProxyServer.Protocol.HTTPS : ProxyServer.Protocol.HTTP;
            configBuilder.setProxyProtocol(protocol);
            configBuilder.setProxyHost(this.proxyInfo.getHost());
            configBuilder.setProxyPort(this.proxyInfo.getPort());
            configBuilder.setProxyPrincipal(this.proxyInfo.getUserName());
            configBuilder.setProxyPassword(this.proxyInfo.getPassword());
        }
    }

    public void disconnect() {
        this.baseUrl = null;
        this.futures.clear();
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        this.httpClient = null;
    }

    public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
        InputStream is = this.retrieve(name);
        try {
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(is), (File)targetFile);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    public InputStream retrieve(String name) throws IOException, FileNotFoundException {
        String url = AsyncFetcher.buildUrl(this.baseUrl, name);
        this.monitor.subTask(NLS.bind((String)Messages.AsyncFetcher_task_fetching, (Object)url));
        PipedErrorInputStream pis = new PipedErrorInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        OutputStreamBodyConsumer consumer = new OutputStreamBodyConsumer((OutputStream)pos);
        this.streams.put(url, new Streams(pis, pos));
        Future future = this.httpClient.derive().setUrl(url).build().get((BodyConsumer)consumer, (ThrowableHandler)new ErrorPropagator(url));
        this.futures.put(url, future);
        return pis;
    }

    private static String buildUrl(String baseUrl, String resourceName) {
        String url = baseUrl;
        url = resourceName.startsWith("/") ? String.valueOf(url) + resourceName.substring(1) : String.valueOf(url) + resourceName;
        return url;
    }

    final class ErrorPropagator
    implements ThrowableHandler {
        private final String url;

        ErrorPropagator(String url) {
            this.url = url;
        }

        public void onThrowable(Throwable t) {
            AsyncFetcher.this.closeStream(this.url, t);
        }
    }

    private class MonitorListener
    implements SimpleAHCTransferListener {
        private IProgressMonitor monitor;

        public MonitorListener(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        private void checkCancelled(String url) {
            if (this.monitor.isCanceled()) {
                AsyncFetcher.this.cancel(url);
            }
        }

        public void onStatus(String url, int code, String text) {
            this.checkCancelled(url);
            if (code != 200) {
                AsyncFetcher.this.closeStream(url, new IOException(NLS.bind((String)Messages.AsyncFetcher_error_server, (Object)code, (Object)text)));
            }
        }

        public void onHeaders(String url, HeaderMap arg1) {
            this.checkCancelled(url);
        }

        public void onBytesReceived(String url, long amount, long current, long total) {
            this.checkCancelled(url);
            this.monitor.subTask(NLS.bind((String)Messages.AsyncFetcher_task_fetching2, (Object)url, (Object)(amount * 100L / total)));
        }

        public void onBytesSent(String arg0, long arg1, long arg2, long arg3) {
        }

        public void onCompleted(String arg0, int arg1, String arg2) {
            this.monitor.subTask("");
        }
    }

    static final class PipedErrorInputStream
    extends PipedInputStream {
        private volatile Throwable error;

        public PipedErrorInputStream() {
            this.buffer = new byte[131072];
        }

        public void setError(Throwable t) {
            if (this.error == null) {
                this.error = t;
            }
        }

        private void checkError() throws IOException {
            if (this.error != null) {
                throw (IOException)new IOException(this.error.getMessage()).initCause(this.error);
            }
        }

        public synchronized int read() throws IOException {
            this.checkError();
            int b = super.read();
            this.checkError();
            return b;
        }
    }

    private final class Streams {
        PipedErrorInputStream in;
        PipedOutputStream out;

        public Streams(PipedErrorInputStream pis, PipedOutputStream pos) {
            this.in = pis;
            this.out = pos;
        }
    }
}

