/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.jdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.jdt.internal.ui.text.TextMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.AbstractHierarchyViewerSorter;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FocusDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.OverrideIndicatorLabelDecorator;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class JavaOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private IJavaElement fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    private boolean fShowOnlyMainType;
    private LexicalSortingAction fLexicalSortingAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;
    private ShowOnlyMainTypeAction fShowOnlyMainTypeAction;
    private Map<IType, ITypeHierarchy> fTypeHierarchies = new HashMap<IType, ITypeHierarchy>();
    private CategoryFilterActionGroup fCategoryFilterActionGroup;
    private String fPattern;

    public JavaOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId) {
        super(parent, shellStyle, treeStyle, commandId, true);
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        treeViewer.addFilter(new MemberFilter());
        this.fInnerLabelProvider = new OutlineLabelProvider();
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        IDecoratorManager decoratorMgr = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorMgr.getEnabled("org.eclipse.jdt.ui.override.decorator")) {
            this.fInnerLabelProvider.addLabelDecorator(new OverrideIndicatorLabelDecorator(null));
        }
        treeViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider(this.fInnerLabelProvider));
        this.fLexicalSortingAction = new LexicalSortingAction(treeViewer);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(treeViewer);
        this.fShowOnlyMainTypeAction = new ShowOnlyMainTypeAction(treeViewer);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup((StructuredViewer)treeViewer, this.getId(), this.getInputForCategories());
        this.fOutlineContentProvider = new OutlineContentProvider(false);
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        treeViewer.setComparator(this.fOutlineSorter);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            return Messages.format(JavaUIMessages.JavaOutlineControl_statusFieldText_hideInheritedMembers, keySequence);
        }
        return Messages.format(JavaUIMessages.JavaOutlineControl_statusFieldText_showInheritedMembers, keySequence);
    }

    protected String getId() {
        return "org.eclipse.jdt.internal.ui.text.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement je = (IJavaElement)information;
        ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
        this.fInput = cu != null ? cu : je.getAncestor(6);
        this.inputChanged(this.fInput, information);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = JavaOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            JavaOutlineInformationControl.this.toggleShowInheritedMembers();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void toggleShowInheritedMembers() {
        long flags = this.fInnerLabelProvider.getTextFlags();
        this.fInnerLabelProvider.setTextFlags(flags ^= JavaElementLabels.ALL_POST_QUALIFIED);
        this.fOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IAction)this.fShowOnlyMainTypeAction);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.fLexicalSortingAction);
        viewMenu.add((IAction)this.fSortByDefiningTypeAction);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
        this.fCategoryFilterActionGroup.contributeToViewMenu(viewMenu);
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.fPattern = pattern;
        if (pattern.length() == 0 || !this.fSortByDefiningTypeAction.isChecked()) {
            super.setMatcherString(pattern, update);
            return;
        }
        boolean ignoreCase = pattern.toLowerCase().equals(pattern);
        String pattern2 = "*" + JavaElementLabels.CONCAT_STRING + pattern;
        this.fStringMatcher = new OrStringMatcher(pattern, pattern2, ignoreCase);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private IJavaElement[] getInputForCategories() {
        if (this.fInput == null) {
            return new IJavaElement[0];
        }
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            IJavaElement p = this.fInput;
            if (p instanceof ITypeRoot) {
                p = ((ITypeRoot)p).findPrimaryType();
            }
            while (p != null && !(p instanceof IType)) {
                p = p.getParent();
            }
            if (!(p instanceof IType)) {
                return new IJavaElement[]{this.fInput};
            }
            ITypeHierarchy hierarchy = this.getSuperTypeHierarchy((IType)p);
            if (hierarchy == null) {
                return new IJavaElement[]{this.fInput};
            }
            IType[] supertypes = hierarchy.getAllSupertypes((IType)p);
            IJavaElement[] result = new IJavaElement[supertypes.length + 1];
            result[0] = this.fInput;
            System.arraycopy(supertypes, 0, result, 1, supertypes.length);
            return result;
        }
        return new IJavaElement[]{this.fInput};
    }

    private ITypeHierarchy getSuperTypeHierarchy(IType type) {
        ITypeHierarchy th = this.fTypeHierarchies.get(type);
        if (th == null) {
            try {
                th = SuperTypeHierarchyCache.getTypeHierarchy(type, this.getProgressMonitor());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            this.fTypeHierarchies.put(type, th);
        }
        return th;
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer outlineViewer) {
            super(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_label, 2);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_tooltip);
            this.setDescription(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_description);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            boolean checked = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.lexical_sorting_browsing_action");
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    LexicalSortingAction.this.fOutlineViewer.refresh(false);
                }
            });
            if (store) {
                JavaOutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
            }
        }
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String pattern1, String pattern2, boolean ignoreCase) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(pattern1, ignoreCase, false);
            this.fMatcher2 = new StringMatcher(pattern2, ignoreCase, false);
        }

        public boolean match(String text) {
            return this.fMatcher2.match(text) || this.fMatcher1.match(text);
        }
    }

    private class OutlineContentProvider
    extends StandardJavaElementContentProvider {
        private boolean fShowInheritedMembers;

        private OutlineContentProvider(boolean showInheritedMembers) {
            super(true);
            this.fShowInheritedMembers = showInheritedMembers;
        }

        public boolean isShowingInheritedMembers() {
            return this.fShowInheritedMembers;
        }

        public void toggleShowInheritedMembers() {
            Tree tree = JavaOutlineInformationControl.this.getTreeViewer().getTree();
            tree.setRedraw(false);
            this.fShowInheritedMembers = !this.fShowInheritedMembers;
            JavaOutlineInformationControl.this.getTreeViewer().refresh();
            JavaOutlineInformationControl.this.getTreeViewer().expandToLevel(2);
            Object selectedElement = JavaOutlineInformationControl.this.getSelectedElement();
            if (selectedElement != null) {
                JavaOutlineInformationControl.this.getTreeViewer().reveal(selectedElement);
            } else {
                JavaOutlineInformationControl.this.selectFirstMatch();
            }
            tree.setRedraw(true);
        }

        public Object[] getChildren(Object element) {
            ITypeHierarchy th;
            IType type;
            if (JavaOutlineInformationControl.this.fShowOnlyMainType) {
                if (element instanceof ITypeRoot) {
                    element = ((ITypeRoot)element).findPrimaryType();
                }
                if (element == null) {
                    return NO_CHILDREN;
                }
            }
            if (this.fShowInheritedMembers && element instanceof IType && ((type = (IType)element).getDeclaringType() == null || type.equals(JavaOutlineInformationControl.this.fInitiallySelectedType)) && (th = JavaOutlineInformationControl.this.getSuperTypeHierarchy(type)) != null) {
                ArrayList<Object> children = new ArrayList<Object>();
                IType[] superClasses = th.getAllSupertypes(type);
                children.addAll(Arrays.asList(super.getChildren(type)));
                int i = 0;
                int scLength = superClasses.length;
                while (i < scLength) {
                    children.addAll(Arrays.asList(super.getChildren(superClasses[i])));
                    ++i;
                }
                return children.toArray();
            }
            return super.getChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            JavaOutlineInformationControl.this.fTypeHierarchies.clear();
        }

        public void dispose() {
            super.dispose();
            if (JavaOutlineInformationControl.this.fCategoryFilterActionGroup != null) {
                JavaOutlineInformationControl.this.fCategoryFilterActionGroup.dispose();
                JavaOutlineInformationControl.this.fCategoryFilterActionGroup = null;
            }
            JavaOutlineInformationControl.this.fTypeHierarchies.clear();
        }
    }

    private class OutlineLabelProvider
    extends AppearanceAwareLabelProvider {
        private boolean fShowDefiningType;

        private OutlineLabelProvider() {
            super(0x210000204029L | JavaElementLabels.ALL_CATEGORY | 0x2000000000L, 1);
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (this.fShowDefiningType) {
                try {
                    IType type = this.getDefiningType(element);
                    if (type != null) {
                        StringBuffer buf = new StringBuffer(super.getText(type));
                        buf.append(JavaElementLabels.CONCAT_STRING);
                        buf.append(text);
                        return buf.toString();
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return text;
        }

        public Color getForeground(Object element) {
            if (JavaOutlineInformationControl.this.fOutlineContentProvider.isShowingInheritedMembers()) {
                if (element instanceof IJavaElement) {
                    IJavaElement je = (IJavaElement)element;
                    je = JavaOutlineInformationControl.this.fInput.getElementType() == 6 ? je.getAncestor(6) : je.getAncestor(5);
                    if (JavaOutlineInformationControl.this.fInput.equals(je)) {
                        return null;
                    }
                }
                return JFaceResources.getColorRegistry().get("org.eclipse.jdt.ui.ColoredLabels.inherited");
            }
            return null;
        }

        public void setShowDefiningType(boolean showDefiningType) {
            this.fShowDefiningType = showDefiningType;
        }

        private IType getDefiningType(Object element) throws JavaModelException {
            int kind = ((IJavaElement)element).getElementType();
            if (kind != 9 && kind != 8 && kind != 10) {
                return null;
            }
            IType declaringType = ((IMember)element).getDeclaringType();
            if (kind != 9) {
                return declaringType;
            }
            ITypeHierarchy hierarchy = JavaOutlineInformationControl.this.getSuperTypeHierarchy(declaringType);
            if (hierarchy == null) {
                return declaringType;
            }
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            IMethod method = (IMethod)element;
            IMethod res = tester.findDeclaringMethod(method, true);
            if (res == null || method.equals(res)) {
                return declaringType;
            }
            return res.getDeclaringType();
        }

        public Image getImage(Object element) {
            if (element.equals(JavaOutlineInformationControl.this.fInitiallySelectedType) || element instanceof IMember && ((IMember)element).getDeclaringType() == null) {
                ImageDescriptor desc = this.fImageLabelProvider.getJavaImageDescriptor((IJavaElement)element, this.evaluateImageFlags(element));
                Image image = JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new FocusDescriptor(desc));
                return this.decorateImage(image, element);
            }
            return super.getImage(element);
        }
    }

    private class OutlineSorter
    extends AbstractHierarchyViewerSorter {
        private OutlineSorter() {
        }

        protected ITypeHierarchy getHierarchy(IType type) {
            return JavaOutlineInformationControl.this.getSuperTypeHierarchy(type);
        }

        public boolean isSortByDefiningType() {
            return JavaOutlineInformationControl.this.fSortByDefiningTypeAction.isChecked();
        }

        public boolean isSortAlphabetically() {
            return JavaOutlineInformationControl.this.fLexicalSortingAction.isChecked();
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
            this.fIsFiltering = false;
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    result = filters[i].filter((Viewer)this, parent, result);
                    ++i;
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IJavaElement je;
            TreeItem treeItem;
            if (!this.fIsFiltering && node instanceof TreeItem && JavaOutlineInformationControl.this.getMatcher() == null && (treeItem = (TreeItem)node).getParentItem() != null && treeItem.getData() instanceof IJavaElement && ((je = (IJavaElement)treeItem.getData()).getElementType() == 12 || this.isInnerType(je))) {
                this.setExpanded((Item)treeItem, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        private boolean isInnerType(IJavaElement element) {
            block3: {
                if (element != null && element.getElementType() == 7) {
                    IType type = (IType)element;
                    try {
                        return type.isMember();
                    }
                    catch (JavaModelException javaModelException) {
                        IJavaElement parent = type.getParent();
                        if (parent == null) break block3;
                        int parentElementType = parent.getElementType();
                        return parentElementType != 5 && parentElementType != 6;
                    }
                }
            }
            return false;
        }
    }

    private class ShowOnlyMainTypeAction
    extends Action {
        private static final String STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED = "GoIntoTopLevelTypeAction.isChecked";
        private TreeViewer fOutlineViewer;

        private ShowOnlyMainTypeAction(TreeViewer outlineViewer) {
            super(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_label, 2);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_tooltip);
            this.setDescription(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_description);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.gif");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.go_into_top_level_type_action");
            this.fOutlineViewer = outlineViewer;
            boolean showclass = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED);
            this.setTopLevelTypeOnly(showclass);
        }

        public void run() {
            this.setTopLevelTypeOnly(!JavaOutlineInformationControl.this.fShowOnlyMainType);
        }

        private void setTopLevelTypeOnly(boolean show) {
            Object selectedElement;
            JavaOutlineInformationControl.this.fShowOnlyMainType = show;
            this.setChecked(show);
            Tree tree = this.fOutlineViewer.getTree();
            tree.setRedraw(false);
            this.fOutlineViewer.refresh(false);
            if (!JavaOutlineInformationControl.this.fShowOnlyMainType) {
                this.fOutlineViewer.expandToLevel(2);
            }
            if ((selectedElement = JavaOutlineInformationControl.this.getSelectedElement()) != null) {
                this.fOutlineViewer.reveal(selectedElement);
            }
            tree.setRedraw(true);
            JavaOutlineInformationControl.this.getDialogSettings().put(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED, show);
        }
    }

    private class SortByDefiningTypeAction
    extends Action {
        private static final String STORE_SORT_BY_DEFINING_TYPE_CHECKED = "SortByDefiningType.isChecked";
        private TreeViewer fOutlineViewer;

        private SortByDefiningTypeAction(TreeViewer outlineViewer) {
            super(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_label);
            this.setDescription(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_description);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_tooltip);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "definingtype_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.sort_by_defining_type_action");
            boolean state = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_SORT_BY_DEFINING_TYPE_CHECKED);
            this.setChecked(state);
            JavaOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(state);
        }

        public void run() {
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    JavaOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(SortByDefiningTypeAction.this.isChecked());
                    JavaOutlineInformationControl.this.getDialogSettings().put(SortByDefiningTypeAction.STORE_SORT_BY_DEFINING_TYPE_CHECKED, SortByDefiningTypeAction.this.isChecked());
                    JavaOutlineInformationControl.this.setMatcherString(JavaOutlineInformationControl.this.fPattern, false);
                    SortByDefiningTypeAction.this.fOutlineViewer.refresh(true);
                    Object selectedElement = JavaOutlineInformationControl.this.getSelectedElement();
                    if (selectedElement != null) {
                        SortByDefiningTypeAction.this.fOutlineViewer.reveal(selectedElement);
                    }
                }
            });
        }
    }
}

