/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaProjectConfigurator
extends AbstractProjectConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AbstractJavaProjectConfigurator.class);
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_TESTCOMPILE = "testCompile";
    public static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final List<String> SOURCES = Arrays.asList("1.1,1.2,1.3,1.4,1.5,1.6,1.7".split(","));
    protected static final List<String> TARGETS = Arrays.asList("1.1,1.2,1.3,1.4,jsr14,1.5,1.6,1.7".split(","));
    private static final String GOAL_RESOURCES = "resources";
    private static final String GOAL_TESTRESOURCES = "testResources";
    private static final String RESOURCES_PLUGIN_ARTIFACT_ID = "maven-resources-plugin";
    private static final String RESOURCES_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final LinkedHashMap<String, String> ENVIRONMENTS = new LinkedHashMap();
    protected static final String DEFAULT_COMPILER_LEVEL = "1.4";

    static {
        ENVIRONMENTS.put("1.1", "JRE-1.1");
        ENVIRONMENTS.put("1.2", "J2SE-1.2");
        ENVIRONMENTS.put("1.3", "J2SE-1.3");
        ENVIRONMENTS.put(DEFAULT_COMPILER_LEVEL, "J2SE-1.4");
        ENVIRONMENTS.put("1.5", "J2SE-1.5");
        ENVIRONMENTS.put("jsr14", "J2SE-1.5");
        ENVIRONMENTS.put("1.6", "JavaSE-1.6");
        ENVIRONMENTS.put("1.7", "JavaSE-1.7");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.getProject();
        monitor.setTaskName(String.valueOf(Messages.AbstractJavaProjectConfigurator_task_name) + project.getName());
        this.addJavaNature(project, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashMap<String, String> options = new HashMap<String, String>();
        this.addJavaProjectOptions(options, request, monitor);
        ClasspathDescriptor classpath = new ClasspathDescriptor(javaProject);
        this.addProjectSourceFolders(classpath, request, monitor);
        String environmentId = this.getExecutionEnvironmentId(options);
        this.addJREClasspathContainer(classpath, environmentId);
        this.addMavenClasspathContainer(classpath);
        this.addCustomClasspathEntries(javaProject, classpath);
        this.invokeJavaProjectConfigurators(classpath, request, monitor);
        for (Map.Entry option : options.entrySet()) {
            javaProject.setOption((String)option.getKey(), (String)option.getValue());
        }
        MavenProject mavenProject = request.getMavenProject();
        IFolder classesFolder = this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        MavenJdtPlugin.getDefault().getBuildpathManager().updateClasspath(project, monitor);
    }

    protected String getExecutionEnvironmentId(Map<String, String> options) {
        return ENVIRONMENTS.get(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
    }

    protected void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AbstractJavaProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
    }

    protected void addCustomClasspathEntries(IJavaProject javaProject, IClasspathDescriptor classpath) throws JavaModelException {
        IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
        if (cpEntries != null && cpEntries.length > 0) {
            IClasspathEntry[] iClasspathEntryArray = cpEntries;
            int n = cpEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (5 == entry.getEntryKind() && !JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0)) && !MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                    classpath.addEntry(entry);
                }
                ++n2;
            }
        }
    }

    protected void invokeJavaProjectConfigurators(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.getMavenProjectFacade();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(facade);
        if (lifecycleMapping == null) {
            return;
        }
        for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
            if (!(configurator instanceof IJavaProjectConfigurator)) continue;
            ((IJavaProjectConfigurator)configurator).configureRawClasspath(request, classpath, monitor);
        }
    }

    protected void addJREClasspathContainer(IClasspathDescriptor classpath, String environmentId) {
        IClasspathEntry cpe;
        classpath.removeEntry(new IClasspathDescriptor.EntryFilter(){

            public boolean accept(IClasspathEntryDescriptor descriptor) {
                return JavaRuntime.JRE_CONTAINER.equals(descriptor.getPath().segment(0));
            }
        });
        IExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(environmentId);
        if (executionEnvironment == null) {
            cpe = JavaRuntime.getDefaultJREContainerEntry();
        } else {
            IPath containerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
            cpe = JavaCore.newContainerEntry((IPath)containerPath);
        }
        classpath.addEntry(cpe);
    }

    private IExecutionEnvironment getExecutionEnvironment(String environmentId) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = manager.getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            if (environment.getId().equals(environmentId)) {
                return environment;
            }
            ++n2;
        }
        return null;
    }

    protected void addMavenClasspathContainer(IClasspathDescriptor classpath) {
        classpath.removeEntry(new IClasspathDescriptor.EntryFilter(){

            public boolean accept(IClasspathEntryDescriptor entry) {
                return MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath());
            }
        });
        IClasspathEntry cpe = MavenClasspathHelpers.getDefaultContainerEntry();
        classpath.addEntry(cpe);
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            IProject project = request.getProject();
            MavenProject mavenProject = request.getMavenProject();
            IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
            IFolder classes = this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
            IFolder testClasses = this.getFolder(project, mavenProject.getBuild().getTestOutputDirectory());
            M2EUtils.createFolder((IFolder)classes, (boolean)true, (IProgressMonitor)mon.newChild(1));
            M2EUtils.createFolder((IFolder)testClasses, (boolean)true, (IProgressMonitor)mon.newChild(1));
            IPath[] inclusion = new IPath[]{};
            IPath[] exclusion = new IPath[]{};
            IPath[] inclusionTest = new IPath[]{};
            IPath[] exclusionTest = new IPath[]{};
            String mainSourceEncoding = null;
            String testSourceEncoding = null;
            String mainResourcesEncoding = null;
            String testResourcesEncoding = null;
            MavenSession mavenSession = request.getMavenSession();
            for (MojoExecution compile : projectFacade.getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_COMPILE})) {
                mainSourceEncoding = (String)this.maven.getMojoParameterValue(mavenSession, compile, "encoding", String.class);
                try {
                    inclusion = this.toPaths((String[])this.maven.getMojoParameterValue(request.getMavenSession(), compile, "includes", String[].class));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusion = this.toPaths((String[])this.maven.getMojoParameterValue(request.getMavenSession(), compile, "excludes", String[].class));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution compile : projectFacade.getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_TESTCOMPILE})) {
                testSourceEncoding = (String)this.maven.getMojoParameterValue(mavenSession, compile, "encoding", String.class);
                try {
                    inclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(request.getMavenSession(), compile, "testIncludes", String[].class));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(request.getMavenSession(), compile, "testExcludes", String[].class));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_RESOURCES})) {
                mainResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenSession, resources, "encoding", String.class);
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_TESTRESOURCES})) {
                testResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenSession, resources, "encoding", String.class);
            }
            this.addSourceDirs(classpath, project, mavenProject.getCompileSourceRoots(), classes.getFullPath(), inclusion, exclusion, mainSourceEncoding, (IProgressMonitor)mon.newChild(1));
            this.addResourceDirs(classpath, project, mavenProject.getBuild().getResources(), classes.getFullPath(), mainResourcesEncoding, (IProgressMonitor)mon.newChild(1));
            this.addSourceDirs(classpath, project, mavenProject.getTestCompileSourceRoots(), testClasses.getFullPath(), inclusionTest, exclusionTest, testSourceEncoding, (IProgressMonitor)mon.newChild(1));
            this.addResourceDirs(classpath, project, mavenProject.getBuild().getTestResources(), testClasses.getFullPath(), testResourcesEncoding, (IProgressMonitor)mon.newChild(1));
        }
        finally {
            mon.done();
        }
    }

    private IPath[] toPaths(String[] values) {
        if (values == null) {
            return new IPath[0];
        }
        IPath[] paths = new IPath[values.length];
        int i = 0;
        while (i < values.length) {
            paths[i] = new Path(values[i]);
            ++i;
        }
        return paths;
    }

    private void addSourceDirs(IClasspathDescriptor classpath, IProject project, List<String> sourceRoots, IPath outputPath, IPath[] inclusion, IPath[] exclusion, String sourceEncoding, IProgressMonitor monitor) throws CoreException {
        for (String sourceRoot : sourceRoots) {
            IFolder sourceFolder = this.getFolder(project, sourceRoot);
            if (sourceFolder != null && sourceFolder.exists() && sourceFolder.getProject().equals((Object)project)) {
                IClasspathEntryDescriptor cped = this.getEnclosingEntryDescriptor(classpath, sourceFolder.getFullPath());
                if (cped == null) {
                    log.info("Adding source folder " + sourceFolder.getFullPath());
                    classpath.addSourceEntry(sourceFolder.getFullPath(), outputPath, inclusion, exclusion, false);
                } else {
                    log.info("Not adding source folder " + sourceFolder.getFullPath() + " because it overlaps with " + cped.getPath());
                }
                if (sourceEncoding == null) continue;
                sourceFolder.setDefaultCharset(sourceEncoding, monitor);
                continue;
            }
            if (sourceFolder == null) continue;
            classpath.removeEntry(sourceFolder.getFullPath());
        }
    }

    private IClasspathEntryDescriptor getEnclosingEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().isPrefixOf(fullPath)) continue;
            return cped;
        }
        return null;
    }

    private void addResourceDirs(IClasspathDescriptor classpath, IProject project, List<Resource> resources, IPath outputPath, String resourceEncoding, IProgressMonitor monitor) throws CoreException {
        for (Resource resource : resources) {
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists() || !resourceDirectory.isDirectory()) continue;
            IPath relativePath = this.getProjectRelativePath(project, resource.getDirectory());
            IResource r = project.findMember(relativePath);
            if (r == project) {
                log.error("Skipping resource folder " + r.getFullPath());
                continue;
            }
            if (r != null && r.getProject().equals((Object)project)) {
                IClasspathEntryDescriptor cped = this.getEnclosingEntryDescriptor(classpath, r.getFullPath());
                if (cped == null) {
                    log.info("Adding resource folder " + r.getFullPath());
                    classpath.addSourceEntry(r.getFullPath(), outputPath, new IPath[0], new IPath[]{new Path("**")}, false);
                } else {
                    log.info("Resources folder " + r.getFullPath() + " overlaps with sources folder " + cped.getPath());
                    cped.addInclusionPattern((IPath)new Path("**/*.java"));
                }
                IFolder resourceFolder = project.getFolder(relativePath);
                resourceFolder.setDefaultCharset(resourceEncoding, monitor);
                continue;
            }
            log.info("Not adding resources folder " + resourceDirectory.getAbsolutePath());
        }
    }

    protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenSession mavenSession = request.getMavenSession();
        String source = null;
        String target = null;
        for (MojoExecution execution : request.getMavenProjectFacade().getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE})) {
            source = this.getCompilerLevel(mavenSession, execution, "source", source, SOURCES);
            target = this.getCompilerLevel(mavenSession, execution, "target", target, TARGETS);
        }
        if (source == null) {
            source = DEFAULT_COMPILER_LEVEL;
            log.warn("Could not determine source level, using default " + source);
        }
        if (target == null) {
            target = DEFAULT_COMPILER_LEVEL;
            log.warn("Could not determine target level, using default " + target);
        }
        options.put("org.eclipse.jdt.core.compiler.source", source);
        options.put("org.eclipse.jdt.core.compiler.compliance", source);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
    }

    private String getCompilerLevel(MavenSession session, MojoExecution execution, String parameter, String source, List<String> levels) {
        int levelIdx = this.getLevelIndex(source, levels);
        try {
            source = (String)this.maven.getMojoParameterValue(session, execution, parameter, String.class);
        }
        catch (CoreException ex) {
            log.error("Failed to determine compiler " + parameter + " setting, assuming default", (Throwable)ex);
        }
        int newLevelIdx = this.getLevelIndex(source, levels);
        if (newLevelIdx > levelIdx) {
            levelIdx = newLevelIdx;
        }
        if (levelIdx < 0) {
            return DEFAULT_COMPILER_LEVEL;
        }
        return levels.get(levelIdx);
    }

    private int getLevelIndex(String level, List<String> levels) {
        return level != null ? levels.indexOf(level) : -1;
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.unconfigure(request, monitor);
        this.removeMavenClasspathContainer(request.getProject());
    }

    private void removeMavenClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    protected IFolder getFolder(IProject project, String absolutePath) {
        return project.getFolder(this.getProjectRelativePath(project, absolutePath));
    }

    protected IPath getProjectRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return new Path(relative.replace('\\', '/'));
    }
}

