/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.repositories.RepositoryCategory;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryAdapter;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;

public class TaskRepositoriesNavigatorContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final TaskRepositoryManager manager = (TaskRepositoryManager)TasksUi.getRepositoryManager();
    private Viewer viewer;
    private Listener listener;

    public void dispose() {
        if (this.listener != null) {
            this.manager.removeListener((IRepositoryListener)this.listener);
            this.listener = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof RepositoryCategory) {
            List repositories = TasksUi.getRepositoryManager().getAllRepositories();
            RepositoryCategory category = (RepositoryCategory)parentElement;
            if ("org.eclipse.mylyn.category.all".equals(category.getId())) {
                return repositories.toArray();
            }
            if ("org.eclipse.mylyn.category.other".equals(category.getId())) {
                HashSet<TaskRepository> items = new HashSet<TaskRepository>();
                for (TaskRepository repository : repositories) {
                    if (repository.getProperty("category") != null) continue;
                    items.add(repository);
                }
                return items.toArray();
            }
            HashSet<TaskRepository> items = new HashSet<TaskRepository>();
            for (TaskRepository repository : repositories) {
                if (!category.getId().equals(repository.getProperty("category"))) continue;
                items.add(repository);
            }
            return items.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.listener != null) {
            this.manager.removeListener((IRepositoryListener)this.listener);
            this.listener = null;
        }
        this.viewer = viewer;
        if (newInput != null) {
            this.listener = new Listener();
            this.manager.addListener((IRepositoryListener)this.listener);
        }
    }

    private class Listener
    extends TaskRepositoryAdapter
    implements IRepositoryChangeListener {
        private Listener() {
        }

        public void repositoryAdded(TaskRepository repository) {
            this.refresh(repository);
        }

        protected void refresh(TaskRepository repository) {
            if (TaskRepositoriesNavigatorContentProvider.this.viewer != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (TaskRepositoriesNavigatorContentProvider.this.viewer != null && TaskRepositoriesNavigatorContentProvider.this.viewer.getControl() != null && !TaskRepositoriesNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                            TaskRepositoriesNavigatorContentProvider.this.viewer.refresh();
                        }
                    }
                });
            }
        }

        public void repositoryRemoved(TaskRepository repository) {
            this.refresh(repository);
        }

        public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
            this.refresh(repository);
        }

        public void repositoryChanged(TaskRepositoryChangeEvent event) {
            TaskRepositoryDelta.Type type = event.getDelta().getType();
            if (type == TaskRepositoryDelta.Type.ALL || type == TaskRepositoryDelta.Type.PROPERTY || type == TaskRepositoryDelta.Type.OFFLINE) {
                this.refresh(event.getRepository());
            }
        }
    }
}

