/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui.wizard;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.ui.Messages;
import org.eclipse.wb.internal.discovery.ui.WBDiscoveryUiPlugin;
import org.eclipse.wb.internal.discovery.ui.util.BrowserHelper;
import org.eclipse.wb.internal.discovery.ui.wizard.WizardToolkitUtils;

class InstallToolkitWizardPage
extends WizardPage {
    private WBToolkit toolkit;

    protected InstallToolkitWizardPage(WBToolkit toolkit) {
        super(Messages.InstallToolkitWizardPage_name);
        this.toolkit = toolkit;
        this.setTitle(MessageFormat.format(Messages.InstallToolkitWizardPage_title, toolkit.getName()));
        this.setMessage(WizardToolkitUtils.getDescription(toolkit));
        this.setImageDescriptor(WBDiscoveryUiPlugin.getBundledImageDescriptor("icons/new_wiz.png"));
    }

    public void createControl(Composite parent) {
        ImageDescriptor imageDescriptor;
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).extendedMargins(0, 0, 30, 0).applyTo(composite);
        Label iconLabel = new Label(composite, 0);
        GridDataFactory.swtDefaults().span(1, 4).align(0x1000000, 1).applyTo((Control)iconLabel);
        if (this.toolkit.getIconURL() != null && (imageDescriptor = ImageDescriptor.createFromURL((URL)this.toolkit.getIconURL())) != null) {
            iconLabel.setImage(WBDiscoveryUiPlugin.getImage(imageDescriptor));
        }
        Label summaryLabel = new Label(composite, 64);
        String description = this.toolkit.getDescription();
        description = description.replaceAll("(\\r\\n)|\\n|\\r", " ");
        summaryLabel.setText(description);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)summaryLabel);
        if (this.toolkit.getMoreInfoURL() != null) {
            Link moreInfoLink = new Link(composite, 0);
            moreInfoLink.setText(Messages.InstallToolkitWizardPage_moreInfoLink);
            moreInfoLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserHelper.openUrl(InstallToolkitWizardPage.this.getShell(), InstallToolkitWizardPage.this.toolkit.getMoreInfoURL());
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)moreInfoLink);
        } else {
            new Label(composite, 0);
        }
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 20).applyTo((Control)separator);
        Label label = new Label(composite, 0x1000000);
        label.setText(Messages.InstallToolkitWizardPage_finishLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)label);
        this.setControl((Control)composite);
    }
}

