/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;

public class GetTaskHistoryJob
extends TaskJob {
    private final TaskRepository repository;
    private final ITask task;
    private final AbstractRepositoryConnector connector;
    private IStatus errorStatus;
    private TaskHistory history;

    public GetTaskHistoryJob(AbstractRepositoryConnector connector, TaskRepository repository, ITask task) {
        super("Retrieving History");
        this.connector = connector;
        this.repository = repository;
        this.task = task;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor jobMonitor) {
        try {
            block12: {
                this.monitor.setCanceled(false);
                this.monitor.attach(jobMonitor);
                try {
                    this.history = this.connector.getTaskHistory(this.repository, this.task, (IProgressMonitor)this.monitor);
                }
                catch (CoreException e) {
                    this.errorStatus = e.getStatus();
                    this.monitor.done();
                    break block12;
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.errorStatus = Status.CANCEL_STATUS;
                    break block12;
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error while retrieving task history", (Throwable)e));
                    this.errorStatus = new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error: " + e.getMessage(), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    this.monitor.done();
                    break block12;
                }
                {
                    finally {
                        this.monitor.done();
                    }
                }
                this.monitor.done();
            }
            IStatus iStatus = this.errorStatus == Status.CANCEL_STATUS ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.monitor.detach(jobMonitor);
        }
    }

    public TaskHistory getHistory() {
        return this.history;
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public ITask getTask() {
        return this.task;
    }
}

