/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.lifecycle;

import java.lang.reflect.InvocationTargetException;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.components.PomHierarchyComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LifecycleMappingDialog
extends Dialog
implements ISelectionChangedListener {
    private PomHierarchyComposite pomComposite;
    private CLabel status;
    private IFile pomFile;
    private IMavenProjectFacade facade;
    private String pluginGroupId;
    private String pluginArtifactId;
    private String pluginVersion;
    private String goal;
    private MavenProject pluginProject;

    public LifecycleMappingDialog(Shell parentShell, IFile pom, String pluginGroupId, String pluginArtifactId, String pluginVersion, String goal) {
        super(parentShell);
        this.facade = MavenPlugin.getMavenProjectRegistry().create(pom, true, (IProgressMonitor)new NullProgressMonitor());
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.pluginVersion = pluginVersion;
        this.goal = goal;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)"Ignore {0}", (Object)this.goal));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText("Select location to place ignore");
        this.pomComposite = new PomHierarchyComposite(container, 2048);
        this.pomComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pomComposite.addSelectionChangedListener((ISelectionChangedListener)this);
        this.pomComposite.computeHeirarchy(this.facade, new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        });
        this.status = new CLabel(container, 64);
        this.status.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.pluginProject = this.locatePlugin();
        this.pomComposite.setSelection((ISelection)new StructuredSelection((Object)this.pluginProject));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        MavenProject project = this.pomComposite.fromSelection();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(project != null && project.getFile() != null);
        }
        this.updateStatus(project);
    }

    private void updateStatus(MavenProject project) {
        if (project.getFile() == null) {
            this.status.setText("Non-workspace pom");
            this.status.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else if (project.equals((Object)this.pluginProject)) {
            this.status.setText("Plugin definition in selected pom.");
            this.status.setImage(null);
        } else {
            this.status.setText("");
            this.status.setImage(null);
        }
    }

    protected void okPressed() {
        this.pomFile = M2EUtils.getPomFile((MavenProject)this.pomComposite.fromSelection());
        super.okPressed();
    }

    public IFile getPomFile() {
        return this.pomFile;
    }

    private MavenProject locatePlugin() {
        for (MavenProject project : this.pomComposite.getHierarchy()) {
            if (project.getOriginalModel().getBuild() == null) continue;
            for (Plugin plugin : project.getOriginalModel().getBuild().getPlugins()) {
                if (!plugin.getGroupId().equals(this.pluginGroupId) || !plugin.getArtifactId().equals(this.pluginArtifactId) || plugin.getVersion() != null && !this.pluginVersion.equals(plugin.getVersion())) continue;
                return project;
            }
        }
        return null;
    }
}

