/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.editor.xml.InsertArtifactProposal;
import org.eclipse.m2e.editor.xml.InsertExpressionProposal;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.m2e.editor.xml.PomTemplateContext;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PomContentAssistProcessor
extends XMLContentAssistProcessor {
    private static final ProposalComparator PROPOSAL_COMPARATOR = new ProposalComparator();
    private ISourceViewer sourceViewer;
    private static List<PomTemplateContext> expressionproposalContexts = Arrays.asList(PomTemplateContext.ARTIFACT_ID, PomTemplateContext.CLASSIFIER, PomTemplateContext.GOAL, PomTemplateContext.GROUP_ID, PomTemplateContext.MODULE, PomTemplateContext.PACKAGING, PomTemplateContext.PHASE, PomTemplateContext.PROPERTIES, PomTemplateContext.SCOPE, PomTemplateContext.SYSTEM_PATH, PomTemplateContext.TYPE, PomTemplateContext.UNKNOWN);

    public PomContentAssistProcessor(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        String currentNodeName = this.getCurrentNode(contentAssistRequest).getNodeName();
        PomTemplateContext context = PomTemplateContext.fromNodeName(currentNodeName);
        if (PomTemplateContext.CONFIGURATION == context) {
            contentAssistRequest.setReplacementBeginPosition(contentAssistRequest.getReplacementBeginPosition() - 1);
            contentAssistRequest.setReplacementLength(contentAssistRequest.getReplacementLength() + 1);
            this.addProposals(contentAssistRequest, context, this.getCurrentNode(contentAssistRequest), contentAssistRequest.getMatchString());
        }
        if (PomTemplateContext.UNKNOWN == context && PomTemplateContext.CONFIGURATION == (context = PomTemplateContext.fromNodeName(this.getCurrentNode(contentAssistRequest).getParentNode().getNodeName()))) {
            this.addProposals(contentAssistRequest, context, this.getCurrentNode(contentAssistRequest).getParentNode(), contentAssistRequest.getMatchString());
        }
        super.addTagNameProposals(contentAssistRequest, childPosition);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        String currentNodeName = this.getCurrentNode(contentAssistRequest).getNodeName();
        this.addProposals(contentAssistRequest, PomTemplateContext.fromNodeName(currentNodeName));
        super.addTagInsertionProposals(contentAssistRequest, childPosition);
    }

    private Node getCurrentNode(ContentAssistRequest contentAssistRequest) {
        Node currentNode = contentAssistRequest.getNode();
        if (currentNode instanceof Text) {
            currentNode = currentNode.getParentNode();
        }
        return currentNode;
    }

    private void addProposals(ContentAssistRequest request, PomTemplateContext context) {
        ITextSelection selection = (ITextSelection)this.sourceViewer.getSelectionProvider().getSelection();
        int offset = request.getReplacementBeginPosition();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        String prefix = PomContentAssistProcessor.extractPrefix((ITextViewer)this.sourceViewer, offset);
        this.addExpressionProposal(request, context, this.getCurrentNode(request), prefix);
        this.addGenerateProposals(request, context, this.getCurrentNode(request), prefix);
        this.addProposals(request, context, this.getCurrentNode(request), prefix);
    }

    private void addExpressionProposal(ContentAssistRequest request, PomTemplateContext context, Node currentNode, String prefix) {
        int exprStart = prefix.lastIndexOf("${");
        if (exprStart != -1) {
            String realExpressionPrefix = prefix.substring(exprStart);
            if (realExpressionPrefix.contains("}")) {
                return;
            }
            if (expressionproposalContexts.contains((Object)context)) {
                Properties props;
                MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)this.sourceViewer);
                Region region = new Region(request.getReplacementBeginPosition() - realExpressionPrefix.length(), realExpressionPrefix.length());
                TreeSet<String> collect = new TreeSet<String>();
                if (prj != null && (props = prj.getProperties()) != null) {
                    for (Object key : props.keySet()) {
                        String keyString = key.toString();
                        if (!("${" + keyString).startsWith(realExpressionPrefix)) continue;
                        collect.add(keyString);
                    }
                }
                if ("${basedir}".startsWith(realExpressionPrefix)) {
                    collect.add("basedir");
                }
                if ("${project.version}".startsWith(realExpressionPrefix)) {
                    collect.add("project.version");
                }
                if ("${project.groupId}".startsWith(realExpressionPrefix)) {
                    collect.add("project.groupId");
                }
                if ("${project.artifactId}".startsWith(realExpressionPrefix)) {
                    collect.add("project.artifactId");
                }
                if ("${project.build.directory}".startsWith(realExpressionPrefix)) {
                    collect.add("project.build.directory");
                }
                for (String key : collect) {
                    InsertExpressionProposal proposal = new InsertExpressionProposal(region, key, prj);
                    if (request.shouldSeparate()) {
                        request.addMacro((ICompletionProposal)proposal);
                        continue;
                    }
                    request.addProposal((ICompletionProposal)proposal);
                }
            }
        }
    }

    private void addGenerateProposals(ContentAssistRequest request, PomTemplateContext context, Node node, String prefix) {
        Element parent;
        Node project;
        InsertArtifactProposal proposal;
        InsertArtifactProposal.Configuration config;
        Region region;
        CompletionProposal proposal2;
        Region region2;
        String relative;
        Element parent2;
        Element relPath;
        if (prefix.trim().length() != 0) {
            return;
        }
        if (context == PomTemplateContext.PARENT && node.getNodeName().equals("parent") && (relPath = XmlUtils.findChild(parent2 = (Element)node, "relativePath")) == null && (relative = PomContentAssistProcessor.findRelativePath(this.sourceViewer, parent2)) != null) {
            region2 = new Region(request.getReplacementBeginPosition(), 0);
            proposal2 = new CompletionProposal("<relativePath>" + relative + "</relativePath>", region2.getOffset(), region2.getLength(), 0, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"), NLS.bind((String)Messages.PomContentAssistProcessor_insert_relPath_title, (Object)relative), null, null);
            if (request.shouldSeparate()) {
                request.addMacro((ICompletionProposal)proposal2);
            } else {
                request.addProposal((ICompletionProposal)proposal2);
            }
        }
        if (context == PomTemplateContext.RELATIVE_PATH && (parent2 = (Element)node.getParentNode()) != null && "parent".equals(parent2.getNodeName())) {
            String relative2 = PomContentAssistProcessor.findRelativePath(this.sourceViewer, parent2);
            String textContent = XmlUtils.getTextValue(node);
            if (relative2 != null && !relative2.equals(textContent)) {
                region2 = new Region(request.getReplacementBeginPosition() - prefix.length(), prefix.length());
                if (request.getNode() instanceof IndexedRegion && request.getNode() instanceof Text) {
                    IndexedRegion index = (IndexedRegion)request.getNode();
                    region2 = new Region(index.getStartOffset(), index.getEndOffset() - index.getStartOffset());
                }
                proposal2 = new CompletionProposal(relative2, region2.getOffset(), region2.getLength(), 0, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"), NLS.bind((String)Messages.PomContentAssistProcessor_set_relPath_title, (Object)relative2), null, null);
                if (request.shouldSeparate()) {
                    request.addMacro((ICompletionProposal)proposal2);
                } else {
                    request.addProposal((ICompletionProposal)proposal2);
                }
            }
        }
        if (context == PomTemplateContext.DEPENDENCIES || context == PomTemplateContext.PROFILE || context == PomTemplateContext.DEPENDENCY_MANAGEMENT || context == PomTemplateContext.PROJECT) {
            region = new Region(request.getReplacementBeginPosition(), 0);
            config = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.DEPENDENCY);
            config.setCurrentNode(node);
            proposal = new InsertArtifactProposal(this.sourceViewer, region, config);
            if (request.shouldSeparate()) {
                request.addMacro((ICompletionProposal)proposal);
            } else {
                request.addProposal((ICompletionProposal)proposal);
            }
        }
        if (context == PomTemplateContext.PLUGINS || context == PomTemplateContext.BUILD || context == PomTemplateContext.PLUGIN_MANAGEMENT || context == PomTemplateContext.PROJECT) {
            region = new Region(request.getReplacementBeginPosition(), 0);
            config = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.PLUGIN);
            config.setCurrentNode(node);
            proposal = new InsertArtifactProposal(this.sourceViewer, region, config);
            if (request.shouldSeparate()) {
                request.addMacro((ICompletionProposal)proposal);
            } else {
                request.addProposal((ICompletionProposal)proposal);
            }
        }
        if (context == PomTemplateContext.PROJECT && (project = node) != null && project instanceof Element && (parent = XmlUtils.findChild((Element)project, "parent")) == null) {
            Region region3 = new Region(request.getReplacementBeginPosition(), 0);
            Element groupId = XmlUtils.findChild((Element)project, "groupId");
            String groupString = null;
            if (groupId != null) {
                groupString = XmlUtils.getTextValue(groupId);
            }
            InsertArtifactProposal.Configuration config2 = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.PARENT);
            config2.setInitiaSearchString(groupString);
            InsertArtifactProposal proposal3 = new InsertArtifactProposal(this.sourceViewer, region3, config2);
            if (request.shouldSeparate()) {
                request.addMacro((ICompletionProposal)proposal3);
            } else {
                request.addProposal((ICompletionProposal)proposal3);
            }
        }
    }

    private static String findRelativePath(ISourceViewer viewer, Element parent) {
        String groupId = XmlUtils.getTextValue(XmlUtils.findChild(parent, "groupId"));
        String artifactId = XmlUtils.getTextValue(XmlUtils.findChild(parent, "artifactId"));
        String version = XmlUtils.getTextValue(XmlUtils.findChild(parent, "version"));
        return PomContentAssistProcessor.findRelativePath(viewer, groupId, artifactId, version);
    }

    public static String findRelativePath(ISourceViewer viewer, String groupId, String artifactId, String version) {
        IMavenProjectFacade facade;
        if (groupId != null && artifactId != null && version != null && (facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(groupId, artifactId, version)) != null) {
            IPath path2;
            IPath relative;
            IFile parentPomFile = facade.getPom();
            IPath path = parentPomFile.getLocation();
            IProject prj = XmlUtils.extractProject((ITextViewer)viewer);
            if (prj != null && path != null && (relative = path.makeRelativeTo(path2 = prj.getLocation())) != path) {
                return relative.toString();
            }
        }
        return null;
    }

    private void addProposals(ContentAssistRequest request, PomTemplateContext context, Node currentNode, String prefix) {
        if (request != null) {
            ICompletionProposal[] templateProposals;
            MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)this.sourceViewer);
            IProject eclipseprj = XmlUtils.extractProject((ITextViewer)this.sourceViewer);
            ICompletionProposal[] iCompletionProposalArray = templateProposals = this.getTemplateProposals(prj, eclipseprj, (ITextViewer)this.sourceViewer, request.getReplacementBeginPosition(), context.getContextTypeId(), currentNode, prefix);
            int n = templateProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (request.shouldSeparate()) {
                    request.addMacro(proposal);
                } else {
                    request.addProposal(proposal);
                }
                ++n2;
            }
        }
    }

    private ICompletionProposal[] getTemplateProposals(MavenProject project, IProject eclipseprj, ITextViewer viewer, int offset, String contextTypeId, Node currentNode, String prefix) {
        TemplateProposal proposal;
        Template template;
        int n;
        int n2;
        Template[] templateArray;
        Template[] templates;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - prefix.length(), prefix.length())), contextTypeId)) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        PomTemplateContext templateContext = PomTemplateContext.fromId(contextTypeId);
        Object image = MvnImages.IMG_USER_TEMPLATE;
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        TemplateStore store = MvnIndexPlugin.getDefault().getTemplateStore();
        if (store != null) {
            templateArray = templates = store.getTemplates(contextTypeId);
            n2 = templates.length;
            n = 0;
            while (n < n2) {
                template = templateArray[n];
                proposal = this.createProposalForTemplate(prefix, region, context, (Image)image, template, true);
                if (proposal != null) {
                    matches.add(proposal);
                }
                ++n;
            }
        }
        image = templateContext == PomTemplateContext.CONFIGURATION ? MvnImages.IMG_PARAMETER : null;
        templateArray = templates = templateContext.getTemplates(project, eclipseprj, currentNode, prefix);
        n2 = templates.length;
        n = 0;
        while (n < n2) {
            template = templateArray[n];
            proposal = this.createProposalForTemplate(prefix, region, context, (Image)image, template, false);
            if (proposal != null) {
                matches.add(proposal);
            }
            ++n;
        }
        if (templateContext != PomTemplateContext.VERSION) {
            Collections.sort(matches, PROPOSAL_COMPARATOR);
        }
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    private TemplateProposal createProposalForTemplate(String prefix, Region region, TemplateContext context, Image image, final Template template, boolean isUserTemplate) {
        try {
            context.getContextType().validate(template.getPattern());
            if (template.matches(prefix, context.getContextType().getId())) {
                if (isUserTemplate) {
                    return new TemplateProposal(template, context, (IRegion)region, image, this.getRelevance(template, prefix)){

                        public String getAdditionalProposalInfo() {
                            return StringUtils.convertToHTMLContent((String)super.getAdditionalProposalInfo());
                        }
                    };
                }
                return new TemplateProposal(template, context, (IRegion)region, image, this.getRelevance(template, prefix)){

                    public String getAdditionalProposalInfo() {
                        return this.getTemplate().getDescription();
                    }

                    public String getDisplayString() {
                        return template.getName();
                    }
                };
            }
        }
        catch (TemplateException templateException) {}
        return null;
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region, String contextTypeId) {
        TemplateContextType contextType = this.getContextType(viewer, region, contextTypeId);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getName().startsWith(prefix)) {
            return 90;
        }
        return 0;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region, String contextTypeId) {
        ContextTypeRegistry registry = MvnIndexPlugin.getDefault().getTemplateContextRegistry();
        if (registry != null) {
            return registry.getContextType(contextTypeId);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static final String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while ((ch = document.getChar(i - 1)) != '>' && ch != '<' && ch != ' ' && ch != '\n' && ch != '\t') {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProposalComparator
    implements Comparator<TemplateProposal> {
        ProposalComparator() {
        }

        @Override
        public int compare(TemplateProposal o1, TemplateProposal o2) {
            int res = o2.getRelevance() - o1.getRelevance();
            if (res == 0) {
                res = o1.getDisplayString().compareTo(o2.getDisplayString());
            }
            return res;
        }
    }
}

