/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;

public class RepositoryStatus
extends Status {
    public static final int ERROR_IO = 5;
    public static final int ERROR_NETWORK = 11;
    public static final int ERROR_PERMISSION_DENIED = 12;
    public static final int ERROR_REPOSITORY = 1;
    public static final int ERROR_REPOSITORY_LOGIN = 3;
    public static final int ERROR_REPOSITORY_NOT_FOUND = 4;
    public static final int OPERATION_CANCELLED = 8;
    public static final int REPOSITORY_COLLISION = 6;
    public static final int REPOSITORY_COMMENT_REQUIRED = 9;
    public static final int REPOSITORY_LOGGED_OUT = 10;
    public static final int ERROR_INTERNAL = 7;
    private String htmlMessage;
    protected String repositoryUrl;

    public RepositoryStatus(TaskRepository repository, int severity, String pluginId, int code, String message) {
        this(repository.getRepositoryUrl(), severity, pluginId, code, message, null);
    }

    public RepositoryStatus(TaskRepository repository, int severity, String pluginId, int code, String message, Throwable e) {
        this(repository.getRepositoryUrl(), severity, pluginId, code, message, e);
    }

    public RepositoryStatus(String repositoryUrl, int severity, String pluginId, int code, String message) {
        this(repositoryUrl, severity, pluginId, code, message, null);
    }

    public RepositoryStatus(String repositoryUrl, int severity, String pluginId, int code, String message, Throwable e) {
        super(severity, pluginId, code, message, e);
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("repositoryUrl must not be null");
        }
        this.repositoryUrl = repositoryUrl;
    }

    public RepositoryStatus(int severity, String pluginId, int code, String message) {
        super(severity, pluginId, code, message, null);
    }

    public RepositoryStatus(int severity, String pluginId, int code, String message, Throwable e) {
        super(severity, pluginId, code, message, e);
    }

    public String getMessage() {
        String message = super.getMessage();
        if (message != null && !"".equals(message)) {
            return message;
        }
        Throwable exception = this.getException();
        if (exception != null) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            return exception.toString();
        }
        return "";
    }

    protected void setMessage(String message) {
        super.setMessage(message != null ? message : "");
    }

    protected void setHtmlMessage(String htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public boolean isHtmlMessage() {
        return this.htmlMessage != null;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public static RepositoryStatus createInternalError(String pluginId, String message, Throwable t) {
        return new RepositoryStatus(4, pluginId, 7, message, t);
    }

    public static RepositoryStatus createHtmlStatus(int severity, String pluginId, int code, String message, String htmlMessage) {
        if (htmlMessage == null) {
            throw new IllegalArgumentException("htmlMessage must not be null");
        }
        RepositoryStatus status = new RepositoryStatus(severity, pluginId, code, message);
        status.setHtmlMessage(htmlMessage);
        return status;
    }

    public static RepositoryStatus createStatus(TaskRepository repository, int severity, String pluginId, String message) {
        return RepositoryStatus.createStatus(repository.getRepositoryUrl(), severity, pluginId, message);
    }

    public static RepositoryStatus createStatus(String repositoryUrl, int severity, String pluginId, String message) {
        return new RepositoryStatus(repositoryUrl, severity, pluginId, 1, message);
    }

    public static RepositoryStatus createLoginError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 3, NLS.bind((String)"Unable to login to {0}. Please validate credentials via Task Repositories view.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createNotFoundError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 4, NLS.bind((String)"Repository {0} could not be found.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createCollisionError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 6, NLS.bind((String)"Mid-air collision occurred while submitting to {0}.\n\nSynchronize task and re-submit changes.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createCommentRequiredError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 9, "You have to specify a new comment when making this change. Please comment on the reason for this change.");
    }

    public static RepositoryStatus createHtmlStatus(String repositoryUrl, int severity, String pluginId, int code, String message, String htmlMessage) {
        if (htmlMessage == null) {
            throw new IllegalArgumentException("htmlMessage must not be null");
        }
        RepositoryStatus status = new RepositoryStatus(repositoryUrl, severity, pluginId, code, message);
        status.setHtmlMessage(htmlMessage);
        return status;
    }
}

