/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.notifications;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.tasks.core.notifications.IServiceMessageListener;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessageEvent;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessageXmlHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessageManager {
    protected static final long START_DELAY = 30000L;
    protected static final long RECHECK_DELAY = 86400000L;
    private String serviceMessageUrl;
    private volatile List<ServiceMessage> messages = Collections.emptyList();
    private Job messageCheckJob;
    private final List<IServiceMessageListener> listeners = new CopyOnWriteArrayList<IServiceMessageListener>();
    private String lastModified;
    private String eTag;
    private boolean statusLogged;
    private final long checktime;

    public ServiceMessageManager(String serviceMessageUrl, String lastModified, String eTag, long checktime) {
        this.serviceMessageUrl = serviceMessageUrl;
        this.lastModified = lastModified;
        this.checktime = checktime;
        this.eTag = eTag;
    }

    public void start() {
        if (this.messageCheckJob == null) {
            this.messageCheckJob = new Job("Checking for new service message"){

                protected IStatus run(IProgressMonitor monitor) {
                    ServiceMessageManager.this.updateServiceMessage(monitor);
                    return Status.OK_STATUS;
                }
            };
            this.messageCheckJob.setSystem(true);
            this.messageCheckJob.setPriority(50);
            this.messageCheckJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (ServiceMessageManager.this.messageCheckJob != null) {
                        ServiceMessageManager.this.messageCheckJob.schedule(86400000L);
                    }
                }
            });
        }
        if (this.checktime == 0L) {
            this.messageCheckJob.schedule(30000L);
        } else {
            long nextCheckTime = this.checktime + 86400000L;
            long now = new Date().getTime();
            if (nextCheckTime < now) {
                this.messageCheckJob.schedule(30000L);
            } else if (nextCheckTime > now) {
                if (nextCheckTime - now < 30000L) {
                    this.messageCheckJob.schedule(30000L);
                } else {
                    this.messageCheckJob.schedule(nextCheckTime - now);
                }
            }
        }
    }

    public void stop() {
        if (this.messageCheckJob != null) {
            this.messageCheckJob.cancel();
            this.messageCheckJob = null;
        }
        final ServiceMessageEvent event = new ServiceMessageEvent(this, ServiceMessageEvent.EVENT_KIND.STOP);
        for (final IServiceMessageListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handleEvent(event);
                }

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }
            });
        }
    }

    public void setServiceMessageUrl(String url) {
        this.serviceMessageUrl = url;
    }

    public void addServiceMessageListener(IServiceMessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeServiceMessageListener(IServiceMessageListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(List<ServiceMessage> messages) {
        this.messages = messages;
        for (ServiceMessage message : messages) {
            message.setETag(this.eTag);
            message.setLastModified(this.lastModified);
        }
        final ServiceMessageEvent event = new ServiceMessageEvent(this, ServiceMessageEvent.EVENT_KIND.MESSAGE_UPDATE, messages);
        for (final IServiceMessageListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handleEvent(event);
                }

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }
            });
        }
    }

    public List<ServiceMessage> getServiceMessages() {
        return new ArrayList<ServiceMessage>(this.messages);
    }

    public int updateServiceMessage(IProgressMonitor monitor) {
        List<ServiceMessage> messages;
        int status;
        block13: {
            status = -1;
            messages = null;
            try {
                HttpClient httpClient = new HttpClient(WebUtil.getConnectionManager());
                WebUtil.configureHttpClient((HttpClient)httpClient, null);
                WebLocation location = new WebLocation(this.serviceMessageUrl);
                HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)httpClient, (AbstractWebLocation)location, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                GetMethod method = new GetMethod(this.serviceMessageUrl);
                method.setRequestHeader("If-Modified-Since", this.lastModified);
                method.setRequestHeader("If-None-Match", this.eTag);
                try {
                    status = WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                    if (status == 200 && !monitor.isCanceled()) {
                        Header eTagHeader;
                        Header lastModifiedHeader = method.getResponseHeader("Last-Modified");
                        if (lastModifiedHeader != null) {
                            this.lastModified = lastModifiedHeader.getValue();
                        }
                        if ((eTagHeader = method.getResponseHeader("ETag")) != null) {
                            this.eTag = eTagHeader.getValue();
                        }
                        InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                        try {
                            SAXParserFactory factory = SAXParserFactory.newInstance();
                            factory.setValidating(false);
                            SAXParser parser = factory.newSAXParser();
                            ServiceMessageXmlHandler handler = new ServiceMessageXmlHandler();
                            parser.parse(in, (DefaultHandler)handler);
                            messages = handler.getMessages();
                            break block13;
                        }
                        finally {
                            in.close();
                        }
                    }
                    if (status != 404 && status != 304 && !this.statusLogged) {
                        this.statusLogged = true;
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Http error retrieving service message: " + HttpStatus.getStatusText((int)status)));
                    }
                }
                finally {
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                }
            }
            catch (Exception e) {
                if (this.statusLogged) break block13;
                this.statusLogged = true;
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Http error retrieving service message.", (Throwable)e));
            }
        }
        if (messages != null && messages.size() > 0) {
            this.notifyListeners(messages);
        }
        return status;
    }
}

