/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskContainer
extends PlatformObject
implements IRepositoryElement,
ITaskContainer {
    private String handleIdentifier = "";
    private final Collection<ITask> children = new CopyOnWriteArrayList<ITask>();
    private String url;

    public AbstractTaskContainer(String handleAndDescription) {
        Assert.isNotNull((Object)handleAndDescription);
        this.handleIdentifier = handleAndDescription;
    }

    public void internalAddChild(AbstractTask task) {
        Assert.isNotNull((Object)task);
        this.children.add(task);
    }

    public boolean internalRemoveChild(ITask task) {
        return this.children.remove(task);
    }

    @Override
    public Collection<ITask> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public boolean contains(String handle) {
        Assert.isNotNull((Object)handle);
        return this.containsHelper(this.children, handle, new HashSet<IRepositoryElement>());
    }

    private boolean containsHelper(Collection<ITask> children, String handle, Set<IRepositoryElement> visitedContainers) {
        for (ITask child : children) {
            if (visitedContainers.contains(child)) continue;
            visitedContainers.add(child);
            if (!(child instanceof ITaskContainer) || !handle.equals(child.getHandleIdentifier()) && !this.containsHelper(((ITaskContainer)((Object)child)).getChildren(), handle, visitedContainers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSummary() {
        return this.handleIdentifier;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handleIdentifier) {
        this.handleIdentifier = handleIdentifier;
    }

    public int hashCode() {
        return this.handleIdentifier.hashCode();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractTaskContainer) {
            IRepositoryElement compare = (IRepositoryElement)object;
            return this.getHandleIdentifier().equals(compare.getHandleIdentifier());
        }
        return false;
    }

    public String toString() {
        return "container: " + this.handleIdentifier;
    }

    public String getPriority() {
        String highestPriority = ITask.PriorityLevel.P5.toString();
        Collection<ITask> tasks = this.getChildren();
        if (tasks.isEmpty()) {
            return ITask.PriorityLevel.P1.toString();
        }
        for (ITask task : tasks) {
            if (highestPriority.compareTo(task.getPriority()) <= 0) continue;
            highestPriority = task.getPriority();
        }
        return highestPriority;
    }

    @Override
    public int compareTo(IRepositoryElement taskListElement) {
        return this.getHandleIdentifier().compareTo(taskListElement.getHandleIdentifier());
    }

    public boolean isUserManaged() {
        return true;
    }
}

