/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class MarketplacePage
extends CatalogPage {
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogDescriptor previousCatalogDescriptor;
    private boolean updated;
    private boolean switchLinkActivated;
    private Link selectionLink;
    private TabFolder tabFolder;
    private TabItem searchTabItem;

    public MarketplacePage(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog);
        this.configuration = configuration;
        this.setDescription(Messages.MarketplacePage_selectSolutionsToInstall);
        this.setTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        if (configuration.getCatalogDescriptor() != null) {
            this.setTitle(configuration.getCatalogDescriptor().getLabel());
        }
    }

    public void createControl(Composite originalParent) {
        Composite parent = originalParent;
        boolean needSwitchMarketplaceLink = this.configuration.getCatalogDescriptors().size() > 1;
        parent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 5).applyTo(parent);
        this.tabFolder = new TabFolder(parent, 128);
        if (originalParent != parent) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        }
        this.searchTabItem = new TabItem(this.tabFolder, 0);
        this.searchTabItem.setText(Messages.MarketplacePage_search);
        final TabItem recentTabItem = new TabItem(this.tabFolder, 0);
        recentTabItem.setText(Messages.MarketplacePage_recent);
        final TabItem popularTabItem = new TabItem(this.tabFolder, 0);
        popularTabItem.setText(Messages.MarketplacePage_popular);
        final TabItem installedTabItem = new TabItem(this.tabFolder, 0);
        installedTabItem.setText(Messages.MarketplacePage_installed);
        super.createControl((Composite)this.tabFolder);
        this.searchTabItem.setControl(this.getControl());
        recentTabItem.setControl(this.getControl());
        popularTabItem.setControl(this.getControl());
        installedTabItem.setControl(this.getControl());
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceViewer.ContentType contentType;
                if (e.item == MarketplacePage.this.searchTabItem) {
                    contentType = MarketplaceViewer.ContentType.SEARCH;
                } else if (e.item == recentTabItem) {
                    contentType = MarketplaceViewer.ContentType.RECENT;
                } else if (e.item == popularTabItem) {
                    contentType = MarketplaceViewer.ContentType.POPULAR;
                } else if (e.item == installedTabItem) {
                    contentType = MarketplaceViewer.ContentType.INSTALLED;
                } else {
                    throw new IllegalStateException();
                }
                MarketplacePage.this.getViewer().setContentType(contentType);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectionLink = new Link(parent, 0);
        this.selectionLink.setToolTipText(Messages.MarketplacePage_showSelection);
        this.selectionLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.selectionLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.selectionLink);
        this.computeSelectionLinkText();
        if (needSwitchMarketplaceLink) {
            Link link = new Link(parent, 0);
            link.setText(Messages.MarketplacePage_switchCatalog_link);
            link.setToolTipText(Messages.MarketplacePage_selectAlternateCatalog);
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MarketplacePage.this.switchMarketplaceLinkActivated();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)link);
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private int previousSelectionSize = 0;

            public void selectionChanged(SelectionChangedEvent event) {
                IWizardPage nextPage;
                IWizardPage currentPage;
                if (!MarketplacePage.this.isCurrentPage()) {
                    return;
                }
                SelectionModel selectionModel = MarketplacePage.this.getWizard().getSelectionModel();
                int newSelectionSize = selectionModel.getItemToOperation().size();
                if (!event.getSelection().isEmpty() && this.previousSelectionSize == 0 && newSelectionSize == 1 && selectionModel.computeProvisioningOperationViable() && (currentPage = MarketplacePage.this.getContainer().getCurrentPage()).isPageComplete() && (nextPage = MarketplacePage.this.getWizard().getNextPage((IWizardPage)MarketplacePage.this)) != null) {
                    MarketplacePage.this.getContainer().showPage(nextPage);
                }
                this.previousSelectionSize = newSelectionSize;
            }
        });
        this.setControl((Control)(parent == originalParent ? this.tabFolder : parent));
        MarketplaceClientUi.setDefaultHelp(this.getControl());
    }

    private void computeSelectionLinkText() {
        if (this.selectionLink != null) {
            String originalText = this.selectionLink.getText();
            String text = " ";
            int count = this.getWizard().getSelectionModel().getItemToOperation().size();
            if (count == 1) {
                text = Messages.MarketplacePage_linkShowSelection_One;
            } else if (count > 0) {
                text = NLS.bind((String)Messages.MarketplacePage_linkShowSelection_Multiple, (Object)count);
            }
            if (!(text == originalText || text != null && text.equals(originalText))) {
                boolean exclude = text == null || text.trim().length() == 0;
                boolean originalExclude = ((GridData)this.selectionLink.getLayoutData()).exclude;
                this.selectionLink.setText(text);
                if (originalExclude != exclude) {
                    this.selectionLink.setVisible(!exclude);
                    ((GridData)this.selectionLink.getLayoutData()).exclude = exclude;
                    ((Composite)this.getControl()).layout(true, true);
                }
            }
        }
    }

    protected void selectionLinkActivated() {
        this.tabFolder.setSelection(this.searchTabItem);
        this.getViewer().showSelected();
    }

    protected void switchMarketplaceLinkActivated() {
        this.switchLinkActivated = true;
        this.getWizard().getContainer().showPage((IWizardPage)this.getWizard().getCatalogSelectionPage());
    }

    public IWizardPage getPreviousPage() {
        if (!this.switchLinkActivated) {
            return null;
        }
        return super.getPreviousPage();
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        MarketplaceViewer viewer = new MarketplaceViewer(this.getCatalog(), (IShellProvider)this, this.getWizard());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        return viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!MarketplacePage.this.getControl().isDisposed() && MarketplacePage.this.isCurrentPage()) {
                        MarketplacePage.this.getViewer().updateCatalog();
                    }
                }
            });
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
            if (catalogDescriptor != null) {
                this.setTitle(catalogDescriptor.getLabel());
            }
            if (this.previousCatalogDescriptor == null || !this.previousCatalogDescriptor.equals(catalogDescriptor)) {
                this.previousCatalogDescriptor = catalogDescriptor;
                this.tabFolder.setSelection(this.searchTabItem);
                this.getViewer().setContentType(MarketplaceViewer.ContentType.SEARCH);
                this.getWizard().initializeCatalog();
                this.updated = false;
            }
        }
        super.setVisible(visible);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = this.getWizard().getSelectionModel().computeProvisioningOperationViable();
        }
        this.computeMessages();
        super.setPageComplete(complete);
    }

    private void computeMessages() {
        this.computeStatusMessage();
        this.computeSelectionLinkText();
    }

    private void computeStatusMessage() {
        IStatus viability;
        String message = null;
        int messageType = 0;
        if (this.getWizard() != null && (viability = this.getWizard().getSelectionModel().computeProvisioningOperationViability()) != null) {
            message = viability.getMessage();
            messageType = Util.computeMessageType(viability);
        }
        this.setMessage(message, messageType);
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }
}

