/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.core.service.CachingMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Categories;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Ius;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.service.SearchResult;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.AbstractResourceRunnable;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceInfo;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String DOT_FEATURE_DOT_GROUP = ".feature.group";
    private static final Pattern BREAK_PATTERN = Pattern.compile("<!--\\s*break\\s*-->");
    protected final CatalogDescriptor catalogDescriptor;
    private final MarketplaceService marketplaceService;
    private MarketplaceCatalogSource source;
    private MarketplaceInfo marketplaceInfo;
    private Map<String, IInstallableUnit> featureIUById;

    public MarketplaceDiscoveryStrategy(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.catalogDescriptor = catalogDescriptor;
        this.marketplaceService = this.createMarketplaceService();
        this.source = new MarketplaceCatalogSource(this.marketplaceService);
        this.marketplaceInfo = MarketplaceInfo.getInstance();
    }

    public MarketplaceService createMarketplaceService() {
        Bundle runtimeBundle;
        DefaultMarketplaceService service = new DefaultMarketplaceService(this.catalogDescriptor.getUrl());
        HashMap<String, String> requestMetaParameters = new HashMap<String, String>();
        requestMetaParameters.put("client", "org.eclipse.epp.mpc.core");
        requestMetaParameters.put("os", Platform.getOS());
        requestMetaParameters.put("ws", Platform.getWS());
        requestMetaParameters.put("java.version", System.getProperty("java.version"));
        IProduct product = Platform.getProduct();
        if (product != null) {
            requestMetaParameters.put("product", product.getId());
            Bundle productBundle = product.getDefiningBundle();
            if (productBundle != null) {
                requestMetaParameters.put("product.version", productBundle.getVersion().toString());
            }
        }
        if ((runtimeBundle = Platform.getBundle((String)"org.eclipse.core.runtime")) != null) {
            requestMetaParameters.put("runtime.version", runtimeBundle.getVersion().toString());
        }
        service.setRequestMetaParameters(requestMetaParameters);
        return new CachingMarketplaceService((MarketplaceService)service);
    }

    public void dispose() {
        if (this.source != null) {
            this.source.dispose();
            this.source = null;
        }
        if (this.marketplaceInfo != null) {
            this.marketplaceInfo.save();
            this.marketplaceInfo = null;
        }
        super.dispose();
    }

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = 10000000;
        int workSegment = 3333333;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_loadingMarketplace, 10000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
            SearchResult featured = this.marketplaceService.featured((IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            this.handleSearchResult(catalogCategory, featured, (IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    protected void handleSearchResult(MarketplaceCategory catalogCategory, SearchResult result, IProgressMonitor monitor) {
        if (!result.getNodes().isEmpty()) {
            int totalWork = 10000000;
            monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_loadingResources, totalWork);
            ConcurrentTaskManager executor = new ConcurrentTaskManager(result.getNodes().size(), Messages.MarketplaceDiscoveryStrategy_loadingResources);
            try {
                ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
                RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
                HashSet<URI> knownRepositories = new HashSet<URI>(Arrays.asList(repositoryTracker.getKnownRepositories(session)));
                for (final Node node : result.getNodes()) {
                    final MarketplaceNodeCatalogItem catalogItem = new MarketplaceNodeCatalogItem();
                    catalogItem.setMarketplaceUrl(this.catalogDescriptor.getUrl());
                    catalogItem.setId(node.getId());
                    catalogItem.setName(node.getName());
                    catalogItem.setCategoryId(catalogCategory.getId());
                    Categories categories = node.getCategories();
                    if (categories != null) {
                        for (Category category : categories.getCategory()) {
                            catalogItem.addTag(new Tag(Category.class, category.getId(), category.getName()));
                        }
                    }
                    catalogItem.setData(node);
                    catalogItem.setSource(this.source);
                    catalogItem.setLicense(node.getLicense());
                    Ius ius = node.getIus();
                    if (ius != null) {
                        ArrayList<String> discoveryIus = new ArrayList<String>(ius.getIu());
                        int x = 0;
                        while (x < discoveryIus.size()) {
                            String iu = (String)discoveryIus.get(x);
                            if (!iu.endsWith(DOT_FEATURE_DOT_GROUP)) {
                                discoveryIus.set(x, String.valueOf(iu) + DOT_FEATURE_DOT_GROUP);
                            }
                            ++x;
                        }
                        catalogItem.setInstallableUnits(discoveryIus);
                    }
                    if (node.getShortdescription() == null && node.getBody() != null) {
                        String shortDescriptionText;
                        int start;
                        String descriptionText = node.getBody();
                        Matcher matcher = BREAK_PATTERN.matcher(node.getBody());
                        if (matcher.find() && (start = matcher.start()) > 0 && (shortDescriptionText = descriptionText.substring(0, start).trim()).length() > 0) {
                            descriptionText = shortDescriptionText;
                        }
                        catalogItem.setDescription(descriptionText);
                    } else {
                        catalogItem.setDescription(node.getShortdescription());
                    }
                    catalogItem.setProvider(node.getCompanyname());
                    String updateurl = node.getUpdateurl();
                    if (updateurl != null) {
                        try {
                            updateurl = updateurl.trim();
                            new URL(updateurl);
                            catalogItem.setSiteUrl(updateurl);
                        }
                        catch (MalformedURLException matcher) {
                            // empty catch block
                        }
                    }
                    if (node.getBody() != null || node.getScreenshot() != null) {
                        final Overview overview = new Overview();
                        overview.setItem((CatalogItem)catalogItem);
                        overview.setSummary(node.getBody());
                        overview.setUrl(node.getUrl());
                        catalogItem.setOverview(overview);
                        if (node.getScreenshot() != null) {
                            if (!this.source.getResourceProvider().containsResource(node.getScreenshot())) {
                                executor.submit(new AbstractResourceRunnable(monitor, this.source.getResourceProvider(), node.getScreenshot()){

                                    protected void resourceRetrieved() {
                                        overview.setScreenshot(node.getScreenshot());
                                    }
                                });
                            } else {
                                overview.setScreenshot(node.getScreenshot());
                            }
                        }
                    }
                    if (node.getImage() != null) {
                        if (!this.source.getResourceProvider().containsResource(node.getImage())) {
                            executor.submit(new AbstractResourceRunnable(monitor, this.source.getResourceProvider(), node.getImage()){

                                protected void resourceRetrieved() {
                                    MarketplaceDiscoveryStrategy.this.createIcon(catalogItem, node);
                                }
                            });
                        } else {
                            this.createIcon(catalogItem, node);
                        }
                    }
                    this.items.add(catalogItem);
                    this.marketplaceInfo.map(catalogItem.getMarketplaceUrl(), node);
                    catalogItem.setInstalled(this.marketplaceInfo.computeInstalled(this.computeInstalledFeatures(monitor), knownRepositories, node));
                }
                try {
                    executor.waitUntilFinished((IProgressMonitor)new SubProgressMonitor(monitor, totalWork - 10));
                }
                catch (CoreException e) {
                    MarketplaceClientUi.error(e);
                }
            }
            finally {
                executor.shutdownNow();
                monitor.done();
            }
            if (result.getMatchCount() != null) {
                catalogCategory.setMatchCount(result.getMatchCount());
                if (result.getMatchCount() > result.getNodes().size()) {
                    this.addCatalogItem(catalogCategory);
                }
            }
        }
    }

    public void maybeAddCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem;
        if (!this.items.isEmpty() && (catalogItem = (CatalogItem)this.items.get(this.items.size() - 1)).getData() != this.catalogDescriptor) {
            this.addCatalogItem(catalogCategory);
        }
    }

    public void addCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem = new CatalogItem();
        catalogItem.setSource((AbstractCatalogSource)this.source);
        catalogItem.setData((Object)this.catalogDescriptor);
        catalogItem.setId(this.catalogDescriptor.getUrl().toString());
        catalogItem.setCategoryId(catalogCategory.getId());
        this.items.add(catalogItem);
    }

    private void createIcon(CatalogItem catalogItem, Node node) {
        Icon icon = new Icon();
        icon.setImage32(node.getImage());
        icon.setImage48(node.getImage());
        icon.setImage64(node.getImage());
        catalogItem.setIcon(icon);
    }

    public void performQuery(Market market, Category category, String queryText, IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            SearchResult result = this.marketplaceService.search(market, category, queryText, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
        }
        finally {
            monitor.done();
        }
    }

    public void recent(IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.RECENT);
            SearchResult result = this.marketplaceService.recent((IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void featured(IProgressMonitor monitor, Market market, Category category) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
            SearchResult result = this.marketplaceService.featured((IProgressMonitor)new SubProgressMonitor(monitor, 500000), market, category);
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void popular(IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.POPULAR);
            SearchResult result = this.marketplaceService.favorites((IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void installed(IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_findingInstalled, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.INSTALLED);
            SearchResult result = new SearchResult();
            result.setNodes(new ArrayList());
            Set<String> installedFeatures = this.computeInstalledFeatures(monitor);
            if (!monitor.isCanceled()) {
                Set<Node> catalogNodes = this.marketplaceInfo.computeInstalledNodes(this.catalogDescriptor.getUrl(), installedFeatures);
                if (!catalogNodes.isEmpty()) {
                    int unitWork = 1000000 / (2 * catalogNodes.size());
                    for (Node node : catalogNodes) {
                        node = this.marketplaceService.getNode(node, monitor);
                        result.getNodes().add(node);
                        monitor.worked(unitWork);
                    }
                } else {
                    monitor.worked(500000);
                }
                this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void performQuery(IProgressMonitor monitor, Set<String> nodeIds) throws CoreException {
        int totalWork = 1000000;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            SearchResult result = new SearchResult();
            result.setNodes(new ArrayList());
            if (!monitor.isCanceled()) {
                if (!nodeIds.isEmpty()) {
                    int unitWork = 1000000 / (2 * nodeIds.size());
                    for (String nodeId : nodeIds) {
                        Node node = new Node();
                        node.setId(nodeId);
                        node = this.marketplaceService.getNode(node, monitor);
                        result.getNodes().add(node);
                        monitor.worked(unitWork);
                    }
                } else {
                    monitor.worked(500000);
                }
                result.setMatchCount(Integer.valueOf(result.getNodes().size()));
                this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
                this.maybeAddCatalogItem(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected Set<String> computeInstalledFeatures(IProgressMonitor monitor) {
        return this.computeInstalledIUs(monitor).keySet();
    }

    protected synchronized Map<String, IInstallableUnit> computeInstalledIUs(IProgressMonitor monitor) {
        if (this.featureIUById == null) {
            this.featureIUById = MarketplaceClientUi.computeInstalledIUsById(monitor);
        }
        return this.featureIUById;
    }

    protected MarketplaceCategory findMarketplaceCategory(IProgressMonitor monitor) throws CoreException {
        MarketplaceCategory catalogCategory = null;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_catalogCategory, 10000);
        try {
            for (CatalogCategory candidate : this.getCategories()) {
                if (candidate.getSource() != this.source) continue;
                catalogCategory = (MarketplaceCategory)candidate;
            }
            if (catalogCategory == null) {
                List markets = this.marketplaceService.listMarkets((IProgressMonitor)new SubProgressMonitor(monitor, 10000));
                catalogCategory = new MarketplaceCategory();
                catalogCategory.setId("<root>");
                catalogCategory.setName("<root>");
                catalogCategory.setSource(this.source);
                catalogCategory.setMarkets(markets);
                this.categories.add(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
        return catalogCategory;
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_sendingErrorNotification, 100);
        try {
            HashSet<Node> nodes = new HashSet<Node>();
            for (CatalogItem item : items) {
                Object data = item.getData();
                if (!(data instanceof Node)) continue;
                nodes.add((Node)data);
            }
            HashSet<String> iuIdsAndVersions = new HashSet<String>();
            IInstallableUnit[] iInstallableUnitArray = operationIUs;
            int n = operationIUs.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                String id = iu.getId();
                String version = iu.getVersion() == null ? null : iu.getVersion().toString();
                iuIdsAndVersions.add(String.valueOf(id) + "," + version);
                ++n2;
            }
            this.marketplaceService.reportInstallError(monitor, result, nodes, iuIdsAndVersions, resolutionDetails);
        }
        finally {
            monitor.done();
        }
    }
}

