/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskWorkingSetUpdater
implements IWorkingSetUpdater,
ITaskListChangeListener,
IResourceChangeListener {
    public static String ID_TASK_WORKING_SET = "org.eclipse.mylyn.tasks.ui.workingSet";
    private final List<IWorkingSet> workingSets = new CopyOnWriteArrayList<IWorkingSet>();
    private static TaskWorkingSetUpdater INSTANCE;

    public TaskWorkingSetUpdater() {
        INSTANCE = this;
        TasksUiInternal.getTaskList().addChangeListener((ITaskListChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        TasksUiInternal.getTaskList().removeChangeListener((ITaskListChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            this.workingSets.add(workingSet);
        }
    }

    private void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<Object> list = new ArrayList<Object>();
        IAdaptable[] iAdaptableArray = workingSet.getElements();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IAdaptable adaptable = iAdaptableArray[n2];
            if (adaptable instanceof AbstractTaskContainer) {
                String handle = ((AbstractTaskContainer)adaptable).getHandleIdentifier();
                for (IRepositoryElement element : TasksUiPlugin.getTaskList().getRootElements()) {
                    if (element == null || !element.getHandleIdentifier().equals(handle)) continue;
                    list.add(adaptable);
                }
            } else if (adaptable instanceof IProject && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(((IProject)adaptable).getName())) != null && project.exists()) {
                list.add(project);
            }
            ++n2;
        }
        workingSet.setElements(list.toArray(new IAdaptable[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            return this.workingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            return this.workingSets.remove(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void containersChanged(Set<TaskContainerDelta> delta) {
        for (TaskContainerDelta taskContainerDelta : delta) {
            if (!(taskContainerDelta.getElement() instanceof TaskCategory) && !(taskContainerDelta.getElement() instanceof IRepositoryQuery)) continue;
            List<IWorkingSet> list = this.workingSets;
            synchronized (list) {
                switch (taskContainerDelta.getKind()) {
                    case REMOVED: {
                        for (IWorkingSet workingSet : this.workingSets) {
                            ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
                            elements.remove(taskContainerDelta.getElement());
                            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                        }
                        break;
                    }
                    case ADDED: {
                        IWorkingSet[] iWorkingSetArray = TaskWorkingSetUpdater.getEnabledSets();
                        int n = iWorkingSetArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkingSet workingSet;
                            workingSet = iWorkingSetArray[n2];
                            ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
                            elements.add((IAdaptable)taskContainerDelta.getElement());
                            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                            ++n2;
                        }
                        break;
                    }
                }
            }
        }
    }

    public static IWorkingSet[] getEnabledSets() {
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        Set windows = MonitorUi.getMonitoredWindows();
        for (IWorkbenchWindow iWorkbenchWindow : windows) {
            IWorkbenchPage page = iWorkbenchWindow.getActivePage();
            if (page == null) continue;
            workingSets.addAll(Arrays.asList(page.getWorkingSets()));
        }
        return workingSets.toArray(new IWorkingSet[workingSets.size()]);
    }

    public static boolean areNoTaskWorkingSetsEnabled() {
        IWorkingSet[] workingSets;
        IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet != null && workingSet.getId().equalsIgnoreCase(ID_TASK_WORKING_SET) && TaskWorkingSetUpdater.isWorkingSetEnabled(workingSet)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWorkingSetEnabled(IWorkingSet set) {
        IWorkingSet[] enabledSets;
        IWorkingSet[] iWorkingSetArray = enabledSets = TaskWorkingSetUpdater.getEnabledSets();
        int n = enabledSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet enabledSet = iWorkingSetArray[n2];
            if (enabledSet.equals(set)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOnlyTaskWorkingSetEnabled(IWorkingSet set) {
        if (!TaskWorkingSetUpdater.isWorkingSetEnabled(set)) {
            return false;
        }
        IWorkingSet[] enabledSets = TaskWorkingSetUpdater.getEnabledSets();
        int i = 0;
        while (i < enabledSets.length) {
            if (!enabledSets[i].equals(set) && enabledSets[i].getId().equalsIgnoreCase(ID_TASK_WORKING_SET)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void processResourceDelta(TaskWorkingSetDelta result, IResourceDelta delta) {
        IResourceDelta[] children;
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        if (this.projectGotClosedOrOpened(resource, kind, flags)) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta element = iResourceDeltaArray[n2];
            this.processResourceDelta(result, element);
            ++n2;
        }
    }

    private boolean projectGotClosedOrOpened(IResource resource, int kind, int flags) {
        return resource.getType() == 4 && kind == 4 && (flags & 0x4000) != 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        for (IWorkingSet workingSet : this.workingSets) {
            TaskWorkingSetDelta workingSetDelta = new TaskWorkingSetDelta(workingSet);
            if (event.getDelta() != null) {
                this.processResourceDelta(workingSetDelta, event.getDelta());
            }
            workingSetDelta.process();
        }
    }

    public static void applyWorkingSetsToAllWindows(Collection<IWorkingSet> workingSets) {
        IWorkingSet[] workingSetArray = workingSets.toArray(new IWorkingSet[workingSets.size()]);
        for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                page.setWorkingSets(workingSetArray);
                ++n2;
            }
        }
    }

    public static Set<IWorkingSet> getActiveWorkingSets(IWorkbenchWindow window) {
        if (window != null && window.getActivePage() != null) {
            HashSet<IWorkingSet> allSets = new HashSet<IWorkingSet>(Arrays.asList(window.getActivePage().getWorkingSets()));
            HashSet<IWorkingSet> tasksSets = new HashSet<IWorkingSet>(allSets);
            for (IWorkingSet workingSet : allSets) {
                if (workingSet.getId() != null && workingSet.getId().equalsIgnoreCase(ID_TASK_WORKING_SET)) continue;
                tasksSets.remove(workingSet);
            }
            return tasksSets;
        }
        return Collections.emptySet();
    }

    public static TaskWorkingSetUpdater getInstance() {
        return INSTANCE;
    }

    private static class TaskWorkingSetDelta {
        private final IWorkingSet workingSet;
        private final List<Object> elements;
        private boolean changed;

        public TaskWorkingSetDelta(IWorkingSet workingSet) {
            this.workingSet = workingSet;
            this.elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.elements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.elements.set(index, element);
            this.changed = true;
        }

        public void remove(int index) {
            if (this.elements.remove(index) != null) {
                this.changed = true;
            }
        }

        public void process() {
            if (this.changed) {
                this.workingSet.setElements(this.elements.toArray(new IAdaptable[this.elements.size()]));
            }
        }
    }
}

