/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractSearchProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IWorkbenchWindow;

public class SearchUtil {
    private static final String EXTENSION_SEARCH_PROVIDER = "org.eclipse.mylyn.tasks.ui.searchProvider";
    private static final String ATTR_CLASS = "class";
    private static AbstractSearchProvider provider;

    private static final AbstractSearchProvider getSearchProvider() {
        if (provider != null) {
            return provider;
        }
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = registry.getConfigurationElementsFor(EXTENSION_SEARCH_PROVIDER);
            if (configurationElements.length > 0) {
                IConfigurationElement providerConfiguration;
                Object object;
                if (configurationElements.length > 1) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "More than one search provider was registered."));
                }
                if ((object = (providerConfiguration = configurationElements[0]).createExecutableExtension(ATTR_CLASS)) instanceof AbstractSearchProvider) {
                    provider = (AbstractSearchProvider)object;
                    return provider;
                }
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Specified search provider is not of type AbstractSearchProvider."));
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "No search provider was registed. Tasks search is not available."));
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Loading of searchProvider extension failed.", (Throwable)e));
        }
        if (provider == null) {
            provider = new NullSearchProvider();
        }
        return provider;
    }

    public static boolean supportsTaskSearch() {
        return !(SearchUtil.getSearchProvider() instanceof NullSearchProvider);
    }

    public static void openSearchDialog(IWorkbenchWindow window) {
        SearchUtil.getSearchProvider().openSearchDialog(window);
    }

    public static void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery) {
        SearchUtil.getSearchProvider().runSearchQuery(tasklist, repository, repositoryQuery, false);
    }

    public static void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery, boolean activateResultView) {
        SearchUtil.getSearchProvider().runSearchQuery(tasklist, repository, repositoryQuery, activateResultView);
    }

    private static class NullSearchProvider
    extends AbstractSearchProvider {
        private NullSearchProvider() {
        }

        public void openSearchDialog(IWorkbenchWindow window) {
        }

        public void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery query, boolean activateResultView) {
        }
    }
}

