/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonFormUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.FillWidthLayout;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorRichTextPart
extends AbstractTaskEditorPart {
    private RichTextAttributeEditor editor;
    private TaskAttribute attribute;
    private Composite composite;
    private int sectionStyle;
    private ToggleToMaximizePartAction toggleToMaximizePartAction;
    private Action toggleEditAction;
    private Action toggleBrowserAction;
    private boolean ignoreToggleEvents;

    public TaskEditorRichTextPart() {
        this.setSectionStyle(322);
    }

    public void appendText(String text) {
        if (this.editor == null) {
            return;
        }
        this.editor.showEditor();
        if (this.toggleEditAction != null) {
            this.toggleEditAction.setChecked(false);
        }
        StringBuilder strBuilder = new StringBuilder();
        String oldText = this.editor.getViewer().getDocument().get();
        if (strBuilder.length() != 0) {
            strBuilder.append("\n");
        }
        strBuilder.append(oldText);
        strBuilder.append(text);
        this.editor.getViewer().getDocument().set(strBuilder.toString());
        TaskAttribute attribute = this.getTaskData().getRoot().getMappedAttribute("task.common.comment.new");
        if (attribute != null) {
            attribute.setValue(strBuilder.toString());
            this.getTaskEditorPage().getModel().attributeChanged(attribute);
        }
        this.editor.getViewer().getTextWidget().setCaretOffset(strBuilder.length());
        this.editor.getViewer().getTextWidget().showSelection();
    }

    public int getSectionStyle() {
        return this.sectionStyle;
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.attribute == null) {
            return;
        }
        AbstractAttributeEditor attributEditor = this.createAttributeEditor(this.attribute);
        if (!(attributEditor instanceof RichTextAttributeEditor)) {
            String clazz = attributEditor != null ? attributEditor.getClass().getName() : "<null>";
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Expected an instance of RichTextAttributeEditor, got \"" + clazz + "\""));
            return;
        }
        Section section = this.createSection(parent, toolkit, this.sectionStyle);
        this.composite = toolkit.createComposite((Composite)section);
        this.composite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        this.editor = (RichTextAttributeEditor)attributEditor;
        this.editor.createControl(this.composite, toolkit);
        if (this.editor.isReadOnly()) {
            this.composite.setLayout((Layout)new FillWidthLayout(EditorUtil.getLayoutAdvisor(this.getTaskEditorPage()), 0, 0, 0, 3));
        } else {
            StyledText textWidget = this.editor.getViewer().getTextWidget();
            this.editor.getControl().setLayoutData((Object)EditorUtil.getTextControlLayoutData(this.getTaskEditorPage(), (Control)textWidget, this.getExpandVertically()));
            this.editor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        }
        this.getEditor().getControl().setData("maximizeAction", (Object)this.getMaximizePartAction());
        if (this.getEditor().getControl() instanceof Composite) {
            Control[] controlArray = ((Composite)this.getEditor().getControl()).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setData("maximizeAction", (Object)this.getMaximizePartAction());
                ++n2;
            }
        }
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.editor);
        toolkit.paintBordersFor(this.composite);
        section.setClient((Control)this.composite);
        this.setSection(toolkit, section);
    }

    public TaskAttribute getAttribute() {
        return this.attribute;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected RichTextAttributeEditor getEditor() {
        return this.editor;
    }

    public void setAttribute(TaskAttribute attribute) {
        this.attribute = attribute;
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.getControl().setFocus();
        }
    }

    protected Action getMaximizePartAction() {
        if (this.toggleToMaximizePartAction == null) {
            this.toggleToMaximizePartAction = new ToggleToMaximizePartAction();
        }
        return this.toggleToMaximizePartAction;
    }

    protected void fillToolBar(ToolBarManager manager) {
        if (this.getEditor().hasPreview()) {
            this.toggleEditAction = new Action("", 2){

                public void run() {
                    if (this.isChecked()) {
                        TaskEditorRichTextPart.this.editor.showEditor();
                    } else {
                        TaskEditorRichTextPart.this.editor.showPreview();
                    }
                    if (TaskEditorRichTextPart.this.toggleBrowserAction != null) {
                        TaskEditorRichTextPart.this.toggleBrowserAction.setChecked(false);
                    }
                }
            };
            this.toggleEditAction.setImageDescriptor(CommonImages.EDIT_SMALL);
            this.toggleEditAction.setToolTipText(Messages.TaskEditorRichTextPart_Edit_Tooltip);
            this.toggleEditAction.setChecked(true);
            this.getEditor().getEditor().addStateChangedListener(new RichTextEditor.StateChangedListener(){

                public void stateChanged(RichTextEditor.StateChangedEvent event) {
                    try {
                        TaskEditorRichTextPart.this.ignoreToggleEvents = true;
                        TaskEditorRichTextPart.this.toggleEditAction.setChecked(event.state == RichTextEditor.State.EDITOR || event.state == RichTextEditor.State.DEFAULT);
                    }
                    finally {
                        TaskEditorRichTextPart.this.ignoreToggleEvents = false;
                    }
                }
            });
            manager.add((IAction)this.toggleEditAction);
        }
        if (this.toggleEditAction == null && this.getEditor().hasBrowser()) {
            this.toggleBrowserAction = new Action("", 2){

                public void run() {
                    if (TaskEditorRichTextPart.this.ignoreToggleEvents) {
                        return;
                    }
                    if (this.isChecked()) {
                        TaskEditorRichTextPart.this.editor.showBrowser();
                    } else {
                        TaskEditorRichTextPart.this.editor.showEditor();
                    }
                    if (TaskEditorRichTextPart.this.toggleEditAction != null) {
                        TaskEditorRichTextPart.this.toggleEditAction.setChecked(false);
                    }
                }
            };
            this.toggleBrowserAction.setImageDescriptor(CommonImages.PREVIEW_WEB);
            this.toggleBrowserAction.setToolTipText(Messages.TaskEditorRichTextPart_Browser_Preview);
            this.toggleBrowserAction.setChecked(false);
            this.getEditor().getEditor().addStateChangedListener(new RichTextEditor.StateChangedListener(){

                public void stateChanged(RichTextEditor.StateChangedEvent event) {
                    try {
                        TaskEditorRichTextPart.this.ignoreToggleEvents = true;
                        TaskEditorRichTextPart.this.toggleBrowserAction.setChecked(event.state == RichTextEditor.State.BROWSER);
                    }
                    finally {
                        TaskEditorRichTextPart.this.ignoreToggleEvents = false;
                    }
                }
            });
            manager.add((IAction)this.toggleBrowserAction);
        }
        if (!this.getEditor().isReadOnly()) {
            manager.add((IAction)this.getMaximizePartAction());
        }
        super.fillToolBar(manager);
    }

    private class ToggleToMaximizePartAction
    extends Action {
        private static final String COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.maximizePart";
        private final String MAXIMIZE;
        private static final int SECTION_HEADER_HEIGHT = 50;
        private int originalHeight;

        public ToggleToMaximizePartAction() {
            super("", 2);
            this.MAXIMIZE = Messages.TaskEditorRichTextPart_Maximize;
            this.originalHeight = -2;
            this.setImageDescriptor(CommonImages.PART_MAXIMIZE);
            this.setToolTipText(this.MAXIMIZE);
            this.setActionDefinitionId(COMMAND_ID);
            this.setChecked(false);
        }

        public void run() {
            if (!(TaskEditorRichTextPart.this.getEditor().getControl().getLayoutData() instanceof GridData)) {
                return;
            }
            GridData gd = (GridData)TaskEditorRichTextPart.this.getEditor().getControl().getLayoutData();
            if (this.originalHeight == -2) {
                this.originalHeight = gd.heightHint;
            }
            try {
                TaskEditorRichTextPart.this.getTaskEditorPage().setReflow(false);
                int heightHint = this.isChecked() ? TaskEditorRichTextPart.this.getManagedForm().getForm().getClientArea().height - 50 : this.originalHeight;
                if (gd.heightHint == heightHint) {
                    return;
                }
                gd.heightHint = heightHint;
                gd.minimumHeight = heightHint;
            }
            finally {
                TaskEditorRichTextPart.this.getTaskEditorPage().setReflow(true);
            }
            TaskEditorRichTextPart.this.getTaskEditorPage().reflow();
            CommonFormUtil.ensureVisible((Control)TaskEditorRichTextPart.this.getEditor().getControl());
        }
    }
}

