/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoIntoAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoUpAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RenameAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RepositoryElementActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.ui.part.DrillDownAdapter;

public class TaskListViewActionGroup
extends RepositoryElementActionGroup {
    private final RenameAction renameAction;
    private final TaskListView view;
    private final GoIntoAction goIntoAction;
    private final GoUpAction goUpAction;
    private final DrillDownAdapter drillDownAdapter;

    public TaskListViewActionGroup(TaskListView view, DrillDownAdapter drillDownAdapter) {
        this.view = view;
        this.drillDownAdapter = drillDownAdapter;
        this.goIntoAction = new GoIntoAction();
        this.goUpAction = new GoUpAction(drillDownAdapter);
        this.renameAction = new RenameAction(view);
        view.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.renameAction);
        this.setSelectionProvider((ISelectionProvider)view.getViewer());
    }

    public void dispose() {
        this.view.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this.renameAction);
        this.setSelectionProvider(null);
    }

    public void updateDrillDownActions() {
        if (this.drillDownAdapter.canGoBack()) {
            this.goUpAction.setEnabled(true);
        } else {
            this.goUpAction.setEnabled(false);
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        this.updateDrillDownActions();
        Object element = ((IStructuredSelection)this.view.getViewer().getSelection()).getFirstElement();
        if (element instanceof ITaskContainer && !(element instanceof ITask)) {
            ITaskContainer cat = (ITaskContainer)element;
            if (cat.getChildren().size() > 0) {
                this.goIntoAction.setEnabled(true);
            } else {
                this.goIntoAction.setEnabled(false);
            }
        } else {
            this.goIntoAction.setEnabled(false);
        }
        if (this.goIntoAction.isEnabled()) {
            manager.appendToGroup("navigate", (IAction)this.goIntoAction);
        }
        if (this.goUpAction.isEnabled()) {
            manager.appendToGroup("navigate", (IAction)this.goUpAction);
        }
        if (!(element instanceof ITask) && this.renameAction.isEnabled() && element != null) {
            manager.appendToGroup("edit", (IAction)this.renameAction);
        }
    }

    public GoUpAction getGoUpAction() {
        return this.goUpAction;
    }

    public GoIntoAction getGoIntoAction() {
        return this.goIntoAction;
    }

    public RenameAction getRenameAction() {
        return this.renameAction;
    }
}

