/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Vector;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.sse.core.internal.util.Assert;

public class StructuredDocumentRegionIterator {
    public static final IStructuredDocumentRegion adjustStart(IStructuredDocumentRegion headNode, int adjustment) {
        IStructuredDocumentRegion aNode = headNode;
        while (aNode != null) {
            aNode.adjustStart(adjustment);
            aNode = aNode.getNext();
        }
        return headNode;
    }

    public static final int countRegions(IStructuredDocumentRegionList flatNodes) {
        int result = 0;
        if (flatNodes != null) {
            int length = flatNodes.getLength();
            int i = 0;
            while (i < length) {
                IStructuredDocumentRegion node = flatNodes.item(i);
                if (node != null) {
                    result += node.getNumberOfRegions();
                }
                ++i;
            }
        }
        return result;
    }

    public static final String getText(CoreNodeList flatNodes) {
        String result = null;
        if (flatNodes == null) {
            result = "";
        } else {
            StringBuffer buff = new StringBuffer();
            int length = flatNodes.getLength();
            int i = 0;
            while (i < length) {
                buff.append(flatNodes.item(i).getText());
                ++i;
            }
            result = buff.toString();
        }
        return result;
    }

    public static final CoreNodeList setParentDocument(CoreNodeList nodelist, IStructuredDocument textStore) {
        Assert.isNotNull(nodelist, "nodelist was null in CoreNodeList::setTextStore(CoreNodeList, StructuredTextStore)");
        int len = nodelist.getLength();
        int i = 0;
        while (i < len) {
            IStructuredDocumentRegion node = nodelist.item(i);
            node.setParentDocument(textStore);
            ++i;
        }
        return nodelist;
    }

    public static final IStructuredDocumentRegion setParentDocument(IStructuredDocumentRegion headNode, IStructuredDocument document) {
        IStructuredDocumentRegion aNode = headNode;
        while (aNode != null) {
            aNode.setParentDocument(document);
            aNode = aNode.getNext();
        }
        return headNode;
    }

    public static final Vector toVector(IStructuredDocumentRegion headNode) {
        IStructuredDocumentRegion aNode = headNode;
        Vector<IStructuredDocumentRegion> v = new Vector<IStructuredDocumentRegion>();
        while (aNode != null) {
            v.addElement(aNode);
            aNode = aNode.getNext();
        }
        return v;
    }

    private StructuredDocumentRegionIterator() {
    }
}

