/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.eclipse.help.internal.criteria.CriteriaProviderRegistry;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;

public class WorkingSetScope
extends AbstractHelpScope {
    private static final String UNCATEGORIZED = "Uncategorized";
    private IHelpWorkingSetManager wSetManager;
    private WorkingSet workingSet;
    private AdaptableHelpResource[] elements;
    private CriterionResource[] criteria;
    private String name;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkingSetScope(String scope, IHelpWorkingSetManager manager, String name) {
        this.wSetManager = manager;
        this.workingSet = this.wSetManager.getWorkingSet(scope);
        this.elements = this.workingSet.getElements();
        this.criteria = this.workingSet.getCriteria();
        this.name = name;
    }

    public boolean inScope(IToc toc) {
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            return this.inContentScope(toc) && this.inCriteriaScope(toc);
        }
        return this.inContentScope(toc);
    }

    private boolean inContentScope(IToc toc) {
        int i = 0;
        while (i < this.elements.length) {
            AdaptableHelpResource adaptable = this.elements[i];
            while (adaptable != null) {
                Object itoc;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.help.IToc");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toc == (itoc = adaptable.getAdapter(clazz))) {
                    return true;
                }
                IAdaptable parent = adaptable.getParent();
                adaptable = parent instanceof AdaptableHelpResource ? (AdaptableHelpResource)parent : null;
            }
            ++i;
        }
        return false;
    }

    private boolean inCriteriaScope(IToc toc) {
        if (toc == null) {
            return this.criteria == null || this.criteria.length == 0;
        }
        ICriteria[] criteriaOfToc = CriteriaProviderRegistry.getInstance().getAllCriteria(toc);
        return this.isCriteriaInScope(criteriaOfToc);
    }

    private boolean isCriteriaInScope(ICriteria[] criteriaOfTopic) {
        if (this.criteria == null) {
            return true;
        }
        Map ownCriteria = this.getCriteriaInfo(criteriaOfTopic);
        Map scope = this.getCriteriaInfo(this.criteria);
        Iterator keyIterator = scope.keySet().iterator();
        block0: while (keyIterator.hasNext()) {
            String key = String.valueOf(keyIterator.next());
            Iterator valueIterator = ((Set)scope.get(key)).iterator();
            while (valueIterator.hasNext()) {
                String value = String.valueOf(valueIterator.next());
                if (!value.equals(UNCATEGORIZED) ? ownCriteria.get(key) != null && ((Set)ownCriteria.get(key)).contains(value) : !ownCriteria.containsKey(key)) continue block0;
            }
            return false;
        }
        return true;
    }

    private Map getCriteriaInfo(CriterionResource[] criteria) {
        HashMap criteriaMap = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    private Map getCriteriaInfo(ICriteria[] criteria) {
        HashMap criteriaMap = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    public boolean inScope(ITopic topic) {
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            return this.inContentScope(topic) && this.inCriteriaScope(topic);
        }
        return this.inContentScope(topic);
    }

    private boolean inContentScope(ITopic topic) {
        HashSet<Object> topics = new HashSet<Object>();
        IToc toc = null;
        topics.add(topic);
        if (topic instanceof UAElement) {
            UAElement uae = (UAElement)topic;
            while (uae != null) {
                if (uae instanceof IToc) {
                    toc = (IToc)uae;
                    uae = null;
                    continue;
                }
                if (uae instanceof IIndexEntry) {
                    int i = 0;
                    while (i < this.elements.length) {
                        AdaptableHelpResource adaptable = this.elements[i];
                        if (adaptable.getTopic(topic.getHref()) != null) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if (uae instanceof ITopic) {
                    topics.add(uae);
                }
                uae = uae.getParentElement();
            }
        }
        int i = 0;
        while (i < this.elements.length) {
            Class<?> clazz;
            AdaptableHelpResource adaptable = this.elements[i];
            if (toc != null) {
                Object itoc;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.help.IToc");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toc == (itoc = adaptable.getAdapter(clazz2))) {
                    return true;
                }
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = Class.forName("org.eclipse.help.ITopic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object itopic = adaptable.getAdapter(clazz);
            if (topic != null && topics.contains(itopic)) {
                return true;
            }
            IAdaptable parent = adaptable.getParent();
            adaptable = parent instanceof AdaptableHelpResource ? (AdaptableHelpResource)parent : null;
            ++i;
        }
        return false;
    }

    private boolean inCriteriaScope(ITopic topic) {
        if (topic == null) {
            return this.criteria == null || this.criteria.length == 0;
        }
        ICriteria[] criteriaOfTopic = CriteriaProviderRegistry.getInstance().getAllCriteria(topic);
        return this.isCriteriaInScope(criteriaOfTopic);
    }

    public boolean inScope(IIndexEntry entry) {
        return this.hasInScopeChildren((IUAElement)entry);
    }

    public boolean inScope(IIndexSee see) {
        return this.hasInScopeChildren((IUAElement)see);
    }

    public String getName(Locale locale) {
        return this.name;
    }
}

