/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JUnitPlugin
extends AbstractUIPlugin {
    private static JUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS = "org.eclipse.jdt.junit.junitLaunchConfigs";
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private List fJUnitLaunchConfigTypeIDs;
    private BundleContext fBundleContext;
    private static boolean fIsStopped = false;
    static /* synthetic */ Class class$0;

    public JUnitPlugin() {
        fgPlugin = this;
    }

    public static JUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        JUnitPlugin.log((IStatus)new Status(4, JUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitPlugin.getDefault().getLog().log(status);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, true);
    }

    public static Image createImage(String path) {
        return JUnitPlugin.getImageDescriptor(path).createImage();
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JUnitPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = JUnitPlugin.createImageDescriptor("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = JUnitPlugin.createImageDescriptor("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(pathPrefix).append(imageName);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        fIsStopped = true;
        super.stop(context);
        this.fBundleContext = null;
    }

    public Object getService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    private void loadLaunchConfigTypeIDs() {
        this.fJUnitLaunchConfigTypeIDs = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            String configTypeID = configs[i].getAttribute("configTypeID");
            this.fJUnitLaunchConfigTypeIDs.add(configTypeID);
            ++i;
        }
    }

    public List getJUnitLaunchConfigTypeIDs() {
        if (this.fJUnitLaunchConfigTypeIDs == null) {
            this.loadLaunchConfigTypeIDs();
        }
        return this.fJUnitLaunchConfigTypeIDs;
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        ServiceReference serviceRef;
        PackageAdmin admin;
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bundles = (admin = (PackageAdmin)this.fBundleContext.getService(serviceRef = this.fBundleContext.getServiceReference(clazz.getName()))).getBundles(bundleName, version)) != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public static boolean isStopped() {
        return fIsStopped;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void asyncShowTestRunnerViewPart() {
        JUnitPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                JUnitPlugin.showTestRunnerViewPartInActivePage();
            }
        });
    }

    public static TestRunnerViewPart showTestRunnerViewPartInActivePage() {
        IWorkbenchPage page;
        block3: {
            try {
                page = JUnitPlugin.getActivePage();
                if (page != null) break block3;
                return null;
            }
            catch (PartInitException pie) {
                JUnitPlugin.log(pie);
                return null;
            }
        }
        return (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView", null, 2);
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

