/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class CleanupDialogXML
extends Dialog
implements SelectionListener {
    protected Button fCheckBoxCompressEmptyElementTags;
    protected Button fCheckBoxConvertEOLCodes;
    protected Button fCheckBoxFormatSource;
    protected Button fCheckBoxInsertMissingTags;
    protected Button fCheckBoxInsertRequiredAttrs;
    protected Button fCheckBoxQuoteAttrValues;
    protected Button fCheckBoxInsertXMLDeclaration;
    protected IStructuredModel fModel = null;
    protected Preferences fPreferences = null;
    protected Button fRadioButtonAttrNameCaseAsis;
    protected Button fRadioButtonAttrNameCaseLower;
    protected Button fRadioButtonAttrNameCaseUpper;
    protected Button fRadioButtonConvertEOLMac;
    protected Button fRadioButtonConvertEOLUnix;
    protected Button fRadioButtonConvertEOLWindows;
    protected Button fRadioButtonTagNameCaseAsis;
    protected Button fRadioButtonTagNameCaseLower;
    protected Button fRadioButtonTagNameCaseUpper;

    public CleanupDialogXML(Shell shell) {
        super(shell);
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText(XMLUIMessages.Cleanup_UI_);
        Composite composite = new Composite(parent, 0);
        this.createDialogAreaInComposite(composite);
        this.initializeOptions();
        return composite;
    }

    protected void createDialogAreaInComposite(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.xmlm1200");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.fCheckBoxCompressEmptyElementTags = new Button(composite, 32);
        this.fCheckBoxCompressEmptyElementTags.setText(XMLUIMessages.Compress_empty_element_tags_UI_);
        this.fCheckBoxCompressEmptyElementTags.addSelectionListener((SelectionListener)this);
        this.fCheckBoxInsertRequiredAttrs = new Button(composite, 32);
        this.fCheckBoxInsertRequiredAttrs.setText(XMLUIMessages.Insert_required_attributes_UI_);
        this.fCheckBoxInsertRequiredAttrs.addSelectionListener((SelectionListener)this);
        this.fCheckBoxInsertMissingTags = new Button(composite, 32);
        this.fCheckBoxInsertMissingTags.setText(XMLUIMessages.Insert_missing_tags_UI_);
        this.fCheckBoxInsertMissingTags.addSelectionListener((SelectionListener)this);
        this.fCheckBoxQuoteAttrValues = new Button(composite, 32);
        this.fCheckBoxQuoteAttrValues.setText(XMLUIMessages.Quote_attribute_values_UI_);
        this.fCheckBoxQuoteAttrValues.addSelectionListener((SelectionListener)this);
        this.fCheckBoxFormatSource = new Button(composite, 32);
        this.fCheckBoxFormatSource.setText(XMLUIMessages.Format_source_UI_);
        this.fCheckBoxFormatSource.addSelectionListener((SelectionListener)this);
        this.fCheckBoxInsertXMLDeclaration = new Button(composite, 32);
        this.fCheckBoxInsertXMLDeclaration.setText(XMLUIMessages.Insert_XML_decl);
        this.fCheckBoxInsertXMLDeclaration.addSelectionListener((SelectionListener)this);
        this.fCheckBoxConvertEOLCodes = new Button(composite, 32);
        this.fCheckBoxConvertEOLCodes.setText(XMLUIMessages.Convert_EOL_codes_UI_);
        this.fCheckBoxConvertEOLCodes.addSelectionListener((SelectionListener)this);
        Composite EOLCodes = new Composite(composite, 0);
        GridLayout hLayout = new GridLayout();
        hLayout.numColumns = 3;
        EOLCodes.setLayout((Layout)hLayout);
        this.fRadioButtonConvertEOLWindows = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLWindows.setText(XMLUIMessages.EOL_Windows_UI);
        this.fRadioButtonConvertEOLWindows.addSelectionListener((SelectionListener)this);
        this.fRadioButtonConvertEOLUnix = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLUnix.setText(XMLUIMessages.EOL_Unix_UI);
        this.fRadioButtonConvertEOLUnix.addSelectionListener((SelectionListener)this);
        this.fRadioButtonConvertEOLMac = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLMac.setText(XMLUIMessages.EOL_Mac_UI);
        this.fRadioButtonConvertEOLMac.addSelectionListener((SelectionListener)this);
    }

    protected void enableEOLCodeRadios(boolean enable) {
        if (this.fRadioButtonConvertEOLWindows != null && this.fRadioButtonConvertEOLUnix != null && this.fRadioButtonConvertEOLMac != null) {
            this.fRadioButtonConvertEOLWindows.setEnabled(enable);
            this.fRadioButtonConvertEOLUnix.setEnabled(enable);
            this.fRadioButtonConvertEOLMac.setEnabled(enable);
            if (!(this.fRadioButtonConvertEOLWindows.getSelection() || this.fRadioButtonConvertEOLUnix.getSelection() || this.fRadioButtonConvertEOLMac.getSelection())) {
                this.fRadioButtonConvertEOLWindows.setSelection(true);
            }
        }
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeOptions() {
        this.fCheckBoxCompressEmptyElementTags.setSelection(this.getModelPreferences().getBoolean("compressEmptyElementTags"));
        this.fCheckBoxInsertRequiredAttrs.setSelection(this.getModelPreferences().getBoolean("insertRequiredAttrs"));
        this.fCheckBoxInsertMissingTags.setSelection(this.getModelPreferences().getBoolean("insertMissingTags"));
        this.fCheckBoxQuoteAttrValues.setSelection(this.getModelPreferences().getBoolean("quoteAttrValues"));
        this.fCheckBoxFormatSource.setSelection(this.getModelPreferences().getBoolean("formatSource"));
        this.fCheckBoxConvertEOLCodes.setSelection(this.getModelPreferences().getBoolean("convertEOLCodes"));
        this.fCheckBoxInsertXMLDeclaration.setSelection(this.getModelPreferences().getBoolean("fixXMLDeclaration"));
        String EOLCode = this.getModelPreferences().getString("cleanupEOLCode");
        if (EOLCode.compareTo("EOL_Unix") == 0) {
            this.fRadioButtonConvertEOLUnix.setSelection(true);
        } else if (EOLCode.compareTo("EOL_Mac") == 0) {
            this.fRadioButtonConvertEOLMac.setSelection(true);
        } else {
            this.fRadioButtonConvertEOLWindows.setSelection(true);
        }
        this.enableEOLCodeRadios(this.fCheckBoxConvertEOLCodes.getSelection());
    }

    protected void okPressed() {
        this.storeOptions();
        super.okPressed();
    }

    public void setModel(IStructuredModel model) {
        this.fModel = model;
    }

    protected void storeOptions() {
        this.getModelPreferences().setValue("compressEmptyElementTags", this.fCheckBoxCompressEmptyElementTags.getSelection());
        this.getModelPreferences().setValue("insertRequiredAttrs", this.fCheckBoxInsertRequiredAttrs.getSelection());
        this.getModelPreferences().setValue("insertMissingTags", this.fCheckBoxInsertMissingTags.getSelection());
        this.getModelPreferences().setValue("quoteAttrValues", this.fCheckBoxQuoteAttrValues.getSelection());
        this.getModelPreferences().setValue("formatSource", this.fCheckBoxFormatSource.getSelection());
        this.getModelPreferences().setValue("convertEOLCodes", this.fCheckBoxConvertEOLCodes.getSelection());
        this.getModelPreferences().setValue("fixXMLDeclaration", this.fCheckBoxInsertXMLDeclaration.getSelection());
        if (this.fRadioButtonConvertEOLUnix.getSelection()) {
            this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Unix");
        } else if (this.fRadioButtonConvertEOLMac.getSelection()) {
            this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Mac");
        } else {
            this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Windows");
        }
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.getButton(0).setEnabled(this.fRadioButtonTagNameCaseLower != null && (this.fRadioButtonTagNameCaseLower.getSelection() || this.fRadioButtonTagNameCaseUpper.getSelection()) || this.fRadioButtonAttrNameCaseLower != null && (this.fRadioButtonAttrNameCaseLower.getSelection() || this.fRadioButtonAttrNameCaseUpper.getSelection()) || this.fCheckBoxInsertMissingTags.getSelection() || this.fCheckBoxQuoteAttrValues.getSelection() || this.fCheckBoxFormatSource.getSelection() || this.fCheckBoxConvertEOLCodes.getSelection() || this.fRadioButtonConvertEOLUnix != null && (this.fRadioButtonConvertEOLUnix.getSelection() || this.fRadioButtonConvertEOLMac.getSelection() || this.fRadioButtonConvertEOLWindows.getSelection()));
        if (e.widget == this.fCheckBoxConvertEOLCodes) {
            this.enableEOLCodeRadios(this.fCheckBoxConvertEOLCodes.getSelection());
        }
    }
}

