/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.actions.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractInterestManipulationAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String SOURCE_ID = "org.eclipse.mylyn.ui.interest.user";
    protected IViewPart view;
    protected IWorkbenchWindow window;
    protected boolean preserveUninteresting = false;
    private ISelection selection;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    @Deprecated
    protected boolean isRemove() {
        return !this.isIncrement();
    }

    protected abstract boolean isIncrement();

    protected IInteractionContext getContext() {
        return ContextCore.getContextManager().getActiveContext();
    }

    public void run(IAction action) {
        boolean increment;
        if (!ContextCore.getContextManager().isContextActive()) {
            MessageDialog.openInformation((Shell)WorkbenchUtil.getShell(), (String)Messages.AbstractInterestManipulationAction_Interest_Manipulation, (String)Messages.AbstractInterestManipulationAction_No_task_context_is_active);
            return;
        }
        boolean bl = increment = !this.isRemove();
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.selection;
            for (Object object : structuredSelection.toList()) {
                boolean manipulated;
                IInteractionElement node = this.convertSelectionToInteractionElement(object);
                if (node == null) continue;
                if (!increment) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().setSelection(null);
                    }
                    catch (Exception exception) {}
                }
                if (manipulated = ContextCorePlugin.getContextManager().manipulateInterestForElement(node, increment, false, this.preserveUninteresting, SOURCE_ID, this.getContext(), true)) continue;
                AbstractInterestManipulationAction.displayInterestManipulationFailure();
            }
        } else {
            IInteractionElement node = ContextCore.getContextManager().getActiveElement();
            if (node != null) {
                boolean manipulated = ContextCorePlugin.getContextManager().manipulateInterestForElement(node, increment, false, false, SOURCE_ID, this.getContext(), true);
                if (!manipulated) {
                    AbstractInterestManipulationAction.displayInterestManipulationFailure();
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AbstractInterestManipulationAction_Interest_Manipulation, (String)Messages.AbstractInterestManipulationAction_No_task_context_is_active);
            }
        }
    }

    protected IInteractionElement convertSelectionToInteractionElement(Object object) {
        IInteractionElement node = null;
        if (object instanceof IInteractionElement) {
            node = (IInteractionElement)object;
        } else {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)object);
            String handle = bridge.getHandleIdentifier(object);
            node = ContextCore.getContextManager().getElement(handle);
        }
        return node;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public static void displayInterestManipulationFailure() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AbstractInterestManipulationAction_Interest_Manipulation, (String)Messages.AbstractInterestManipulationAction_Not_a_valid_landmark);
    }
}

