/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.core.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.Messages;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XslfoDocumentBuilder
extends AbstractXmlDocumentBuilder {
    private static final String CSS_RULE_BACKGROUND_COLOR = "background-color";
    private static final String CSS_RULE_COLOR = "color";
    private static final String CSS_RULE_VERTICAL_ALIGN = "vertical-align";
    private static final String CSS_RULE_TEXT_DECORATION = "text-decoration";
    private static final String CSS_RULE_FONT_FAMILY = "font-family";
    private static final String CSS_RULE_FONT_SIZE = "font-size";
    private static final String CSS_RULE_FONT_WEIGHT = "font-weight";
    private static final String CSS_RULE_FONT_STYLE = "font-style";
    private static final char[] BULLET_CHARS = new char[]{'\u2022'};
    private static Map<DocumentBuilder.BlockType, String> blockTypeToCssStyles = new HashMap<DocumentBuilder.BlockType, String>();
    private static Map<DocumentBuilder.SpanType, String> spanTypeToCssStyles;
    private final String foNamespaceUri = "http://www.w3.org/1999/XSL/Format";
    private boolean pageOpen = false;
    private int h1Count = 0;
    private final Stack<ElementInfo> elementInfos = new Stack();
    private Configuration configuration = new Configuration();

    static {
        blockTypeToCssStyles.put(DocumentBuilder.BlockType.CODE, "font-family: monospace;");
        blockTypeToCssStyles.put(DocumentBuilder.BlockType.PREFORMATTED, "font-family: monospace;");
        blockTypeToCssStyles.put(DocumentBuilder.BlockType.TABLE_CELL_HEADER, "font-weight: bold;");
        spanTypeToCssStyles = new HashMap<DocumentBuilder.SpanType, String>();
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.STRONG, "font-weight: bold;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.BOLD, "font-weight: bold;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.MONOSPACE, "font-family: monospace;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.CODE, "font-family: monospace;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.CITATION, "font-style: italic;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.EMPHASIS, "font-style: italic;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.ITALIC, "font-style: italic;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.DELETED, "text-decoration: line-through;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.INSERTED, "text-decoration: underline;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.UNDERLINED, "text-decoration: underline;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.SUBSCRIPT, "vertical-align: sub;");
        spanTypeToCssStyles.put(DocumentBuilder.SpanType.SUPERSCRIPT, "vertical-align: super;");
    }

    public XslfoDocumentBuilder(Writer out) {
        super(out);
    }

    public XslfoDocumentBuilder(XmlStreamWriter writer) {
        super(writer);
    }

    @Override
    public void acronym(String text, String definition) {
        this.characters(text);
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        Map<String, String> attrs;
        BlockInfo thisInfo = new BlockInfo(type);
        BlockInfo parentBlock = this.findCurrentBlock();
        String cssStyles = blockTypeToCssStyles.get((Object)type);
        Map<String, String> map = attrs = cssStyles == null ? null : this.attributesFromCssStyles(cssStyles);
        if (attributes.getCssStyle() != null) {
            Map<String, String> otherAttrs = this.attributesFromCssStyles(attributes.getCssStyle());
            if (attrs == null) {
                attrs = otherAttrs;
            } else if (!otherAttrs.isEmpty()) {
                attrs.putAll(otherAttrs);
            }
        }
        switch (type) {
            case NUMERIC_LIST: 
            case BULLETED_LIST: 
            case DEFINITION_LIST: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-block");
                this.writer.writeAttribute("provisional-label-separation", "0.2em");
                this.writer.writeAttribute("provisional-distance-between-starts", "1.2em");
                if (this.findBlockInfo(DocumentBuilder.BlockType.LIST_ITEM) != null) break;
                this.addSpaceBefore();
                break;
            }
            case DEFINITION_ITEM: {
                if (parentBlock == null || parentBlock.type != DocumentBuilder.BlockType.DEFINITION_LIST) {
                    throw new IllegalStateException();
                }
                boolean firstItem = false;
                if (parentBlock.previousChild != null && parentBlock.previousChild.type == DocumentBuilder.BlockType.DEFINITION_TERM) {
                    firstItem = true;
                    this.writer.writeEndElement();
                    --parentBlock.size;
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item-body");
                    ++parentBlock.size;
                    this.writer.writeAttribute("start-indent", "body-start()");
                    this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "block");
                }
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                this.writer.writeAttribute("space-before", firstItem ? "1.2em" : "0.2em");
                break;
            }
            case DEFINITION_TERM: {
                if (parentBlock == null || parentBlock.type != DocumentBuilder.BlockType.DEFINITION_LIST) {
                    throw new IllegalStateException();
                }
                if (parentBlock.previousChild != null && parentBlock.previousChild.type == DocumentBuilder.BlockType.DEFINITION_ITEM) {
                    this.writer.writeEndElement();
                    --parentBlock.size;
                    this.writer.writeEndElement();
                    --parentBlock.size;
                }
                if (parentBlock.previousChild == null || parentBlock.previousChild.type != DocumentBuilder.BlockType.DEFINITION_TERM) {
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item");
                    this.writer.writeAttribute("space-before", "0.2em");
                    ++parentBlock.size;
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item-label");
                    this.writer.writeAttribute("end-indent", "label-end()");
                    ++parentBlock.size;
                }
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                if (attrs != null && attrs.containsKey(CSS_RULE_FONT_WEIGHT)) break;
                this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
                break;
            }
            case LIST_ITEM: {
                BlockInfo listInfo = this.getListBlockInfo();
                ++listInfo.listItemCount;
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item");
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item-label");
                this.writer.writeAttribute("end-indent", "label-end()");
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                this.configureFontSize(0);
                if (listInfo.type == DocumentBuilder.BlockType.NUMERIC_LIST) {
                    ListAttributes listAttributes;
                    if (attributes instanceof ListAttributes && (listAttributes = (ListAttributes)attributes).getStart() != null) {
                        try {
                            thisInfo.listItemCount = Integer.parseInt(listAttributes.getStart(), 10) - 1;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.writer.writeCharacters(String.format("%s.", listInfo.listItemCount));
                } else {
                    this.writer.writeCharacters(BULLET_CHARS, 0, BULLET_CHARS.length);
                }
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "list-item-body");
                ++thisInfo.size;
                this.writer.writeAttribute("start-indent", "body-start()");
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                this.configureFontSize(0);
                ++thisInfo.size;
                break;
            }
            case PARAGRAPH: 
            case FOOTNOTE: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                this.addSpaceBefore();
                break;
            }
            case CODE: 
            case PREFORMATTED: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                this.writer.writeAttribute("hyphenate", "false");
                this.writer.writeAttribute("white-space-collapse", "false");
                this.writer.writeAttribute("white-space-treatment", "preserve");
                this.writer.writeAttribute("linefeed-treatment", "preserve");
                this.writer.writeAttribute("text-align", "start");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                this.addSpaceBefore();
                break;
            }
            case QUOTE: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                this.indentLeftAndRight(attrs, "2em");
                this.addSpaceBefore();
                break;
            }
            case DIV: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs != null && attrs.containsKey(CSS_RULE_FONT_SIZE)) break;
                this.configureFontSize(0);
                break;
            }
            case TIP: 
            case WARNING: 
            case INFORMATION: 
            case NOTE: 
            case PANEL: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                this.indentLeftAndRight(attrs, "2em");
                this.addSpaceBefore();
                if (attributes.getTitle() == null && !this.configuration.panelText) break;
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (this.configuration.panelText) {
                    String text = null;
                    switch (type) {
                        case NOTE: {
                            text = Messages.getString("XslfoDocumentBuilder.Note");
                            break;
                        }
                        case TIP: {
                            text = Messages.getString("XslfoDocumentBuilder.Tip");
                            break;
                        }
                        case WARNING: {
                            text = Messages.getString("XslfoDocumentBuilder.Warning");
                        }
                    }
                    if (text != null) {
                        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "inline");
                        this.writer.writeAttribute(CSS_RULE_FONT_STYLE, "italic");
                        this.characters(text);
                        this.writer.writeEndElement();
                    }
                }
                if (attributes.getTitle() != null) {
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "inline");
                    this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
                    this.characters(attributes.getTitle());
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                break;
            }
            case TABLE: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "table");
                this.applyTableAttributes(attributes);
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "table-body");
                ++thisInfo.size;
                break;
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "table-cell");
                this.writer.writeAttribute("padding-left", "2pt");
                this.writer.writeAttribute("padding-right", "2pt");
                this.writer.writeAttribute("padding-top", "2pt");
                this.writer.writeAttribute("padding-bottom", "2pt");
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                if (attrs == null || !attrs.containsKey(CSS_RULE_FONT_SIZE)) {
                    this.configureFontSize(0);
                }
                ++thisInfo.size;
                break;
            }
            case TABLE_ROW: {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "table-row");
                break;
            }
            default: {
                throw new IllegalStateException(type.name());
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, String> ent : new TreeMap<String, String>(attrs).entrySet()) {
                this.writer.writeAttribute(ent.getKey(), ent.getValue());
            }
        }
        if (parentBlock != null) {
            parentBlock.previousChild = thisInfo;
        }
        this.elementInfos.push(thisInfo);
    }

    private void indentLeftAndRight(Map<String, String> attrs, String indentSize) {
        if (attrs == null || !attrs.containsKey("margin-left")) {
            this.writer.writeAttribute("margin-left", indentSize);
        }
        if (attrs == null || !attrs.containsKey("margin-right")) {
            this.writer.writeAttribute("margin-right", indentSize);
        }
    }

    private void configureFontSize(int level) {
        this.writer.writeAttribute(CSS_RULE_FONT_SIZE, String.format("%spt", Float.valueOf(this.configuration.fontSizes[level])));
    }

    private void addSpaceBefore() {
        this.writer.writeAttribute("space-before.optimum", "1em");
        this.writer.writeAttribute("space-before.minimum", "0.8em");
        this.writer.writeAttribute("space-before.maximum", "1.2em");
    }

    @Override
    public void endBlock() {
        ElementInfo elementInfo = this.elementInfos.pop();
        if (!(elementInfo instanceof BlockInfo)) {
            throw new IllegalStateException();
        }
        this.close(elementInfo);
    }

    private void close(ElementInfo elementInfo) {
        while (elementInfo.size > 0) {
            --elementInfo.size;
            this.writer.writeEndElement();
        }
    }

    private void applyTableAttributes(Attributes attributes) {
        boolean haveWidth = false;
        if (attributes instanceof TableAttributes) {
            TableAttributes tableAttributes = (TableAttributes)attributes;
            if (tableAttributes.getBgcolor() != null) {
                this.writer.writeAttribute(CSS_RULE_BACKGROUND_COLOR, tableAttributes.getBgcolor());
            }
            if (tableAttributes.getWidth() != null) {
                this.writer.writeAttribute("width", tableAttributes.getWidth());
                haveWidth = true;
            }
        }
        if (!haveWidth) {
            this.writer.writeAttribute("width", "auto");
        }
        this.writer.writeAttribute("border-collapse", "collapse");
    }

    private BlockInfo getListBlockInfo() {
        int x = this.elementInfos.size() - 1;
        while (x >= 0) {
            ElementInfo elementInfo = (ElementInfo)this.elementInfos.get(x);
            if (elementInfo instanceof BlockInfo) {
                BlockInfo info = (BlockInfo)elementInfo;
                if (info.type == DocumentBuilder.BlockType.BULLETED_LIST || info.type == DocumentBuilder.BlockType.NUMERIC_LIST || info.type == DocumentBuilder.BlockType.DEFINITION_LIST) {
                    return info;
                }
            }
            --x;
        }
        return null;
    }

    private BlockInfo findBlockInfo(DocumentBuilder.BlockType type) {
        int x = this.elementInfos.size() - 1;
        while (x >= 0) {
            ElementInfo elementInfo = (ElementInfo)this.elementInfos.get(x);
            if (elementInfo instanceof BlockInfo) {
                BlockInfo info = (BlockInfo)elementInfo;
                if (info.type == type) {
                    return info;
                }
            }
            --x;
        }
        return null;
    }

    private BlockInfo findCurrentBlock() {
        int x = this.elementInfos.size() - 1;
        while (x >= 0) {
            ElementInfo elementInfo = (ElementInfo)this.elementInfos.get(x);
            if (elementInfo instanceof BlockInfo) {
                return (BlockInfo)elementInfo;
            }
            --x;
        }
        return null;
    }

    @Override
    public void beginDocument() {
        this.writer.setDefaultNamespace("http://www.w3.org/1999/XSL/Format");
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "root");
        this.writer.writeNamespace("", "http://www.w3.org/1999/XSL/Format");
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "layout-master-set");
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "simple-page-master");
        this.writer.writeAttribute("master-name", "page-layout");
        this.writer.writeAttribute("page-height", String.format("%scm", Float.valueOf(this.configuration.pageHeight)));
        this.writer.writeAttribute("page-width", String.format("%scm", Float.valueOf(this.configuration.pageWidth)));
        this.writer.writeAttribute("margin", String.format("%scm", Float.valueOf(this.configuration.pageMargin)));
        this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "region-body");
        if (this.hasPageFooter()) {
            this.writer.writeAttribute("margin-bottom", "3cm");
        }
        if (this.hasPageFooter()) {
            this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "region-after");
            this.writer.writeAttribute("extent", "2cm");
            this.writer.writeAttribute("region-name", "footer");
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        if (this.configuration.title != null) {
            this.emitTitlePage();
        }
        this.openPage();
        this.openFlow(false);
    }

    private boolean hasPageFooter() {
        return this.configuration.copyright != null || this.configuration.pageNumbering;
    }

    private void emitTitlePage() {
        this.openPage();
        this.openFlow(true);
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
        if (this.configuration.title != null) {
            this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
            this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
            this.writer.writeAttribute(CSS_RULE_FONT_SIZE, "25pt");
            this.writer.writeAttribute("text-align", "center");
            this.writer.writeAttribute("space-before", "19pt");
            this.writer.writeCharacters(this.configuration.title);
            this.writer.writeEndElement();
        }
        if (this.configuration.subTitle != null) {
            this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
            this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
            this.writer.writeAttribute(CSS_RULE_FONT_SIZE, "18pt");
            this.writer.writeAttribute("text-align", "center");
            this.writer.writeAttribute("space-before", "15pt");
            this.writer.writeCharacters(this.configuration.subTitle);
            this.writer.writeEndElement();
        }
        if (this.configuration.version != null) {
            this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
            this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
            this.writer.writeAttribute(CSS_RULE_FONT_SIZE, "14pt");
            this.writer.writeAttribute("text-align", "center");
            this.writer.writeAttribute("space-before", "13pt");
            this.writer.writeCharacters(this.configuration.version);
            this.writer.writeEndElement();
        }
        if (this.configuration.date != null) {
            this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
            this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
            this.writer.writeAttribute(CSS_RULE_FONT_SIZE, "14pt");
            this.writer.writeAttribute("text-align", "center");
            this.writer.writeAttribute("space-before", "13pt");
            this.writer.writeCharacters(this.configuration.date);
            this.writer.writeEndElement();
        }
        this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "block");
        this.writer.writeAttribute("break-after", "page");
        this.writer.writeEndElement();
        this.closeFlow();
        this.closePage();
    }

    private void openFlow(boolean titlePage) {
        if (this.hasPageFooter()) {
            boolean hasPageNumber;
            boolean hasCopyrightText = this.configuration.copyright != null && this.configuration.copyright.trim().length() > 0;
            boolean bl = hasPageNumber = this.configuration.pageNumbering && !titlePage;
            if (hasCopyrightText || hasPageNumber) {
                this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "static-content");
                this.writer.writeAttribute("flow-name", "footer");
                if (hasCopyrightText) {
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                    this.configureFontSize(0);
                    this.writer.writeAttribute("text-align", "center");
                    this.writer.writeCharacters(this.configuration.copyright);
                    this.writer.writeEndElement();
                }
                if (hasPageNumber) {
                    this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
                    this.configureFontSize(0);
                    this.writer.writeAttribute("text-align", "outside");
                    this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "page-number");
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
        }
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "flow");
        this.writer.writeAttribute("flow-name", "xsl-region-body");
    }

    private void closeFlow() {
        this.writer.writeEndElement();
    }

    private void openPage() {
        this.pageOpen = true;
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "page-sequence");
        this.writer.writeAttribute("master-reference", "page-layout");
    }

    private void closePage() {
        this.writer.writeEndElement();
        this.pageOpen = false;
    }

    @Override
    public void endDocument() {
        if (this.pageOpen) {
            this.closeFlow();
            this.closePage();
        }
        this.writer.writeEndElement();
        this.writer.close();
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        if (level == 1 && ++this.h1Count > 1 && this.configuration.pageBreakOnHeading1) {
            if (this.pageOpen) {
                this.closeFlow();
                this.closePage();
            }
            this.openPage();
            this.openFlow(false);
        }
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "block");
        this.writer.writeAttribute("keep-with-next.within-column", "always");
        this.writer.writeAttribute(CSS_RULE_FONT_WEIGHT, "bold");
        this.configureFontSize(level);
        this.writer.writeAttribute("space-before.optimum", "10pt");
        this.writer.writeAttribute("space-before.minimum", "10pt * 0.8");
        this.writer.writeAttribute("space-before.maximum", "10pt * 1.2");
        if (attributes.getId() != null) {
            this.writer.writeAttribute("id", attributes.getId());
        }
    }

    @Override
    public void endHeading() {
        this.writer.writeEndElement();
    }

    private Map<String, String> attributesFromCssStyles(String styles) {
        if (styles == null) {
            return Collections.emptyMap();
        }
        List<CssRule> rules = new CssParser().parseBlockContent(styles);
        if (rules.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (CssRule rule : rules) {
            if (CSS_RULE_VERTICAL_ALIGN.equals(rule.name)) {
                if ("super".equals(rule.value)) {
                    mapping.put(CSS_RULE_FONT_SIZE, "75%");
                    mapping.put("baseline-shift", "super");
                    continue;
                }
                if (!"sub".equals(rule.value)) continue;
                mapping.put(CSS_RULE_FONT_SIZE, "75%");
                mapping.put("baseline-shift", "sub");
                continue;
            }
            if (!CSS_RULE_TEXT_DECORATION.equals(rule.name) && !CSS_RULE_FONT_FAMILY.equals(rule.name) && !CSS_RULE_FONT_SIZE.equals(rule.name) && !CSS_RULE_FONT_WEIGHT.equals(rule.name) && !CSS_RULE_FONT_STYLE.equals(rule.name) && !CSS_RULE_BACKGROUND_COLOR.equals(rule.name) && !CSS_RULE_COLOR.equals(rule.name)) continue;
            mapping.put(rule.name, rule.value);
        }
        return mapping;
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        Map<String, String> attrs;
        SpanInfo info = new SpanInfo(type);
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "inline");
        String cssStyles = spanTypeToCssStyles.get((Object)type);
        Map<String, String> map = attrs = cssStyles == null ? null : this.attributesFromCssStyles(cssStyles);
        if (attributes.getCssStyle() != null) {
            Map<String, String> otherAttrs = this.attributesFromCssStyles(attributes.getCssStyle());
            if (attrs == null) {
                attrs = otherAttrs;
            } else if (!otherAttrs.isEmpty()) {
                attrs.putAll(otherAttrs);
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, String> ent : new TreeMap<String, String>(attrs).entrySet()) {
                this.writer.writeAttribute(ent.getKey(), ent.getValue());
            }
        }
        this.elementInfos.push(info);
    }

    @Override
    public void endSpan() {
        ElementInfo elementInfo = this.elementInfos.pop();
        if (!(elementInfo instanceof SpanInfo)) {
            throw new IllegalStateException();
        }
        this.close(elementInfo);
    }

    @Override
    public void characters(String text) {
        this.writer.writeCharacters(text);
    }

    @Override
    public void charactersUnescaped(String literal) {
        Logger.getLogger(XslfoDocumentBuilder.class.getName()).warning("escaping XML literal");
        this.writer.writeCharacters(literal);
    }

    @Override
    public void entityReference(String entity) {
        this.writer.writeEntityRef(entity);
    }

    @Override
    public void image(Attributes attributes, String url) {
        this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "external-graphic");
        this.writer.writeAttribute("src", String.format("url(%s)", this.makeUrlAbsolute(url)));
        this.applyImageAttributes(attributes);
    }

    private void applyImageAttributes(Attributes attributes) {
        boolean sizeSpecified = false;
        boolean scaleToFit = true;
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            if (imageAttributes.getWidth() > 0) {
                sizeSpecified = true;
                this.writer.writeAttribute("width", String.format("%spx", imageAttributes.getWidth()));
            }
            if (imageAttributes.getHeight() > 0) {
                sizeSpecified = true;
                this.writer.writeAttribute("height", String.format("%spx", imageAttributes.getHeight()));
            }
        }
        if (!sizeSpecified) {
            this.writer.writeAttribute("width", "100%");
            this.writer.writeAttribute("content-height", "100%");
        }
        if (scaleToFit) {
            this.writer.writeAttribute("content-width", "scale-to-fit");
            this.writer.writeAttribute("scaling", "uniform");
        }
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "basic-link");
        String destinationUrl = this.makeUrlAbsolute(href);
        if (destinationUrl.startsWith("#")) {
            this.writer.writeAttribute("internal-destination", destinationUrl.substring(1));
        } else {
            this.writer.writeAttribute("external-destination", String.format("url(%s)", destinationUrl));
        }
        this.image(imageAttributes, imageUrl);
        this.writer.writeEndElement();
    }

    @Override
    public void lineBreak() {
        this.writer.writeEmptyElement("http://www.w3.org/1999/XSL/Format", "block");
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "basic-link");
        String destinationUrl = this.makeUrlAbsolute(hrefOrHashName);
        boolean internal = destinationUrl.startsWith("#");
        if (this.configuration.underlineLinks) {
            this.writer.writeAttribute(CSS_RULE_TEXT_DECORATION, "underline");
        }
        if (internal) {
            this.writer.writeAttribute("internal-destination", destinationUrl.substring(1));
        } else {
            this.writer.writeAttribute("external-destination", String.format("url(%s)", destinationUrl));
        }
        this.characters(text);
        this.writer.writeEndElement();
        if (this.configuration.showExternalLinks && !internal) {
            this.characters(Messages.getString("XslfoDocumentBuilder.beforeLink"));
            this.writer.writeStartElement("http://www.w3.org/1999/XSL/Format", "basic-link");
            this.writer.writeAttribute("external-destination", String.format("url(%s)", destinationUrl));
            this.characters(destinationUrl);
            this.characters(Messages.getString("XslfoDocumentBuilder.afterLink"));
            this.writer.writeEndElement();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        this.configuration = configuration;
    }

    private static class BlockInfo
    extends ElementInfo {
        final DocumentBuilder.BlockType type;
        int listItemCount;
        BlockInfo previousChild;

        public BlockInfo(DocumentBuilder.BlockType type) {
            this.type = type;
        }
    }

    public static class Configuration
    implements Cloneable {
        private float[] fontSizes = new float[]{12.0f, 18.0f, 15.0f, 13.2f, 12.0f, 10.4f, 8.0f};
        private final float[] fontSizeMultipliers = new float[]{1.0f, 1.5f, 1.25f, 1.1f, 1.0f, 0.83f, 0.67f};
        private boolean pageBreakOnHeading1 = true;
        private boolean showExternalLinks = true;
        private boolean underlineLinks = false;
        private boolean panelText = true;
        private String title;
        private String subTitle;
        private String version;
        private String date;
        private String author;
        private String copyright;
        private boolean pageNumbering = true;
        private float pageMargin = 1.5f;
        private float pageHeight = 29.7f;
        private float pageWidth = 21.0f;

        public Configuration() {
            this.setFontSize(10.0f);
        }

        public Configuration clone() {
            try {
                return (Configuration)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public void setFontSize(float fontSize) {
            this.fontSizes = new float[this.fontSizeMultipliers.length];
            int x = 0;
            while (x < this.fontSizeMultipliers.length) {
                this.fontSizes[x] = this.fontSizeMultipliers[x] * fontSize;
                ++x;
            }
        }

        public float getFontSize() {
            return this.fontSizes[0];
        }

        public void setFontSizeMultipliers(float[] fontSizeMultipliers) {
            if (fontSizeMultipliers.length != 7) {
                throw new IllegalArgumentException();
            }
            int x = 0;
            while (x < fontSizeMultipliers.length) {
                if ((double)fontSizeMultipliers[x] < 0.2) {
                    throw new IllegalArgumentException();
                }
                ++x;
            }
            System.arraycopy(fontSizeMultipliers, 0, this.fontSizeMultipliers, 0, 7);
        }

        public float[] getFontSizeMultipliers() {
            float[] values = new float[7];
            System.arraycopy(this.fontSizeMultipliers, 0, values, 0, 7);
            return values;
        }

        public boolean isShowExternalLinks() {
            return this.showExternalLinks;
        }

        public void setShowExternalLinks(boolean showExternalLinks) {
            this.showExternalLinks = showExternalLinks;
        }

        public boolean isUnderlineLinks() {
            return this.underlineLinks;
        }

        public void setUnderlineLinks(boolean underlineLinks) {
            this.underlineLinks = underlineLinks;
        }

        public boolean isPageBreakOnHeading1() {
            return this.pageBreakOnHeading1;
        }

        public void setPageBreakOnHeading1(boolean pageBreakOnHeading1) {
            this.pageBreakOnHeading1 = pageBreakOnHeading1;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getSubTitle() {
            return this.subTitle;
        }

        public void setSubTitle(String subTitle) {
            this.subTitle = subTitle;
        }

        public boolean isPanelText() {
            return this.panelText;
        }

        public void setPanelText(boolean panelText) {
            this.panelText = panelText;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        public boolean isPageNumbering() {
            return this.pageNumbering;
        }

        public void setPageNumbering(boolean pageNumbering) {
            this.pageNumbering = pageNumbering;
        }

        public float getPageMargin() {
            return this.pageMargin;
        }

        public void setPageMargin(float pageMargin) {
            this.pageMargin = pageMargin;
        }

        public float getPageHeight() {
            return this.pageHeight;
        }

        public void setPageHeight(float pageHeight) {
            this.pageHeight = pageHeight;
        }

        public float getPageWidth() {
            return this.pageWidth;
        }

        public void setPageWidth(float pageWidth) {
            this.pageWidth = pageWidth;
        }
    }

    private static class ElementInfo {
        int size = 1;

        private ElementInfo() {
        }
    }

    private static class SpanInfo
    extends ElementInfo {
        final DocumentBuilder.SpanType type;

        public SpanInfo(DocumentBuilder.SpanType type) {
            this.type = type;
        }
    }
}

