/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.FileFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FileSelectionDialog
extends ElementTreeSelectionDialog {
    private FileFilter fFilter;
    private String fFilterMessage;
    private boolean fShowAll = false;
    private static final String DIALOG_SETTING = "AntPropertiesFileSelectionDialog.showAll";
    private static final String LAST_CONTAINER = "AntPropertiesFileSelectionDialog.lastContainer";

    public FileSelectionDialog(Shell parent, List<IFile> files, String title, String message, String filterExtension, String filterMessage) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.setTitle(title);
        this.setMessage(message);
        this.fFilter = new FileFilter(files, filterExtension);
        this.fFilterMessage = filterMessage;
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        ISelectionStatusValidator validator = selection -> {
            if (selection.length == 0) {
                return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IFile)) {
                    return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
                }
                ++i;
            }
            return new Status(0, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
        };
        this.setValidator(validator);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        final Button button = new Button(result, 32);
        button.setText(this.fFilterMessage);
        button.setFont(parent.getFont());
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FileSelectionDialog.class)).getDialogSettings();
        this.fShowAll = settings.getBoolean(DIALOG_SETTING);
        String lastPath = settings.get(LAST_CONTAINER);
        if (lastPath != null) {
            IPath path = Path.fromPortableString((String)lastPath);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            this.setInitialSelection(resource);
        }
        this.fFilter.considerExtension(!this.fShowAll);
        this.getTreeViewer().addFilter((ViewerFilter)this.fFilter);
        if (!this.fShowAll) {
            button.setSelection(true);
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (button.getSelection()) {
                    FileSelectionDialog.this.fShowAll = false;
                } else {
                    FileSelectionDialog.this.fShowAll = true;
                }
                FileSelectionDialog.this.fFilter.considerExtension(!FileSelectionDialog.this.fShowAll);
                FileSelectionDialog.this.getTreeViewer().refresh();
            }
        });
        FileSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    public boolean close() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FileSelectionDialog.class)).getDialogSettings();
        settings.put(DIALOG_SETTING, this.fShowAll);
        Object[] result = this.getResult();
        if (result != null && result.length > 0) {
            settings.put(LAST_CONTAINER, ((IResource)result[0]).getParent().getFullPath().toPortableString());
        }
        return super.close();
    }
}

