/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.ModelUtils;
import org.eclipse.buildship.core.internal.workspace.ConnectionAwareLauncherProxy;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class DefaultModelProvider
implements ModelProvider {
    private final BuildConfiguration buildConfiguration;
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().build();

    public DefaultModelProvider(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    @Override
    public <T> T fetchModel(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        GradleProgressAttributes progressAttributes = this.createProgressAttributes(tokenSource, monitor);
        ModelBuilder<T> builder = ConnectionAwareLauncherProxy.newModelBuilder(model, this.buildConfiguration.toGradleArguments(), progressAttributes);
        return DefaultModelProvider.injectCompatibilityModel(this.executeModelBuilder(builder, strategy, model));
    }

    @Override
    public <T> Collection<T> fetchModels(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        GradleProgressAttributes attributes = this.createProgressAttributes(tokenSource, monitor);
        if (this.supportsCompositeBuilds(tokenSource, monitor)) {
            BuildActionExecuter<Collection<T>> executer = ConnectionAwareLauncherProxy.newCompositeModelQueryExecuter(model, this.buildConfiguration.toGradleArguments(), attributes);
            Collection<T> result = this.executeBuildActionExecuter(executer, strategy, model);
            return DefaultModelProvider.injectCompatibilityModel(model, result);
        }
        ModelBuilder<T> builder = ConnectionAwareLauncherProxy.newModelBuilder(model, this.buildConfiguration.toGradleArguments(), attributes);
        ImmutableList result = ImmutableList.of(this.executeModelBuilder(builder, strategy, model));
        return DefaultModelProvider.injectCompatibilityModel(model, result);
    }

    private GradleProgressAttributes createProgressAttributes(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return GradleProgressAttributes.builder(tokenSource, monitor).forBackgroundProcess().withFilteredProgress().build();
    }

    private static <T> T injectCompatibilityModel(T model) {
        if (model instanceof EclipseProject) {
            return (T)ModelUtils.createCompatibilityModel((EclipseProject)model);
        }
        return model;
    }

    private static <T> Collection<T> injectCompatibilityModel(Class<T> modelClass, Collection<T> models) {
        if (modelClass == EclipseProject.class) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (T model : models) {
                result.add((Object)ModelUtils.createCompatibilityModel((EclipseProject)model));
            }
            return result.build();
        }
        return models;
    }

    private <T> T executeBuildActionExecuter(final BuildActionExecuter<T> executer, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return this.executeOperation(new Supplier<T>(){

            public T get() {
                return executer.run();
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> T executeModelBuilder(final ModelBuilder<T> builder, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return this.executeOperation(new Supplier<T>(){

            public T get() {
                return builder.get();
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> T executeOperation(final Supplier<T> operation, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return (T)result;
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        Object value = this.getFromCache(cacheKey, new Callable<T>(){

            @Override
            public T call() {
                Object model = operation.get();
                return model;
            }
        });
        return (T)value;
    }

    private <U> U getFromCache(Class<?> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return (U)result;
        }
        catch (Exception e) {
            if (e instanceof UncheckedExecutionException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private boolean supportsCompositeBuilds(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        BuildEnvironment buildEnvironment = this.fetchModel(BuildEnvironment.class, FetchStrategy.FORCE_RELOAD, tokenSource, monitor);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("3.3")) >= 0;
    }
}

