/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.marker;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

final class ErrorMarkerLocation {
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile("Build file '(.+)' line: (\\d+).*");
    private final IResource resource;
    private final int lineNumber;

    public ErrorMarkerLocation(IResource resource) {
        this(resource, 0);
    }

    public ErrorMarkerLocation(IResource resource, int lineNumber) {
        this.resource = resource;
        this.lineNumber = lineNumber;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static ErrorMarkerLocation findErrorLocation(GradleBuild gradleBuild, Throwable t) {
        IResource resource;
        Matcher errorLocationInStackTrace = ErrorMarkerLocation.tryFindStackTraceErrorLocation(t);
        if (errorLocationInStackTrace != null && (resource = ErrorMarkerLocation.tryFindWorkspaceFile(gradleBuild, new Path(errorLocationInStackTrace.group(1)))) != null) {
            int lineNumber = Integer.parseInt(errorLocationInStackTrace.group(2));
            return new ErrorMarkerLocation(resource, lineNumber);
        }
        return new ErrorMarkerLocation(ErrorMarkerLocation.calculateFallbackLocation(gradleBuild));
    }

    private static Matcher tryFindStackTraceErrorLocation(Throwable t) {
        if (t == null || t.getMessage() == null) {
            return null;
        }
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(t.getMessage());
        if (!matcher.find()) {
            return ErrorMarkerLocation.tryFindStackTraceErrorLocation(t.getCause());
        }
        return matcher;
    }

    private static IResource tryFindWorkspaceFile(GradleBuild gradleBuild, Path filePath) {
        for (IProject project : ErrorMarkerLocation.getWorkspaceProjectsFor(gradleBuild)) {
            IFile file;
            IPath projectLocation = project.getLocation();
            if (!projectLocation.isPrefixOf((IPath)filePath) || !(file = project.getFile(filePath.makeRelativeTo(projectLocation))).exists()) continue;
            return file;
        }
        return null;
    }

    private static IResource calculateFallbackLocation(GradleBuild gradleBuild) {
        Optional<IProject> projectOrNull = CorePlugin.workspaceOperations().findProjectByLocation(gradleBuild.getBuildConfig().getRootProjectDirectory());
        if (projectOrNull.isPresent()) {
            IFile buildScript;
            PersistentModel persistentModel;
            IProject project = (IProject)projectOrNull.get();
            if (GradleProjectNature.isPresentOn(project) && (persistentModel = CorePlugin.modelPersistence().loadModel(project)).isPresent() && (buildScript = project.getFile(persistentModel.getbuildScriptPath())).exists()) {
                return buildScript;
            }
            return project;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static Iterable<IProject> getWorkspaceProjectsFor(final GradleBuild gradleBuild) {
        return FluentIterable.from(CorePlugin.workspaceOperations().getAllProjects()).filter((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                if (!GradleProjectNature.isPresentOn(project)) {
                    return false;
                }
                ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project);
                if (projectConfiguration == null) {
                    return false;
                }
                return projectConfiguration.getBuildConfiguration().equals(gradleBuild.getBuildConfig());
            }
        }).toList();
    }
}

