/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.IdeAttachedProjectConnection;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.operation.BaseToolingApiOperation;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;

public final class DefaultGradleBuild
implements org.eclipse.buildship.core.GradleBuild {
    private final GradleBuild gradleBuild;

    public DefaultGradleBuild(IProject project) {
        this.gradleBuild = (GradleBuild)CorePlugin.gradleWorkspaceManager().getGradleBuild(project).orNull();
    }

    public DefaultGradleBuild(org.eclipse.buildship.core.BuildConfiguration configuration) {
        BuildConfiguration buildConfiguration = CorePlugin.configurationManager().createBuildConfiguration(configuration.getRootProjectDirectory(), configuration.isOverrideWorkspaceConfiguration(), configuration.getGradleDistribution(), configuration.getGradleUserHome().orElse(null), configuration.isBuildScansEnabled(), configuration.isOfflineMode(), configuration.isAutoSync());
        this.gradleBuild = CorePlugin.gradleWorkspaceManager().getGradleBuild(buildConfiguration);
    }

    @Override
    public SynchronizationResult synchronize(IProgressMonitor monitor) {
        return this.synchronize(NewProjectHandler.IMPORT_AND_MERGE, GradleConnector.newCancellationTokenSource(), monitor);
    }

    public SynchronizationResult synchronize(NewProjectHandler newProjectHandler, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        SynchronizeOperation operation = new SynchronizeOperation(newProjectHandler);
        try {
            CorePlugin.operationManager().run(operation, tokenSource, monitor);
            return DefaultGradleBuild.newSynchronizationResult(Status.OK_STATUS);
        }
        catch (CoreException e) {
            return DefaultGradleBuild.newSynchronizationResult(e.getStatus());
        }
    }

    private static SynchronizationResult newSynchronizationResult(final IStatus result) {
        return new SynchronizationResult(){

            @Override
            public IStatus getStatus() {
                return result;
            }
        };
    }

    @Override
    public <T> T withConnection(Function<ProjectConnection, ? extends T> action, IProgressMonitor monitor) throws Exception {
        Preconditions.checkNotNull(action);
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        GradleConnectionOperation<? extends T> operation = new GradleConnectionOperation<T>(action);
        try {
            CorePlugin.operationManager().run(operation, GradleConnector.newCancellationTokenSource(), monitor);
            return (T)((GradleConnectionOperation)operation).result;
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof Exception) {
                throw (Exception)e.getStatus().getException();
            }
            throw e;
        }
    }

    private class GradleConnectionOperation<T>
    extends BaseToolingApiOperation {
        private final Function<ProjectConnection, ? extends T> action;
        private T result;

        public GradleConnectionOperation(Function<ProjectConnection, ? extends T> action) {
            super("Connecting to Gradle");
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
            try (ProjectConnection connection = IdeAttachedProjectConnection.newInstance(tokenSource, this.getGradleArguments(), monitor);){
                this.result = this.action.apply(connection);
            }
        }

        private GradleArguments getGradleArguments() {
            BuildConfiguration config = DefaultGradleBuild.this.gradleBuild.getBuildConfig();
            return config.toGradleArguments();
        }

        @Override
        public ISchedulingRule getRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }

    private class SynchronizeOperation
    extends BaseToolingApiOperation {
        private final NewProjectHandler newProjectHandler;

        public SynchronizeOperation(NewProjectHandler newProjectHandler) {
            super("Synchronize project " + DefaultGradleBuild.this.gradleBuild.getBuildConfig().getRootProjectDirectory().getName());
            this.newProjectHandler = newProjectHandler;
        }

        @Override
        public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
            DefaultGradleBuild.this.gradleBuild.synchronize(this.newProjectHandler, tokenSource, monitor);
        }

        @Override
        public ISchedulingRule getRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }
}

