/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildPlanRequest;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshRequest;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunnableWithResult;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunner;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;

public class RefreshSession {
    private final BuildServer server;

    public RefreshSession(IBuildServer server) {
        this.server = ((BuildServer)server).createWorkingCopy();
    }

    public BuildPlan getPlanById(List<IBuildPlan> plans, String id) {
        if (id != null) {
            for (IBuildPlan plan : plans) {
                if (!id.equals(plan.getId())) continue;
                return (BuildPlan)plan;
            }
        }
        return null;
    }

    private boolean isStale(IBuildPlan oldPlan, BuildPlan newPlan, IOperationMonitor monitor) {
        if (oldPlan.getStatus() != newPlan.getStatus() || oldPlan.getState() != newPlan.getState()) {
            return true;
        }
        if (oldPlan.getLastBuild() != null && newPlan.getLastBuild() != null) {
            return this.isStale(oldPlan.getLastBuild(), newPlan.getLastBuild(), monitor);
        }
        return oldPlan.getLastBuild() == null && newPlan.getLastBuild() == null;
    }

    private boolean isStale(IBuild oldBuild, IBuild newBuild, IOperationMonitor monitor) {
        return oldBuild.getBuildNumber() != newBuild.getBuildNumber();
    }

    protected void markStale(RefreshRequest request, BuildPlan newPlan) {
        request.stalePlans.add(newPlan);
    }

    public void refresh(RefreshRequest request, IOperationMonitor monitor) throws CoreException {
        request.stalePlans = Collections.synchronizedList(new ArrayList());
        this.refreshPlans(request, monitor);
        if (request.plansToRefresh != null) {
            request.stalePlans.clear();
            request.stalePlans.addAll(request.plansToRefresh);
        }
        for (IBuildPlan plan : request.stalePlans) {
            GetBuildsRequest buildRequest = new GetBuildsRequest(plan, GetBuildsRequest.Kind.LAST);
            this.refreshBuilds(request, buildRequest, monitor);
        }
    }

    public void refreshBuilds(final RefreshRequest request, final GetBuildsRequest buildRequest, final IOperationMonitor monitor) throws CoreException {
        final List<IBuild> result = BuildRunner.run(new BuildRunnableWithResult<List<IBuild>>(){

            @Override
            public List<IBuild> run() throws CoreException {
                return RefreshSession.this.server.getBehaviour().getBuilds(buildRequest, monitor);
            }
        });
        if (result == null) {
            return;
        }
        final BuildServer original = this.server.getOriginal();
        original.getLoader().getRealm().syncExec(new Runnable(){

            @Override
            public void run() {
                Date refreshDate = new Date();
                for (IBuildPlan modelPlan : request.getModel().getPlans()) {
                    if (modelPlan.getServer() != original || !modelPlan.getId().equals(buildRequest.getPlan().getId())) continue;
                    RefreshSession.this.updateLastBuild(request, modelPlan, (IBuild)result.get(0), refreshDate);
                }
            }
        });
    }

    private void updateLastBuild(RefreshRequest request, IBuildPlan plan, IBuild build, Date refreshDate) {
        if (plan.getLastBuild() != null) {
            request.getModel().getBuilds().remove(plan.getLastBuild());
        }
        plan.setLastBuild(build);
        build.setPlan(plan);
        build.setServer(plan.getServer());
        build.setRefreshDate(refreshDate);
        request.getModel().getBuilds().add(build);
    }

    public void refreshPlans(final RefreshRequest request, final IOperationMonitor monitor) throws CoreException {
        final BuildServer original = this.server.getOriginal();
        final AtomicReference input = new AtomicReference();
        if (request.plansToRefresh != null) {
            ArrayList<String> planIds = new ArrayList<String>();
            for (IBuildPlan plan : request.plansToRefresh) {
                planIds.add(plan.getId());
            }
            input.set(planIds);
        } else {
            original.getLoader().getRealm().syncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> planIds = new ArrayList<String>();
                    for (IBuildPlan oldPlan : request.getModel().getPlans()) {
                        if (oldPlan.getServer() != original) continue;
                        planIds.add(oldPlan.getId());
                    }
                    input.set(planIds);
                }
            });
        }
        final List<IBuildPlan> result = BuildRunner.run(new BuildRunnableWithResult<List<IBuildPlan>>(){

            @Override
            public List<IBuildPlan> run() throws CoreException {
                BuildPlanRequest planRequest = new BuildPlanRequest((List)input.get());
                List<IBuildPlan> result = RefreshSession.this.server.getBehaviour().getPlans(planRequest, monitor);
                result.stream().forEach(p -> p.setServer(RefreshSession.this.server.getOriginal()));
                return result;
            }
        });
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", "Server did not provide any plans."));
        }
        original.getLoader().getRealm().syncExec(new Runnable(){

            @Override
            public void run() {
                Date refreshDate = new Date();
                original.setRefreshDate(refreshDate);
                for (IBuildPlan oldPlan : request.getModel().getPlans()) {
                    if (oldPlan.getServer() != original) continue;
                    BuildPlan newPlan = RefreshSession.this.getPlanById(result, oldPlan.getId());
                    if (newPlan != null) {
                        newPlan.setRefreshDate(refreshDate);
                        RefreshSession.this.update(request, oldPlan, newPlan, monitor);
                        continue;
                    }
                    ((BuildPlan)oldPlan).setOperationStatus((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", "The plan does not exist."));
                }
            }
        });
    }

    protected void update(RefreshRequest request, IBuildPlan oldPlan, BuildPlan newPlan, IOperationMonitor monitor) {
        boolean stale = this.isStale(oldPlan, newPlan, monitor);
        if (stale || !monitor.hasFlag(IOperationMonitor.OperationFlag.BACKGROUND)) {
            this.markStale(request, newPlan);
        }
        ((BuildPlan)oldPlan).merge(newPlan);
        if (stale && newPlan.getLastBuild() != null) {
            this.updateLastBuild(request, oldPlan, newPlan.getLastBuild(), new Date());
        }
    }
}

