/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;
import org.eclipse.jgit.internal.transport.sshd.JGitUserInteraction;
import org.eclipse.jgit.internal.transport.sshd.KnownHostEntryReader;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSshServerKeyVerifier
implements ServerKeyVerifier,
ServerKeyLookup {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSshServerKeyVerifier.class);
    private static final String MARKER_REVOKED = "revoked";
    private final boolean askAboutNewFile;
    private final Map<Path, HostKeyFile> knownHostsFiles = new ConcurrentHashMap<Path, HostKeyFile>();
    private final List<HostKeyFile> defaultFiles = new ArrayList<HostKeyFile>();

    public OpenSshServerKeyVerifier(boolean askAboutNewFile, List<Path> defaultFiles) {
        if (defaultFiles != null) {
            for (Path file : defaultFiles) {
                HostKeyFile newFile = new HostKeyFile(file);
                this.knownHostsFiles.put(file, newFile);
                this.defaultFiles.add(newFile);
            }
        }
        this.askAboutNewFile = askAboutNewFile;
    }

    private List<HostKeyFile> getFilesToUse(ClientSession session) {
        List<HostKeyFile> userFiles;
        HostConfigEntry entry;
        List<HostKeyFile> filesToUse = this.defaultFiles;
        if (session instanceof JGitClientSession && (entry = ((JGitClientSession)session).getHostConfigEntry()) instanceof JGitHostConfigEntry && !(userFiles = this.addUserHostKeyFiles(((JGitHostConfigEntry)entry).getMultiValuedOptions().get("UserKnownHostsFile"))).isEmpty()) {
            filesToUse = userFiles;
        }
        return filesToUse;
    }

    @Override
    public List<KnownHostsServerKeyVerifier.HostEntryPair> lookup(ClientSession session, SocketAddress remote) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(session);
        HostKeyHelper helper = new HostKeyHelper();
        ArrayList<KnownHostsServerKeyVerifier.HostEntryPair> result = new ArrayList<KnownHostsServerKeyVerifier.HostEntryPair>();
        Collection<SshdSocketAddress> candidates = helper.resolveHostNetworkIdentities(session, remote);
        for (HostKeyFile file : filesToUse) {
            Iterator iterator = file.get().iterator();
            block1: while (iterator.hasNext()) {
                KnownHostsServerKeyVerifier.HostEntryPair current = (KnownHostsServerKeyVerifier.HostEntryPair)iterator.next();
                KnownHostEntry entry = current.getHostEntry();
                for (SshdSocketAddress host : candidates) {
                    if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                    result.add(current);
                    continue block1;
                }
            }
        }
        return result;
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(clientSession);
        AskUser ask = new AskUser();
        KnownHostsServerKeyVerifier.HostEntryPair[] modified = new KnownHostsServerKeyVerifier.HostEntryPair[1];
        Path path = null;
        HostKeyHelper helper = new HostKeyHelper();
        for (HostKeyFile file : filesToUse) {
            try {
                if (this.find(clientSession, remoteAddress, serverKey, (List<KnownHostsServerKeyVerifier.HostEntryPair>)file.get(), modified, helper)) {
                    return true;
                }
            }
            catch (RevokedKeyException e) {
                ask.revokedKey(clientSession, remoteAddress, serverKey, file.getPath());
                return false;
            }
            if (path != null || modified[0] == null) continue;
            path = file.getPath();
        }
        if (modified[0] != null) {
            ModifiedKeyHandling toDo = ask.acceptModifiedServerKey(clientSession, remoteAddress, modified[0].getServerKey(), serverKey, path);
            if (toDo == ModifiedKeyHandling.ALLOW_AND_STORE) {
                try {
                    this.updateModifiedServerKey(clientSession, remoteAddress, serverKey, modified[0], path, helper);
                    this.knownHostsFiles.get(path).resetReloadAttributes();
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path));
                }
            }
            return toDo != ModifiedKeyHandling.DENY;
        }
        if (ask.acceptUnknownKey(clientSession, remoteAddress, serverKey)) {
            if (!filesToUse.isEmpty()) {
                HostKeyFile toUpdate = filesToUse.get(0);
                path = toUpdate.getPath();
                try {
                    this.updateKnownHostsFile(clientSession, remoteAddress, serverKey, path, helper);
                    toUpdate.resetReloadAttributes();
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path));
                }
            }
            return true;
        }
        return false;
    }

    private boolean find(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, List<KnownHostsServerKeyVerifier.HostEntryPair> entries, KnownHostsServerKeyVerifier.HostEntryPair[] modified, HostKeyHelper helper) throws RevokedKeyException {
        Collection<SshdSocketAddress> candidates = helper.resolveHostNetworkIdentities(clientSession, remoteAddress);
        for (KnownHostsServerKeyVerifier.HostEntryPair current : entries) {
            KnownHostEntry entry = current.getHostEntry();
            for (SshdSocketAddress host : candidates) {
                if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                boolean isRevoked = MARKER_REVOKED.equals(entry.getMarker());
                if (KeyUtils.compareKeys((PublicKey)serverKey, (PublicKey)current.getServerKey())) {
                    if (isRevoked) {
                        throw new RevokedKeyException();
                    }
                    modified[0] = null;
                    return true;
                }
                if (isRevoked) continue;
                modified[0] = current;
            }
        }
        return false;
    }

    private List<HostKeyFile> addUserHostKeyFiles(List<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HostKeyFile> userFiles = new ArrayList<HostKeyFile>();
        for (String name : fileNames) {
            try {
                Path path = Paths.get(name, new String[0]);
                HostKeyFile file = this.knownHostsFiles.computeIfAbsent(path, p -> new HostKeyFile(path));
                userFiles.add(file);
            }
            catch (InvalidPathException e) {
                LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidPath, name));
            }
        }
        return userFiles;
    }

    private void updateKnownHostsFile(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Path path, HostKeyHelper updater) throws IOException {
        LockFile lock;
        Object uri;
        KnownHostEntry entry = updater.prepareKnownHostEntry(clientSession, remoteAddress, serverKey);
        if (entry == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0]) && this.askAboutNewFile) {
            CredentialsProvider provider = OpenSshServerKeyVerifier.getCredentialsProvider(clientSession);
            if (provider == null) {
                return;
            }
            uri = new URIish().setPath(path.toString());
            if (!OpenSshServerKeyVerifier.askUser(provider, (URIish)uri, MessageFormat.format(SshdText.get().knownHostsUserAskCreationPrompt, path), MessageFormat.format(SshdText.get().knownHostsUserAskCreationMsg, path))) {
                return;
            }
        }
        if ((lock = new LockFile(path.toFile())).lockForAppend()) {
            try {
                uri = null;
                Object var9_11 = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));){
                    writer.newLine();
                    writer.write(entry.getConfigLine());
                    writer.newLine();
                }
                catch (Throwable throwable) {
                    if (uri == null) {
                        uri = throwable;
                    } else if (uri != throwable) {
                        ((Throwable)uri).addSuppressed(throwable);
                    }
                    throw uri;
                }
                lock.commit();
            }
            catch (IOException e) {
                lock.unlock();
                throw e;
            }
        }
        LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, KnownHostsServerKeyVerifier.HostEntryPair entry, Path path, HostKeyHelper helper) throws IOException {
        String oldLine;
        KnownHostEntry hostEntry = entry.getHostEntry();
        String newLine = helper.prepareModifiedServerKeyLine(clientSession, remoteAddress, hostEntry, oldLine = hostEntry.getConfigLine(), entry.getServerKey(), serverKey);
        if (newLine == null) return;
        if (newLine.isEmpty()) {
            return;
        }
        if (oldLine == null) return;
        if (oldLine.isEmpty()) return;
        if (newLine.equals(oldLine)) {
            return;
        }
        LockFile lock = new LockFile(path.toFile());
        if (!lock.lock()) {
            LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path));
            return;
        }
        try {
            block21: {
                Throwable throwable = null;
                Object var12_14 = null;
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));
                    try {
                        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                            String line;
                            boolean done = false;
                            while ((line = reader.readLine()) != null) {
                                String toWrite = line;
                                if (!done) {
                                    String toTest;
                                    int pos = line.indexOf(35);
                                    String string = toTest = pos < 0 ? line : line.substring(0, pos);
                                    if (toTest.trim().equals(oldLine)) {
                                        toWrite = newLine;
                                        done = true;
                                    }
                                }
                                writer.write(toWrite);
                                writer.newLine();
                            }
                        }
                        if (writer == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (writer == null) throw throwable;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            lock.commit();
            return;
        }
        catch (IOException e) {
            lock.unlock();
            throw e;
        }
    }

    private static CredentialsProvider getCredentialsProvider(ClientSession session) {
        if (session instanceof JGitClientSession) {
            return ((JGitClientSession)session).getCredentialsProvider();
        }
        return null;
    }

    private static boolean askUser(CredentialsProvider provider, URIish uri, String prompt, String ... messages) {
        ArrayList<Object> items = new ArrayList<Object>(messages.length + 1);
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            items.add(new CredentialItem.InformationalMessage(message));
            ++n2;
        }
        if (prompt != null) {
            CredentialItem.YesNoType answer = new CredentialItem.YesNoType(prompt);
            items.add(answer);
            return provider.get(uri, items) && answer.getValue();
        }
        return provider.get(uri, items);
    }

    private static class AskUser {
        private AskUser() {
        }

        private Check checkMode(ClientSession session, SocketAddress remoteAddress, boolean changed) {
            block19: {
                if (!(remoteAddress instanceof InetSocketAddress)) {
                    return Check.DENY;
                }
                if (!(session instanceof JGitClientSession)) break block19;
                HostConfigEntry entry = ((JGitClientSession)session).getHostConfigEntry();
                String value = entry.getProperty("StrictHostKeyChecking", "ask");
                switch (value.toLowerCase(Locale.ROOT)) {
                    case "on": 
                    case "yes": {
                        return Check.DENY;
                    }
                    case "no": 
                    case "off": {
                        return Check.ALLOW;
                    }
                    case "accept-new": {
                        return changed ? Check.DENY : Check.ALLOW;
                    }
                }
            }
            if (OpenSshServerKeyVerifier.getCredentialsProvider(session) == null) {
                return Check.DENY;
            }
            return Check.ASK;
        }

        public void revokedKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Path path) {
            CredentialsProvider provider = OpenSshServerKeyVerifier.getCredentialsProvider(clientSession);
            if (provider == null) {
                return;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            URIish uri = JGitUserInteraction.toURI(clientSession.getUsername(), remote);
            String sha256 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)serverKey);
            String md5 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)serverKey);
            String keyAlgorithm = serverKey.getAlgorithm();
            OpenSshServerKeyVerifier.askUser(provider, uri, null, new String[]{MessageFormat.format(SshdText.get().knownHostsRevokedKeyMsg, remote.getHostString(), path), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256});
        }

        public boolean acceptUnknownKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
            Check check = this.checkMode(clientSession, remoteAddress, false);
            if (check != Check.ASK) {
                return check == Check.ALLOW;
            }
            CredentialsProvider provider = OpenSshServerKeyVerifier.getCredentialsProvider(clientSession);
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            String sha256 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)serverKey);
            String md5 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)serverKey);
            String keyAlgorithm = serverKey.getAlgorithm();
            String remoteHost = remote.getHostString();
            URIish uri = JGitUserInteraction.toURI(clientSession.getUsername(), remote);
            String prompt = SshdText.get().knownHostsUnknownKeyPrompt;
            return OpenSshServerKeyVerifier.askUser(provider, uri, prompt, new String[]{MessageFormat.format(SshdText.get().knownHostsUnknownKeyMsg, remoteHost), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256});
        }

        public ModifiedKeyHandling acceptModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey expected, PublicKey actual, Path path) {
            Check check = this.checkMode(clientSession, remoteAddress, true);
            if (check == Check.ALLOW) {
                return ModifiedKeyHandling.ALLOW;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            String keyAlgorithm = actual.getAlgorithm();
            String remoteHost = remote.getHostString();
            URIish uri = JGitUserInteraction.toURI(clientSession.getUsername(), remote);
            ArrayList<String> messages = new ArrayList<String>();
            String warning = MessageFormat.format(SshdText.get().knownHostsModifiedKeyWarning, keyAlgorithm, expected.getAlgorithm(), remoteHost, KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)expected), KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)expected), KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)actual), KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)actual));
            String[] stringArray = warning.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                messages.add(line);
                ++n2;
            }
            CredentialsProvider provider = OpenSshServerKeyVerifier.getCredentialsProvider(clientSession);
            if (check == Check.DENY) {
                if (provider != null) {
                    messages.add(MessageFormat.format(SshdText.get().knownHostsModifiedKeyDenyMsg, path));
                    OpenSshServerKeyVerifier.askUser(provider, uri, null, messages.toArray(new String[0]));
                }
                return ModifiedKeyHandling.DENY;
            }
            ArrayList<Object> items = new ArrayList<Object>(messages.size() + 2);
            for (String message : messages) {
                items.add(new CredentialItem.InformationalMessage(message));
            }
            CredentialItem.YesNoType proceed = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyAcceptPrompt);
            CredentialItem.YesNoType store = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyStorePrompt);
            items.add(proceed);
            items.add(store);
            if (provider.get(uri, items) && proceed.getValue()) {
                return store.getValue() ? ModifiedKeyHandling.ALLOW_AND_STORE : ModifiedKeyHandling.ALLOW;
            }
            return ModifiedKeyHandling.DENY;
        }

        private static enum Check {
            ASK,
            DENY,
            ALLOW;

        }
    }

    private static class HostKeyFile
    extends ModifiableFileWatcher
    implements Supplier<List<KnownHostsServerKeyVerifier.HostEntryPair>> {
        private List<KnownHostsServerKeyVerifier.HostEntryPair> entries = Collections.emptyList();

        public HostKeyFile(Path path) {
            super(path);
        }

        @Override
        public List<KnownHostsServerKeyVerifier.HostEntryPair> get() {
            block7: {
                Path path = this.getPath();
                try {
                    if (!this.checkReloadRequired()) break block7;
                    if (!Files.exists(path, new LinkOption[0])) {
                        this.resetReloadAttributes();
                        return Collections.emptyList();
                    }
                    LockFile lock = new LockFile(path.toFile());
                    if (lock.lock()) {
                        try {
                            this.entries = this.reload(this.getPath());
                            break block7;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedRead, path));
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileReadFailed, path));
                }
            }
            return Collections.unmodifiableList(this.entries);
        }

        private List<KnownHostsServerKeyVerifier.HostEntryPair> reload(Path path) throws IOException {
            try {
                List<KnownHostEntry> rawEntries = KnownHostEntryReader.readFromFile(path);
                this.updateReloadAttributes();
                if (rawEntries == null || rawEntries.isEmpty()) {
                    return Collections.emptyList();
                }
                LinkedList<KnownHostsServerKeyVerifier.HostEntryPair> newEntries = new LinkedList<KnownHostsServerKeyVerifier.HostEntryPair>();
                for (KnownHostEntry entry : rawEntries) {
                    AuthorizedKeyEntry keyPart = entry.getKeyEntry();
                    if (keyPart == null) continue;
                    try {
                        PublicKey serverKey = keyPart.resolvePublicKey(PublicKeyEntryResolver.IGNORING);
                        if (serverKey == null) {
                            LOG.warn(MessageFormat.format(SshdText.get().knownHostsUnknownKeyType, path, entry.getConfigLine()));
                            continue;
                        }
                        newEntries.add(new KnownHostsServerKeyVerifier.HostEntryPair(entry, serverKey));
                    }
                    catch (GeneralSecurityException e) {
                        LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidLine, path, entry.getConfigLine()));
                    }
                }
                return newEntries;
            }
            catch (FileNotFoundException e) {
                this.resetReloadAttributes();
                return Collections.emptyList();
            }
        }
    }

    private static class HostKeyHelper
    extends KnownHostsServerKeyVerifier {
        public HostKeyHelper() {
            super((c, r, s) -> false, new File(".").toPath());
        }

        protected KnownHostEntry prepareKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) throws IOException {
            try {
                return super.prepareKnownHostEntry(clientSession, remoteAddress, serverKey);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        protected String prepareModifiedServerKeyLine(ClientSession clientSession, SocketAddress remoteAddress, KnownHostEntry entry, String curLine, PublicKey expected, PublicKey actual) throws IOException {
            try {
                return super.prepareModifiedServerKeyLine(clientSession, remoteAddress, entry, curLine, expected, actual);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        protected Collection<SshdSocketAddress> resolveHostNetworkIdentities(ClientSession clientSession, SocketAddress remoteAddress) {
            return super.resolveHostNetworkIdentities(clientSession, remoteAddress);
        }
    }

    private static enum ModifiedKeyHandling {
        DENY,
        ALLOW,
        ALLOW_AND_STORE;

    }

    private static class RevokedKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RevokedKeyException() {
        }
    }
}

