/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.processors.Processors;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

final class ProblemStatusDialog
extends MessageDialog {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private ILogEvent event;
    private List<IProcessorDescriptor> requestedDescriptors;

    ProblemStatusDialog(ILogEvent event, List<IProcessorDescriptor> reportProcessorDescriptors, Shell parentShell) {
        super(parentShell, ProblemStatusDialog.createTitle(event), null, "", 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.requestedDescriptors = reportProcessorDescriptors.stream().filter(descriptor -> Processors.shouldProcess(descriptor, event)).collect(Collectors.toList());
        this.setShellStyle(67696);
        this.event = event;
    }

    private static String createTitle(ILogEvent event) {
        ProblemStatus status = event.getInterest().getStatus();
        switch (status) {
            case CONFIRMED: {
                return Messages.STATUS_TITLE_CONFIRMED;
            }
            case FAILURE: {
                return Messages.STATUS_TITLE_FAILURE;
            }
            case FIXED: {
                return Messages.STATUS_TITLE_FIXED;
            }
            case IGNORED: {
                return Messages.STATUS_TITLE_IGNORED;
            }
            case INVALID: {
                return Messages.STATUS_TITLE_INVALID;
            }
            case NEEDINFO: {
                return Messages.STATUS_TITLE_NEEDINFO;
            }
            case NEW: {
                return Messages.STATUS_TITLE_NEW;
            }
            case UNCONFIRMED: {
                return Messages.STATUS_TITLE_UNCONFIRMED;
            }
        }
        String message = String.valueOf(((Serializable)MoreObjects.firstNonNull((Object)status, (Object)"null")).toString()) + ", target server: " + event.getServer().getName();
        throw new IllegalArgumentException(message);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        Composite messageLink = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)messageLink);
        messageLink.setLayout((Layout)new GridLayout());
        Link message = new Link(messageLink, 64);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)message);
        IProblemState interest = this.event.getInterest();
        StringBuilder builder = new StringBuilder();
        builder.append(interest.getMessage());
        message.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser(e.text);
            }
        });
        if (!this.requestedDescriptors.isEmpty()) {
            builder.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
            builder.append("Additionally requested information:");
            new Label(composite, 0);
            Composite sections = new Composite(composite, 0);
            UI.gl().spacing(0, 0).applyTo(sections);
            UI.gd().align(4, 1).applyTo((Control)sections);
            for (IProcessorDescriptor descriptor : this.requestedDescriptors) {
                Composite section = new Composite(sections, 0);
                UI.gl().numColumns(1).applyTo(section);
                UI.gd().indent(20, 0).align(4, 1).applyTo((Control)section);
                CLabel processorLabel = new CLabel(section, 0);
                processorLabel.setImage(descriptor.getImage16());
                processorLabel.setText(descriptor.getName());
                processorLabel.setToolTipText(MessageFormat.format("{0}:\n{1}", descriptor.getName(), descriptor.getDescription()));
            }
        }
        message.setText(builder.toString());
        return composite;
    }
}

