/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.webos;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.ProcessResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;

public class WebOsEmulator
extends DreamweaverBase {
    public String host = "localhost";
    public int port = 5522;
    String user = "root";
    String password = "";
    long MAX_TIME = 420L;
    public String path;
    public String emulator_type;
    public String log_file = null;
    static boolean DEBUG = true;
    public String palm_install = null;
    public String palm_emulator = null;
    public String palm_launch = null;

    public static void main(String[] args) throws Exception {
        WebOsEmulator emulator = new WebOsEmulator();
        emulator.path = "/opt/PalmSDK/0.1/bin";
        emulator.emulator_type = "SDK 3.0.5.676 (1024x768)";
        emulator.log_file = "/Users/hardeep/webos_log.txt";
        String ipk = "/Users/hardeep/Downloads/com.example.app_1.0.0_all.ipk";
        String package_to_run = "com.example.app";
        try {
            emulator.start_install_and_run(ipk, package_to_run);
            WebOsEmulator.debug_log("complete");
        }
        catch (Exception e) {
            WebOsEmulator.debug_log(e.getMessage());
        }
    }

    public WebOsEmulator() {
        if (WebOsEmulator.isMac()) {
            this.palm_emulator = "palm-emulator";
            this.palm_install = "palm-install";
            this.palm_launch = "palm-launch";
        } else {
            this.palm_emulator = "palm-emulator.bat";
            this.palm_install = "palm-install.bat";
            this.palm_launch = "palm-launch.bat";
        }
    }

    static String buildCommand(String path, String exec) throws Exception {
        if (WebOsEmulator.isMac()) {
            return String.valueOf(path) + "/" + exec;
        }
        return String.valueOf(path) + "\\" + exec;
    }

    public void launchEmulator() throws Exception {
        ProcessResult emu_process = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_emulator), "--start", this.emulator_type});
        if (emu_process.process.exitValue() > 0) {
            throw new Exception(emu_process.errOut.replaceAll("\r\n", ""));
        }
    }

    public HashMap<Integer, String> listEmulators() throws Exception {
        ProcessResult emu_result = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_emulator), "--list"});
        String result = emu_result.stdOut;
        String[] list = result.split("\\r?\\n");
        if (list.length < 1) {
            throw new Exception("No valid images found");
        }
        HashMap<Integer, String> emu_list = new HashMap<Integer, String>();
        int i = 1;
        while (i < list.length) {
            emu_list.put(i - 1, list[i]);
            ++i;
        }
        return emu_list;
    }

    public void install(String ipk, long timeout) throws Exception {
        long initial_time;
        SshClient client = null;
        boolean is_connected = false;
        boolean is_authed = false;
        ProcessResult result = null;
        try {
            client = SshClient.setUpDefaultClient();
            WebOsEmulator.debug_log("starting client");
            client.start();
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
        long current_time = initial_time = System.currentTimeMillis() / 1000L;
        WebOsEmulator.debug_log("connecting to emulator.");
        WebOsEmulator.debug_log("waiting a total of " + timeout + " seconds ...");
        while (current_time < initial_time + timeout) {
            WebOsEmulator.debug_log("current time " + current_time + " waiting until " + (initial_time + timeout));
            ConnectFuture future = null;
            try {
                future = (ConnectFuture)client.connect(this.host, this.port).await();
            }
            catch (Exception e) {
                throw new Exception("failed to connect to the emulator");
            }
            try {
                if (future.isConnected()) {
                    boolean authed;
                    WebOsEmulator.debug_log("current times " + current_time + " waiting until " + (initial_time + timeout));
                    is_connected = true;
                    ClientSession session = future.getSession();
                    is_authed = authed = ((AuthFuture)session.authPassword(this.user, this.password).await()).isSuccess();
                    if (is_authed) {
                        break;
                    }
                }
            }
            catch (Exception e) {
                WebOsEmulator.debug_log(e.getMessage());
                throw new Exception("failed to authenticate with the emulator: " + e.getMessage());
            }
            current_time = System.currentTimeMillis() / 1000L;
        }
        if (!is_connected || !is_authed) {
            throw new Exception("failed to connect to the emulator");
        }
        result = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_install), ipk});
        if (result.process.exitValue() > 0) {
            throw new Exception(result.errOut.replaceAll("\r\n", ""));
        }
        try {
            client.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void install(String ipk) throws Exception {
        this.install(ipk, this.MAX_TIME);
    }

    public void run(String run_package) throws Exception {
        ProcessResult result = WebOsEmulator.commandLine(new String[]{WebOsEmulator.buildCommand(this.path, this.palm_launch), run_package});
        if (result.process.exitValue() > 0) {
            throw new Exception(result.errOut.replaceAll("\r\n", ""));
        }
    }

    public boolean start_install_and_run(String ipk, String package_to_run) throws Exception {
        File ipk_file = new File(ipk);
        if (!ipk_file.exists()) {
            WebOsEmulator.debug_log("file does not exist");
            throw new Exception("file " + ipk + " does not exist.");
        }
        this.log(WebOsEmulator.build_json("pending", "trying to install application"));
        try {
            this.install(ipk, 2L);
            this.log(WebOsEmulator.build_json("pending", "installed: " + package_to_run));
        }
        catch (Exception fail_install_ex) {
            this.log(WebOsEmulator.build_json("pending", "emulator not running. launching emulator: " + this.emulator_type));
            this.launchEmulator();
            this.log(WebOsEmulator.build_json("pending", "trying to install application once emulator has booted"));
            this.install(ipk);
        }
        this.log(WebOsEmulator.build_json("pending", "attempting to run application"));
        this.run(package_to_run);
        this.log(WebOsEmulator.build_json("complete", "running application"));
        return true;
    }

    public static String build_json(String status_string, String message) {
        HashMap<String, String> emu_list = new HashMap<String, String>();
        emu_list.put("status", status_string);
        emu_list.put("message", message);
        return WebOsEmulator.build_json(emu_list);
    }

    public static String build_json(HashMap json_data) {
        String current_string = "";
        Set set = json_data.entrySet();
        Iterator i = set.iterator();
        String comma = ",";
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() instanceof HashMap) {
                current_string = String.valueOf(current_string) + "\"" + entry.getKey() + "\":" + WebOsEmulator.build_json((HashMap)entry.getValue());
                current_string = String.valueOf(current_string) + (i.hasNext() ? "," : "");
                continue;
            }
            current_string = String.valueOf(current_string) + "\"" + entry.getKey() + "\": " + WebOsEmulator.return_correct_type(entry.getValue());
            current_string = String.valueOf(current_string) + (i.hasNext() ? "," : "");
        }
        return "{" + current_string + "}";
    }

    static Object return_correct_type(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Boolean) {
            return Boolean.toString((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return Integer.toString((Integer)obj);
        }
        return "\"" + obj.toString() + "\"";
    }

    public static void debug_log(Object string) {
        if (DEBUG) {
            System.out.println("debug:\t" + string.toString());
        }
    }

    public void log(String json) throws Exception {
        WebOsEmulator.debug_log("writing to file: " + this.log_file + " \n\twith contents => " + json);
        FileWriter fstream = new FileWriter(this.log_file, false);
        BufferedWriter write = new BufferedWriter(fstream);
        write.write(json);
        write.close();
    }
}

