/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.DreamweaverBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class PhoneGapBuildApi
extends DreamweaverBase {
    protected String auth_token = null;
    public String json_file = "";
    protected HttpClient http_client;
    protected String host = "https://build.phonegap.com";
    protected int port = 443;
    protected String api_version = "api/v1";
    public String appSource = "dw";
    final String default_title = "PhoneGap Build Project";
    final String default_package_name = "com.example.app";
    final String default_version = "1.0.0";
    final String default_description = "PhoneGap Application";
    final Boolean default_debug = Boolean.FALSE;
    final Integer default_ios_key = null;
    final Integer default_android_key = null;
    final Integer default_blackberry_key = null;

    public PhoneGapBuildApi() {
        this.http_client = new DefaultHttpClient();
    }

    protected int check_authentication(String auth_token) throws Exception {
        HttpGet get = new HttpGet(String.valueOf(this.host) + "/" + this.api_version + "?");
        this.auth_token = auth_token;
        URI query = get.getURI();
        get.setURI(new URI(String.valueOf(query.toString()) + "&auth_token=" + URLEncoder.encode(this.auth_token, "UTF-8")));
        URI newquery = get.getURI();
        get.setURI(new URI(String.valueOf(newquery.toString()) + "&app_source=" + URLEncoder.encode(this.appSource, "UTF-8")));
        HttpResponse response = this.http_client.execute((HttpUriRequest)get);
        StatusLine status = response.getStatusLine();
        return status.getStatusCode();
    }

    protected void authenticate(String username, String password) throws Exception {
        DefaultHttpClient l_http_client = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        l_http_client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)creds);
        PhoneGapBuildApi.debug_log("Accessing: " + this.host + "/token");
        HttpPost post = new HttpPost(String.valueOf(this.host) + "/token");
        HttpParams params = post.getParams();
        params.setParameter("app_source", (Object)this.appSource);
        post.setParams(params);
        try {
            HttpResponse status = l_http_client.execute((HttpUriRequest)post);
            HttpEntity entity = status.getEntity();
            String json = EntityUtils.toString((HttpEntity)entity);
            this.write_json(this.json_file, json);
            JSONObject json_object = new JSONObject(json);
            PhoneGapBuildApi.debug_log(json_object.toString());
            try {
                this.auth_token = json_object.get("token").toString();
            }
            catch (Exception e) {
                return;
            }
        }
        catch (Exception e) {
            String message = "{error:'Authentication Failure. Could not connect to server.'}";
            PhoneGapBuildApi.debug_log(message);
            this.write_json(this.json_file, message);
        }
    }

    protected String post_json_with_auth_token(HttpPost post) throws IOException {
        HttpParams params = post.getParams();
        params.setParameter("auth_token", (Object)this.auth_token);
        params.setParameter("app_source", (Object)this.appSource);
        HttpResponse response = this.http_client.execute((HttpUriRequest)post);
        String json = response.toString();
        return json;
    }

    protected String get_json_with_auth_token(HttpGet get) throws Exception {
        URI query = get.getURI();
        get.setURI(new URI(String.valueOf(query.toString()) + "&auth_token=" + URLEncoder.encode(this.auth_token, "UTF-8")));
        URI newquery = get.getURI();
        get.setURI(new URI(String.valueOf(newquery.toString()) + "&app_source=" + URLEncoder.encode(this.appSource, "UTF-8")));
        PhoneGapBuildApi.debug_log(get.getURI().toString());
        HttpResponse response = this.http_client.execute((HttpUriRequest)get);
        String json = EntityUtils.toString((HttpEntity)response.getEntity());
        System.out.println(json);
        return json;
    }

    protected void send_json(HttpPost post) throws Exception {
        HttpParams params = post.getParams();
        params.setParameter("auth_token", (Object)this.auth_token);
        params.setParameter("app_source", (Object)this.appSource);
        post.setParams(params);
        this.http_client.execute((HttpUriRequest)post);
    }

    public void write_json(String filename, String json) throws Exception {
        PhoneGapBuildApi.debug_log("writing to file: " + filename + " \n\twith contents => " + json);
        FileWriter fstream = new FileWriter(filename);
        BufferedWriter write = new BufferedWriter(fstream);
        write.write(json);
        write.close();
    }

    protected boolean string_empty(String string) {
        return string == null || string.length() == 0;
    }

    protected boolean is_null(Object object) {
        return object == null;
    }

    public String build_json(HashMap json_data) {
        String current_string = "";
        Set set = json_data.entrySet();
        Iterator i = set.iterator();
        String comma = ",";
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() instanceof HashMap) {
                current_string = String.valueOf(current_string) + "\"" + entry.getKey() + "\":" + this.build_json((HashMap)entry.getValue());
                current_string = String.valueOf(current_string) + (i.hasNext() ? "," : "");
                continue;
            }
            current_string = String.valueOf(current_string) + "\"" + entry.getKey() + "\": " + this.return_correct_type(entry.getValue());
            current_string = String.valueOf(current_string) + (i.hasNext() ? "," : "");
        }
        return "{" + current_string + "}";
    }

    protected Object return_correct_type(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Boolean) {
            return Boolean.toString((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return Integer.toString((Integer)obj);
        }
        return "\"" + obj.toString() + "\"";
    }

    public ArrayList<File> list_files(String dir) {
        File handle = new File(dir);
        ArrayList<File> file_list = new ArrayList<File>();
        File[] children = handle.listFiles();
        System.out.println("file " + children.length);
        if (children == null) {
            if (handle.isFile()) {
                file_list.add(handle);
            }
        } else {
            int i = 0;
            while (i < children.length) {
                System.out.println(children[i].getAbsolutePath());
                file_list.add(children[i]);
                if (children[i].isDirectory()) {
                    file_list.addAll(this.list_files(children[i].getAbsolutePath()));
                }
                ++i;
            }
        }
        return file_list;
    }

    public void create_zip(String dir_to_zip, String output_path) throws Exception {
        ArrayList<File> file_list = this.list_files(dir_to_zip);
        PhoneGapBuildApi.debug_log(file_list.toString());
        this._create_zip(output_path, dir_to_zip, file_list);
    }

    private void _create_zip(String output_path, String base_dir, ArrayList<File> file_list) throws Exception {
        int BUFFER = 2048;
        BufferedInputStream origin = null;
        FileOutputStream dest = new FileOutputStream(output_path);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        byte[] data = new byte[2048];
        int i = 0;
        while (i < file_list.size()) {
            System.out.println("Adding: " + file_list.get(i).getAbsolutePath());
            File tmp = new File(file_list.get(i).getAbsolutePath());
            if (tmp.isFile() && !tmp.getName().equals("ProjectSettings")) {
                int count;
                FileInputStream fi = new FileInputStream(file_list.get(i).getAbsolutePath());
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(this.relative_path(base_dir, file_list.get(i).getAbsolutePath()));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            ++i;
        }
        out.close();
    }

    public String relative_path(String dir, String current_path) {
        String path_sep = File.separator;
        ArrayList<String> dir_ = this.split_path(dir);
        ArrayList<String> current_path_ = this.split_path(current_path);
        ArrayList matched_path = new ArrayList();
        String relative_path_match = "";
        int i = 0;
        while (i < dir_.size()) {
            if (current_path_.size() < i || !current_path_.get(i).equals(dir_.get(i))) break;
            relative_path_match = String.valueOf(relative_path_match) + current_path_.get(i) + path_sep;
            ++i;
        }
        relative_path_match = System.getProperty("os.name").startsWith("Mac OS") ? "/" + relative_path_match : relative_path_match;
        relative_path_match = System.getProperty("os.name").startsWith("Windows") ? "c:\\" + relative_path_match : relative_path_match;
        return "." + current_path.substring(relative_path_match.length() - 1);
    }

    public ArrayList<String> split_path(String path) {
        File piece;
        File file = new File(path);
        ArrayList<String> path_pieces = new ArrayList<String>();
        path_pieces.add(file.getName());
        while ((piece = file.getParentFile()) != null) {
            if (file.getParentFile().getName().length() <= 0) break;
            path_pieces.add(piece.getName());
            file = new File(piece.getAbsolutePath());
        }
        Collections.reverse(path_pieces);
        return path_pieces;
    }
}

