/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.PhoneGapBuildApi1;
import com.phonegap.build.android.Android;
import com.phonegap.build.android.AndroidLog;
import com.phonegap.build.webos.WebOsEmulator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DreamweaverPlugin
extends DreamweaverBase {
    private static final long MAX_TIME = 300L;
    private static final String[] all_platforms = new String[]{"ios", "android", "blackberry", "symbian", "webos"};

    public static void main(String[] args) throws Exception {
        Object json;
        ArrayList<String> build_platforms = new ArrayList<String>();
        int i = 0;
        while (i < all_platforms.length) {
            build_platforms.add(all_platforms[i]);
            ++i;
        }
        PhoneGapBuildApi1 plugin = new PhoneGapBuildApi1();
        plugin.host = "https://build.phonegap.com";
        OptionParser parser = new OptionParser();
        parser.accepts("host").withRequiredArg();
        parser.accepts("output").withRequiredArg();
        parser.accepts("appVersion").withRequiredArg();
        parser.accepts("authorize");
        parser.accepts("username").withRequiredArg();
        parser.accepts("password").withRequiredArg();
        parser.accepts("checkAuth");
        parser.accepts("authToken").withRequiredArg();
        parser.accepts("delete");
        parser.accepts("file").withRequiredArg();
        parser.accepts("build");
        parser.accepts("create");
        parser.accepts("projectDir").withRequiredArg();
        parser.accepts("tmpDir").withRequiredArg();
        parser.accepts("listsdks");
        parser.accepts("platform").withRequiredArg();
        parser.accepts("sdkPath").withRequiredArg();
        parser.accepts("run");
        parser.accepts("device").withRequiredArg();
        parser.accepts("appPath").withRequiredArg();
        parser.accepts("createAVD");
        parser.accepts("name").withRequiredArg();
        parser.accepts("target").withRequiredArg();
        parser.accepts("launchavdmanager");
        parser.accepts("buildStatus");
        parser.accepts("appId").withRequiredArg();
        parser.accepts("download");
        parser.accepts("url").withRequiredArg();
        parser.accepts("dest").withRequiredArg();
        parser.accepts("listApps");
        OptionSet options = parser.parse(args);
        if (options.has("host")) {
            plugin.host = (String)options.valueOf("host");
        }
        if (options.has("appVersion")) {
            plugin.appSource = (String)options.valueOf("appVersion");
        }
        if (options.has("checkAuth") && options.hasArgument("authToken")) {
            int statusCode = 401;
            String message = "Sorry, we were not able to log you in. The authentication token is invalid.";
            try {
                statusCode = plugin.check_authentication((String)options.valueOf("authToken"));
                if (statusCode == 200) {
                    message = "Authenticated";
                }
            }
            catch (Exception e) {
                statusCode = 404;
                message = "Sorry, it looks like we are having some technical issues. Please try again.";
            }
            plugin.json_file = (String)options.valueOf("output");
            HashMap<String, Object> json_data = new HashMap<String, Object>();
            json_data.put("statusCode", statusCode);
            json_data.put("statusMessage", message);
            DreamweaverPlugin.debug_log(plugin.build_json(json_data));
            try {
                plugin.write_json(plugin.json_file, plugin.build_json(json_data));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (options.has("authorize") && options.hasArgument("username") && options.hasArgument("password") && options.hasArgument("output")) {
            plugin.json_file = (String)options.valueOf("output");
            try {
                plugin.authenticate((String)options.valueOf("username"), (String)options.valueOf("password"));
            }
            catch (Exception e) {
                DreamweaverPlugin.debug_log("Failed to authenticate.");
            }
        }
        if (options.has("delete") && options.has("file")) {
            try {
                ArrayList<File> list = plugin.list_files((String)options.valueOf("file"));
                int i2 = 0;
                while (i2 < list.size()) {
                    DreamweaverPlugin.debug_log("deleting: " + list.get(i2).getAbsolutePath());
                    list.get(i2).delete();
                    ++i2;
                }
            }
            catch (Exception list) {
                // empty catch block
            }
        }
        if (options.has("build") && (options.has("authToken") || options.has("projectDir") || options.has("tmpDir") || options.has("output"))) {
            plugin.auth_token = (String)options.valueOf("authToken");
            String project_dir = (String)options.valueOf("projectDir");
            String output_file = (String)options.valueOf("output");
            String tmp_folder = String.valueOf((String)options.valueOf("tmpDir")) + File.separator + "www.zip";
            DreamweaverPlugin.debug_log("Creating app");
            DreamweaverPlugin.debug_log("Using token: " + plugin.auth_token);
            DreamweaverPlugin.debug_log("Attempting to zip: " + project_dir);
            try {
                String json_data = plugin.update_application_from_file(options.has("create"), null, null, null, null, true, null, null, null, project_dir, tmp_folder, options.has("appId") ? Integer.valueOf(Integer.parseInt((String)options.valueOf("appId"))) : null);
                json = new JSONObject(json_data);
                plugin.write_json(output_file, json_data);
                if (((JSONObject)json).has("id")) {
                    plugin.write_json(String.valueOf(project_dir) + File.separator + "ProjectSettings", json_data);
                }
            }
            catch (Exception e) {
                try {
                    json = new HashMap();
                    ((HashMap)json).put("error", 404);
                    ((HashMap)json).put("message", "Failed to upload application. Reason:" + e.getMessage());
                    String message = plugin.build_json((HashMap)json);
                    DreamweaverPlugin.debug_log(message);
                    plugin.write_json(output_file, message);
                }
                catch (Exception json2) {
                    // empty catch block
                }
            }
        }
        if (options.has("buildStatus") && options.has("authToken") && options.has("output") && options.has("appId")) {
            JSONObject json3;
            long initial_time;
            DreamweaverPlugin.debug_log("Cheking build status");
            plugin.auth_token = (String)options.valueOf("authToken");
            String output = (String)options.valueOf("output");
            Integer app_id = Integer.parseInt((String)options.valueOf("appId"));
            long current_time = initial_time = System.currentTimeMillis() / 1000L;
            HashMap completed = new HashMap();
            HashMap platforms = new HashMap();
            while (current_time - initial_time <= 300L && build_platforms.size() > 0) {
                try {
                    json3 = plugin.get_app(app_id);
                    int i3 = 0;
                    while (i3 < build_platforms.size()) {
                        HashMap<String, Object> platform_info = new HashMap<String, Object>();
                        platform_info.put("status", json3.getJSONObject("status").get((String)build_platforms.get(i3)));
                        Boolean keys = false;
                        if (json3.getJSONObject("keys").has((String)build_platforms.get(i3))) {
                            keys = !json3.getJSONObject("keys").get((String)build_platforms.get(i3)).toString().equals("null");
                        }
                        platform_info.put("signed", keys.toString());
                        if (json3.getJSONObject("error").has((String)build_platforms.get(i3))) {
                            platform_info.put("error", json3.getJSONObject("error").get((String)build_platforms.get(i3)));
                        }
                        if (json3.getJSONObject("download").has((String)build_platforms.get(i3))) {
                            platform_info.put("download", json3.getJSONObject("download").get((String)build_platforms.get(i3)));
                        }
                        platforms.put((String)build_platforms.get(i3), platform_info);
                        if (!json3.getJSONObject("status").get((String)build_platforms.get(i3)).equals("pending")) {
                            build_platforms.remove(i3);
                        }
                        ++i3;
                    }
                    plugin.write_json(output, plugin.build_json(platforms));
                    DreamweaverPlugin.debug_log(plugin.build_json(platforms));
                }
                catch (Exception e) {
                    String json4 = DreamweaverPlugin.failAllBuilds("Could not retrieve info. The connection may have been lost.");
                    plugin.write_json(output, json4);
                    return;
                }
                try {
                    Thread.sleep(7000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                current_time = System.currentTimeMillis() / 1000L;
            }
            json3 = plugin.get_app(app_id);
            HashMap platforms_json = new HashMap();
            int i4 = 0;
            while (i4 < all_platforms.length) {
                HashMap<String, Object> platform_info = new HashMap<String, Object>();
                String status = "";
                String error = "";
                if (((String)json3.getJSONObject("status").get(all_platforms[i4])).equals("pending")) {
                    status = "error";
                    error = "Failed to communitcate with build servers." + (String)json3.getJSONObject("status").get(all_platforms[i4]);
                } else {
                    status = (String)json3.getJSONObject("status").get(all_platforms[i4]);
                    if (json3.getJSONObject("error").has(all_platforms[i4])) {
                        error = (String)json3.getJSONObject("error").get(all_platforms[i4]);
                    }
                }
                Boolean keys = false;
                if (json3.getJSONObject("keys").has(all_platforms[i4])) {
                    keys = !json3.getJSONObject("keys").get(all_platforms[i4]).toString().equals("null");
                }
                platform_info.put("signed", keys.toString());
                platform_info.put("signed", json3.getJSONObject("keys").has(all_platforms[i4]));
                platform_info.put("status", status);
                platform_info.put("error", error);
                if (json3.getJSONObject("download").has(all_platforms[i4])) {
                    platform_info.put("download", json3.getJSONObject("download").get(all_platforms[i4]));
                }
                platforms_json.put(all_platforms[i4], platform_info);
                ++i4;
            }
            try {
                plugin.write_json(output, plugin.build_json(platforms_json));
                DreamweaverPlugin.debug_log(plugin.build_json(platforms_json));
                DreamweaverPlugin.debug_log("done");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (options.has("listApps") && options.has("authToken") && options.has("output")) {
            if (options.has("appId")) {
                Integer app_id = Integer.parseInt((String)options.valueOf("appId"));
                String output_file = (String)options.valueOf("output");
                plugin.auth_token = (String)options.valueOf("authToken");
                JSONObject json5 = plugin.get_app(app_id);
                DreamweaverBase.write_json(output_file, json5);
            } else {
                JSONArray array;
                JSONObject json_result;
                String output_file = (String)options.valueOf("output");
                plugin.auth_token = (String)options.valueOf("authToken");
                DreamweaverPlugin.debug_log(plugin.auth_token);
                try {
                    json_result = plugin.get_apps();
                }
                catch (JSONException e) {
                    String json6 = e.getMessage();
                    try {
                        plugin.write_json(output_file, json6);
                    }
                    catch (Exception current_time) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    array = json_result.getJSONArray("apps");
                }
                catch (JSONException e) {
                    json = json_result.toString();
                    try {
                        plugin.write_json(output_file, (String)json);
                    }
                    catch (Exception message) {
                        // empty catch block
                    }
                    return;
                }
                System.out.println(json_result);
                HashMap apps_hash = new HashMap();
                int i22 = 0;
                while (i22 < array.length()) {
                    JSONObject app = (JSONObject)array.get(i22);
                    if (app.isNull("repo")) {
                        HashMap<String, Object> app_hash = new HashMap<String, Object>();
                        app_hash.put("id", app.get("id"));
                        app_hash.put("title", app.get("title"));
                        apps_hash.put(i22, app_hash);
                    }
                    ++i22;
                }
                try {
                    plugin.write_json(output_file, plugin.build_json(apps_hash));
                }
                catch (Exception i22) {
                    // empty catch block
                }
            }
        }
        if (options.has("listsdks")) {
            String output_file = (String)options.valueOf("output");
            String sdkPath = (String)options.valueOf("sdkPath");
            String platform = (String)options.valueOf("platform");
            if (platform.contentEquals("android")) {
                try {
                    Android.listSDKs(sdkPath, output_file);
                }
                catch (Exception e) {
                    DreamweaverPlugin.debug_log("EX " + e.toString());
                }
            } else if (platform.contentEquals("webos")) {
                try {
                    WebOsEmulator emulator = new WebOsEmulator();
                    emulator.path = sdkPath;
                    HashMap<Integer, String> list = emulator.listEmulators();
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("status", "200");
                    result.put("emulators", list);
                    plugin.write_json(output_file, plugin.build_json(result));
                }
                catch (Exception e) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("status", "404");
                    result.put("reason", "Could not find any valid emulators");
                    plugin.write_json(output_file, plugin.build_json(result));
                }
            }
        }
        if (options.has("run")) {
            String output_file = (String)options.valueOf("output");
            String sdkPath = (String)options.valueOf("sdkPath");
            String platform = (String)options.valueOf("platform");
            String appPath = (String)options.valueOf("appPath");
            String device = (String)options.valueOf("device");
            String package_to_run = (String)options.valueOf("target");
            if (platform.contentEquals("android")) {
                try {
                    Android.run(sdkPath, appPath, device, output_file);
                }
                catch (Exception app_hash) {}
            } else if (platform.contentEquals("webos")) {
                try {
                    WebOsEmulator emulator = new WebOsEmulator();
                    if (platform.contentEquals("undefined") || sdkPath.contentEquals("undefined") || platform.contentEquals("undefined") || appPath.contentEquals("undefined") || device.contentEquals("undefined") || package_to_run.contentEquals("undefined")) {
                        throw new Exception("could not launch the emulator");
                    }
                    emulator.path = sdkPath;
                    emulator.emulator_type = device;
                    emulator.log_file = output_file;
                    emulator.start_install_and_run(appPath, package_to_run);
                }
                catch (Exception e) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("status", "done");
                    result.put("message", "Failed to run: " + e.getMessage() + "; please try again.");
                    plugin.write_json(output_file, plugin.build_json(result));
                }
            }
        }
        if (options.has("createAVD")) {
            String output_file = (String)options.valueOf("output");
            String sdkPath2 = (String)options.valueOf("sdkPath");
            String target = (String)options.valueOf("target");
            String name = (String)options.valueOf("name");
            try {
                Android.createAVD(sdkPath2, target, name, output_file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (options.has("launchavdmanager")) {
            String sdkPath = (String)options.valueOf("sdkPath");
            try {
                Android.launchAVDManager(sdkPath);
            }
            catch (Exception sdkPath2) {
                // empty catch block
            }
        }
        if (options.has("download")) {
            String output_file = (String)options.valueOf("output");
            String dest = (String)options.valueOf("dest");
            String url = (String)options.valueOf("url");
            try {
                DreamweaverPlugin.downloadFile(url, dest, output_file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Boolean downloadFile(String urlString, String destination, String outputFile) throws Exception {
        DefaultHttpClient client = null;
        HttpGet get = null;
        HttpResponse response = null;
        FilterOutputStream outStream = null;
        BufferedInputStream inStream = null;
        try {
            int byteRead;
            JSONObject json = new JSONObject();
            Android.write_json(outputFile, json.put("state", "connecting"));
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
            client = new DefaultHttpClient((HttpParams)httpParams);
            get = new HttpGet(urlString);
            response = client.execute((HttpUriRequest)get);
            Header contentSize = response.getFirstHeader("Content-Length");
            byte[] buf = new byte[4096];
            int fileSize = 0;
            if (contentSize != null) {
                String value = contentSize.getValue();
                fileSize = Integer.parseInt(value);
            }
            outStream = new BufferedOutputStream(new FileOutputStream(destination, false));
            inStream = new BufferedInputStream(response.getEntity().getContent());
            AndroidLog log = new AndroidLog("downloading", "");
            int byteWritten = 0;
            float percentage = 0.0f;
            int showPercentage = 0;
            long elapsed = 0L;
            json.put("state", "downloading");
            while ((byteRead = inStream.read(buf)) != -1) {
                ((BufferedOutputStream)outStream).write(buf, 0, byteRead);
                percentage = (float)(byteWritten += byteRead) / (float)fileSize * 100.0f;
                if ((int)percentage == showPercentage || !(percentage < 100.0f) || System.currentTimeMillis() - elapsed < 1000L) continue;
                showPercentage = (int)percentage;
                Android.write_json(outputFile, json.put("progress", showPercentage));
                elapsed = System.currentTimeMillis();
            }
            ((BufferedOutputStream)outStream).flush();
            json.put("progress", 100);
            Android.write_json(outputFile, json.put("state", "finished"));
            Boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            Android.error(outputFile, "Download failed: " + e.getMessage());
        }
        catch (UnknownHostException e) {
            Android.error(outputFile, "Download failed: " + e.getMessage());
        }
        catch (Exception e) {
            Android.error(outputFile, "Download failed: " + e.getMessage());
        }
        finally {
            try {
                outStream.close();
            }
            catch (Exception exception) {}
            try {
                inStream.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    static String failAllBuilds(String reason) {
        HashMap json_map = new HashMap();
        PhoneGapBuildApi1 plugin = new PhoneGapBuildApi1();
        int i = 0;
        while (i < all_platforms.length) {
            HashMap<String, String> platform_json = new HashMap<String, String>();
            platform_json.put("status", "error");
            platform_json.put("error", reason);
            json_map.put(all_platforms[i], platform_json);
            ++i;
        }
        return plugin.build_json(json_map);
    }
}

