/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.ProcessResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DreamweaverBase {
    private static final boolean DEBUG = true;

    protected static void debug_log(Object string) {
        System.out.println("debug:\t" + string.toString());
    }

    protected static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    protected static ProcessResult commandLine(String[] command, Boolean fork, String inputCommand) throws Exception {
        String line;
        ProcessResult result = new ProcessResult();
        Runtime rt = Runtime.getRuntime();
        result.process = rt.exec(command);
        if (fork.booleanValue()) {
            return result;
        }
        BufferedReader stdOut = new BufferedReader(new InputStreamReader(result.process.getInputStream()));
        BufferedReader errOut = new BufferedReader(new InputStreamReader(result.process.getErrorStream()));
        if (inputCommand != null && !inputCommand.trim().contentEquals("")) {
            OutputStream stdin = result.process.getOutputStream();
            stdin.write((String.valueOf(inputCommand) + "\n").getBytes());
            stdin.flush();
            stdin.close();
        }
        while ((line = stdOut.readLine()) != null) {
            result.stdOut = String.valueOf(result.stdOut) + line + "\r\n";
            DreamweaverBase.debug_log("[STD] " + line);
        }
        while ((line = errOut.readLine()) != null) {
            result.errOut = String.valueOf(result.errOut) + line + "\r\n";
            DreamweaverBase.debug_log("[ERR] " + line);
        }
        stdOut.close();
        errOut.close();
        result.process.waitFor();
        DreamweaverBase.debug_log("[EXIT] " + result.process.exitValue());
        return result;
    }

    protected static ProcessResult commandLine(String[] command) throws Exception {
        return DreamweaverBase.commandLine(command, false, "");
    }

    protected static void write_json(String filename, JSONObject json) throws Exception {
        DreamweaverBase.debug_log("output = " + json);
        FileWriter fstream = null;
        BufferedWriter write = null;
        try {
            fstream = new FileWriter(filename);
            write = new BufferedWriter(fstream);
            json.write(write);
        }
        finally {
            if (write != null) {
                write.close();
            }
            if (fstream != null) {
                fstream.close();
            }
        }
    }

    protected static void success(String filename, String message) throws Exception {
        JSONObject object = new JSONObject();
        try {
            object.put("success", true);
            object.put("message", message);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        DreamweaverBase.write_json(filename, object);
    }

    protected static void error(String filename, String message) throws Exception {
        DreamweaverBase.error(filename, message, "");
    }

    protected static void error(String filename, String message, String details) throws Exception {
        JSONObject json = new JSONObject();
        json.put("error", true);
        json.put("message", message);
        if (details != null && !details.trim().contentEquals("")) {
            json.put("details", details);
        }
        DreamweaverBase.write_json(filename, json);
    }
}

