/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.loops.CompositeType;

abstract class D3DPaints {
    private static Map<Integer, D3DPaints> impls = new HashMap<Integer, D3DPaints>(4, 1.0f);

    D3DPaints() {
    }

    static boolean isValid(SunGraphics2D sunGraphics2D) {
        D3DPaints d3DPaints = impls.get(sunGraphics2D.paintState);
        return d3DPaints != null && d3DPaints.isPaintValid(sunGraphics2D);
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    static {
        impls.put(2, new Gradient());
        impls.put(3, new LinearGradient());
        impls.put(4, new RadialGradient());
        impls.put(5, new Texture());
    }

    private static class Gradient
    extends D3DPaints {
        private Gradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            D3DSurfaceData d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
            D3DGraphicsDevice d3DGraphicsDevice = (D3DGraphicsDevice)d3DSurfaceData.getDeviceConfiguration().getDevice();
            return d3DGraphicsDevice.isCapPresent(65536);
        }
    }

    private static class LinearGradient
    extends MultiGradient {
        private LinearGradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            D3DSurfaceData d3DSurfaceData;
            D3DGraphicsDevice d3DGraphicsDevice;
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)sunGraphics2D.paint;
            if (linearGradientPaint.getFractions().length == 2 && linearGradientPaint.getCycleMethod() != MultipleGradientPaint.CycleMethod.REPEAT && linearGradientPaint.getColorSpace() != MultipleGradientPaint.ColorSpaceType.LINEAR_RGB && (d3DGraphicsDevice = (D3DGraphicsDevice)(d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData).getDeviceConfiguration().getDevice()).isCapPresent(65536)) {
                return true;
            }
            return super.isPaintValid(sunGraphics2D);
        }
    }

    private static abstract class MultiGradient
    extends D3DPaints {
        public static final int MULTI_MAX_FRACTIONS_D3D = 8;

        protected MultiGradient() {
        }

        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            MultipleGradientPaint multipleGradientPaint = (MultipleGradientPaint)sunGraphics2D.paint;
            if (multipleGradientPaint.getFractions().length > 8) {
                return false;
            }
            D3DSurfaceData d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
            D3DGraphicsDevice d3DGraphicsDevice = (D3DGraphicsDevice)d3DSurfaceData.getDeviceConfiguration().getDevice();
            return d3DGraphicsDevice.isCapPresent(65536);
        }
    }

    private static class RadialGradient
    extends MultiGradient {
        private RadialGradient() {
        }
    }

    private static class Texture
    extends D3DPaints {
        private Texture() {
        }

        public boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            D3DSurfaceData d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
            BufferedImage bufferedImage = texturePaint.getImage();
            D3DGraphicsDevice d3DGraphicsDevice = (D3DGraphicsDevice)d3DSurfaceData.getDeviceConfiguration().getDevice();
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (!(d3DGraphicsDevice.isCapPresent(32) || (n & n - 1) == 0 && (n2 & n2 - 1) == 0)) {
                return false;
            }
            if (!d3DGraphicsDevice.isCapPresent(64) && n != n2) {
                return false;
            }
            SurfaceData surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, d3DSurfaceData, CompositeType.SrcOver, null, false);
            if (!(surfaceData instanceof D3DSurfaceData) && !((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, d3DSurfaceData, CompositeType.SrcOver, null, false)) instanceof D3DSurfaceData)) {
                return false;
            }
            D3DSurfaceData d3DSurfaceData2 = (D3DSurfaceData)surfaceData;
            return d3DSurfaceData2.getType() == 3;
        }
    }
}

