/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.jms;

import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.axis.components.jms.JMSVendorAdapter;

public class JNDIVendorAdapter
extends JMSVendorAdapter {
    private Context context;
    public static final String CONNECTION_FACTORY_JNDI_NAME = "transport.jms.ConnectionFactoryJNDIName";

    public QueueConnectionFactory getQueueConnectionFactory(HashMap cfConfig) throws Exception {
        return (QueueConnectionFactory)this.getConnectionFactory(cfConfig);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap cfConfig) throws Exception {
        return (TopicConnectionFactory)this.getConnectionFactory(cfConfig);
    }

    private ConnectionFactory getConnectionFactory(HashMap cfProps) throws Exception {
        if (cfProps == null) {
            throw new IllegalArgumentException("noCFProps");
        }
        String jndiName = (String)cfProps.get(CONNECTION_FACTORY_JNDI_NAME);
        if (jndiName == null || jndiName.trim().length() == 0) {
            throw new IllegalArgumentException("noCFName");
        }
        Hashtable environment = new Hashtable(cfProps);
        this.context = new InitialContext(environment);
        return (ConnectionFactory)this.context.lookup(jndiName);
    }

    public Queue getQueue(QueueSession session, String name) throws Exception {
        return (Queue)this.context.lookup(name);
    }

    public Topic getTopic(TopicSession session, String name) throws Exception {
        return (Topic)this.context.lookup(name);
    }
}

