/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.android;

import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.net.telnet.TelnetClient;

public class AndroidShell {
    private TelnetClient telnet = new TelnetClient();
    private InputStream in;
    private PrintStream out;
    private String prompt = "OK";

    public AndroidShell(String server, int port) {
        try {
            this.telnet.connect(server, port);
            this.in = this.telnet.getInputStream();
            this.out = new PrintStream(this.telnet.getOutputStream());
            this.readUntil(this.prompt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String readUntil(String pattern) {
        try {
            char lastChar = pattern.charAt(pattern.length() - 1);
            StringBuffer sb = new StringBuffer();
            char ch = (char)this.in.read();
            while (true) {
                sb.append(ch);
                if (ch == lastChar && sb.toString().endsWith(pattern)) {
                    return sb.toString();
                }
                ch = (char)this.in.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(String value) {
        try {
            this.out.println(value);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String sendCommand(String command) {
        try {
            this.write(command);
            return this.readUntil(this.prompt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void disconnect() {
        try {
            this.telnet.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

