/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build;

import com.phonegap.build.PhoneGapBuildApi;
import java.io.File;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PhoneGapBuildApi1
extends PhoneGapBuildApi {
    protected String api_version = "api/v1";

    public JSONObject get_keys() throws JSONException {
        HttpGet get_keys = new HttpGet(String.valueOf(this.host) + "/" + this.api_version + "/keys");
        try {
            return new JSONObject(this.get_json_with_auth_token(get_keys));
        }
        catch (Exception e) {
            return new JSONObject("{'error':'" + e.getMessage() + "'}");
        }
    }

    public JSONObject get_keys(String platform) throws JSONException {
        HttpGet get_keys = new HttpGet(String.valueOf(this.host) + "/" + this.api_version + "/keys" + platform);
        try {
            return new JSONObject(this.get_json_with_auth_token(get_keys));
        }
        catch (Exception e) {
            return new JSONObject("{'error':'" + e.getMessage() + "'}");
        }
    }

    public JSONObject get_apps() throws JSONException {
        HttpGet get_app = new HttpGet(String.valueOf(this.host) + "/" + this.api_version + "/apps/?");
        try {
            return new JSONObject(this.get_json_with_auth_token(get_app));
        }
        catch (Exception e) {
            throw new JSONException("{'error':'" + e.getMessage() + "'}");
        }
    }

    public JSONObject get_app(int id) throws JSONException {
        HttpGet get_app = new HttpGet(String.valueOf(this.host) + "/" + this.api_version + "/apps/" + id + "?");
        try {
            return new JSONObject(this.get_json_with_auth_token(get_app));
        }
        catch (Exception e) {
            return new JSONObject("{'error':'" + e.getMessage() + "'}");
        }
    }

    public String update_application_from_file(boolean create, String title, String package_name, String version, String description, Boolean debug, Integer ios_key, Integer android_key, Integer blackberry_key, String project_dir, String output_path, Integer app_id) throws Exception {
        title = this.string_empty(title) ? "PhoneGap Build Project" : title;
        package_name = this.string_empty(package_name) ? "com.example.app" : package_name;
        version = this.string_empty(version) ? "1.0.0" : version;
        description = this.string_empty(description) ? "PhoneGap Application" : description;
        debug = this.is_null(debug) ? this.default_debug : debug;
        ios_key = this.is_null(ios_key) ? this.default_ios_key : ios_key;
        android_key = this.is_null(android_key) ? this.default_android_key : android_key;
        blackberry_key = this.is_null(blackberry_key) ? this.default_blackberry_key : blackberry_key;
        String create_method = "file";
        HashMap<String, Object> json_data = new HashMap<String, Object>();
        json_data.put("title", title);
        json_data.put("create_method", create_method);
        json_data.put("package", package_name);
        json_data.put("version", version);
        json_data.put("description", description);
        json_data.put("debug", debug);
        if (!(this.is_null(ios_key) && this.is_null(android_key) && this.is_null(blackberry_key))) {
            HashMap<String, Integer> keys = new HashMap<String, Integer>();
            if (this.is_null(ios_key)) {
                keys.put("ios", ios_key);
            }
            if (this.is_null(android_key)) {
                keys.put("android", android_key);
            }
            if (this.is_null(blackberry_key)) {
                keys.put("blackberry", blackberry_key);
            }
            json_data.put("keys", keys);
        }
        String json = this.build_json(json_data);
        PhoneGapBuildApi.debug_log(json);
        try {
            PhoneGapBuildApi.debug_log("Attempting to create zip:" + output_path);
            PhoneGapBuildApi.debug_log("Zipping contents of: " + project_dir);
            this.create_zip(project_dir, output_path);
        }
        catch (Exception e) {
            HashMap<String, Object> json_message = new HashMap<String, Object>();
            json_message.put("error", 404);
            json_message.put("message", "Failed to upload application. Unable to create zip file. Reason: " + e.getMessage());
            String message = this.build_json(json_message);
            PhoneGapBuildApi.debug_log(message);
            return message;
        }
        MultipartEntity post_entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        post_entity.addPart("data", (ContentBody)new StringBody(json));
        post_entity.addPart("file", (ContentBody)new FileBody(new File(output_path)));
        if (create) {
            HttpPost post = new HttpPost(String.valueOf(this.host) + "/" + this.api_version + "/" + "apps" + "?auth_token=" + this.auth_token);
            PhoneGapBuildApi.debug_log(String.valueOf(this.host) + "/" + this.api_version + "/" + "apps" + "?auth_token=" + this.auth_token);
            post.setEntity((HttpEntity)post_entity);
            HttpResponse response = this.http_client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            return result;
        }
        HttpPut post = new HttpPut(String.valueOf(this.host) + "/" + this.api_version + "/" + "apps" + "/" + app_id + "?auth_token=" + this.auth_token);
        PhoneGapBuildApi.debug_log(String.valueOf(this.host) + "/" + this.api_version + "/" + "apps" + "/" + app_id + "?auth_token=" + this.auth_token);
        post.setEntity((HttpEntity)post_entity);
        HttpResponse response = this.http_client.execute((HttpUriRequest)post);
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity);
        return result;
    }
}

